/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.packets;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;

public class CustomHitPacket {
    private static final Gson GSON = new Gson();
    private final UUID attackerUUID;
    private final UUID targetUUID;
    private final String hitboxName;
    private final boolean isSprinting;
    private final boolean isCritical;

    public CustomHitPacket(UUID attackerUUID, UUID targetUUID, String hitboxName, boolean isSprinting, boolean isCritical) {
        this.attackerUUID = attackerUUID;
        this.targetUUID = targetUUID;
        this.hitboxName = hitboxName;
        this.isSprinting = isSprinting;
        this.isCritical = isCritical;
    }

    public String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "CUSTOM_HIT");
        json.addProperty("attackerUUID", this.attackerUUID.toString());
        json.addProperty("targetUUID", this.targetUUID.toString());
        json.addProperty("hitboxName", this.hitboxName);
        json.addProperty("isSprinting", Boolean.valueOf(this.isSprinting));
        json.addProperty("isCritical", Boolean.valueOf(this.isCritical));
        return GSON.toJson((JsonElement)json);
    }

    public static CustomHitPacket fromJson(String json) {
        JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return new CustomHitPacket(UUID.fromString(obj.get("attackerUUID").getAsString()), UUID.fromString(obj.get("targetUUID").getAsString()), obj.get("hitboxName").getAsString(), obj.get("isSprinting").getAsBoolean(), obj.get("isCritical").getAsBoolean());
    }

    public UUID getAttackerUUID() {
        return this.attackerUUID;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public String getHitboxName() {
        return this.hitboxName;
    }

    public boolean isSprinting() {
        return this.isSprinting;
    }

    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        return String.format("CustomHitPacket{attacker=%s, target=%s, hitbox=%s, sprint=%s, crit=%s}", this.attackerUUID, this.targetUUID, this.hitboxName, this.isSprinting, this.isCritical);
    }
}

