/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.UUID;

public class AnimationStatePacket {
    private static final Gson GSON = new GsonBuilder().create();
    private String packetType;
    private String entityUUID;
    private String animationName;
    private boolean loop;
    private int duration;
    private float speed;

    public static AnimationStatePacket fromJson(String json) {
        return (AnimationStatePacket)GSON.fromJson(json, AnimationStatePacket.class);
    }

    public String getPacketType() {
        return this.packetType;
    }

    public UUID getEntityUUID() {
        return UUID.fromString(this.entityUUID);
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean isValid() {
        try {
            UUID.fromString(this.entityUUID);
            return "ANIMATION".equals(this.packetType) && this.animationName != null && !this.animationName.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }
}

