/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.mount.ClientSidePredictionHandler;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2833;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class VehicleInputSender {
    private int positionSyncTicks = 0;
    private int vehicleSyncTicks = 0;
    private Map<UUID, LocationCache> lastVehiclePositions = new HashMap<UUID, LocationCache>();
    private final ClientSidePredictionHandler predictionHandler = new ClientSidePredictionHandler();
    private static VehicleInputSender instance;
    private UUID currentVehicleUUID = null;
    private volatile boolean globalSendingBlocked = false;
    private long blockStartTime = 0L;

    public void register() {
        instance = this;
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    public static VehicleInputSender getInstance() {
        return instance;
    }

    private void onClientTick(class_310 client) {
        boolean isSeatArmorStand;
        class_746 player = client.field_1724;
        if (this.globalSendingBlocked) {
            if (System.currentTimeMillis() - this.blockStartTime > 1000L) {
                this.globalSendingBlocked = false;
                GeckoMythicClient.getLogger().info("Global sending block expired");
            } else {
                return;
            }
        }
        if (player == null || !player.method_5765()) {
            if (player != null && this.currentVehicleUUID != null) {
                GeckoMythicClient.getLogger().info("IMMEDIATE BLACKLIST: Player dismounted from {}, blacklisting immediately", (Object)this.currentVehicleUUID);
                this.predictionHandler.blacklistAndClearMount(this.currentVehicleUUID);
                this.lastVehiclePositions.remove(this.currentVehicleUUID);
                this.currentVehicleUUID = null;
            }
            if (player != null && this.lastVehiclePositions.size() > 0) {
                for (UUID vehicleId : new HashSet<UUID>(this.lastVehiclePositions.keySet())) {
                    if (this.predictionHandler.isBlacklisted(vehicleId)) continue;
                    this.predictionHandler.blacklistAndClearMount(vehicleId);
                }
                this.lastVehiclePositions.clear();
            }
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle == null) {
            return;
        }
        boolean bl = isSeatArmorStand = vehicle instanceof class_1531 && vehicle.method_16914() && vehicle.method_5797().getString().startsWith("SEAT_");
        if (!isSeatArmorStand && vehicle instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)vehicle;
            if (!GeckoMythicClient.getInstance().getMountManager().hasMountData(livingVehicle.method_5667())) {
                return;
            }
            if (this.currentVehicleUUID == null || !this.currentVehicleUUID.equals(livingVehicle.method_5667())) {
                this.currentVehicleUUID = livingVehicle.method_5667();
                GeckoMythicClient.getLogger().info("Tracking vehicle {} for immediate blacklist on dismount", (Object)this.currentVehicleUUID);
            }
            this.predictionHandler.unblacklistMount(livingVehicle.method_5667());
            float forward = player.field_3913.field_3905;
            float strafe = player.field_3913.field_3907;
            boolean jump = player.field_3913.field_3904;
            float playerYaw = player.method_36454();
            this.predictionHandler.applyPredictedMovement(livingVehicle, forward, strafe, jump, playerYaw);
            if (!this.predictionHandler.isBlacklisted(livingVehicle.method_5667())) {
                this.syncMainVehiclePosition(livingVehicle);
            } else {
                GeckoMythicClient.getLogger().debug("Skipping position sync for blacklisted mount {}", (Object)livingVehicle.method_5667());
            }
            return;
        }
        if (!isSeatArmorStand) {
            return;
        }
        class_1531 seatArmorStand = (class_1531)vehicle;
        float forward = 0.0f;
        float strafe = 0.0f;
        boolean jump = false;
        if (client.field_1690.field_1894.method_1434()) {
            forward = 1.0f;
        }
        if (client.field_1690.field_1881.method_1434()) {
            forward = -1.0f;
        }
        if (client.field_1690.field_1913.method_1434()) {
            strafe = 1.0f;
        }
        if (client.field_1690.field_1849.method_1434()) {
            strafe = -1.0f;
        }
        if (client.field_1690.field_1903.method_1434()) {
            jump = true;
        }
        if (forward != 0.0f || strafe != 0.0f || jump) {
            this.applyLocalMovementToArmorStand(seatArmorStand, forward, strafe, jump, player.method_36454());
        }
        ++this.positionSyncTicks;
        if (this.positionSyncTicks >= 3) {
            this.positionSyncTicks = 0;
            this.sendArmorStandPositionToServer(seatArmorStand);
        }
    }

    private void applyLocalMovementToArmorStand(class_1531 armorStand, float forward, float strafe, boolean jump, float yaw) {
        armorStand.method_36456(yaw);
        double speed = 0.3;
        double yawRad = Math.toRadians(yaw);
        double moveX = -Math.sin(yawRad) * (double)forward * speed + Math.cos(yawRad) * (double)strafe * speed;
        double moveZ = Math.cos(yawRad) * (double)forward * speed + Math.sin(yawRad) * (double)strafe * speed;
        double newX = armorStand.method_23317() + moveX;
        double newY = armorStand.method_23318();
        double newZ = armorStand.method_23321() + moveZ;
        if (jump && armorStand.method_24828()) {
            newY += 0.5;
        }
        armorStand.method_5814(newX, newY, newZ);
        class_243 velocity = new class_243(moveX * 3.0, jump && armorStand.method_24828() ? 0.5 : 0.0, moveZ * 3.0);
        armorStand.method_18799(velocity);
    }

    private void sendArmorStandPositionToServer(class_1531 armorStand) {
        try {
            JsonObject packet = new JsonObject();
            packet.addProperty("packetType", "ARMORSTAND_POSITION");
            packet.addProperty("armorStandUUID", armorStand.method_5845());
            packet.addProperty("x", (Number)armorStand.method_23317());
            packet.addProperty("y", (Number)armorStand.method_23318());
            packet.addProperty("z", (Number)armorStand.method_23321());
            packet.addProperty("yaw", (Number)Float.valueOf(armorStand.method_36454()));
            String json = new Gson().toJson((JsonElement)packet);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)GeckoMythicClient.CHANNEL, (class_2540)buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendInputToServer(float forward, float strafe, boolean jump, float yaw) {
        try {
            JsonObject packet = new JsonObject();
            packet.addProperty("packetType", "VEHICLE_CONTROL");
            packet.addProperty("forward", (Number)Float.valueOf(forward));
            packet.addProperty("strafe", (Number)Float.valueOf(strafe));
            packet.addProperty("jump", Boolean.valueOf(jump));
            packet.addProperty("yaw", (Number)Float.valueOf(yaw));
            String json = new Gson().toJson((JsonElement)packet);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)GeckoMythicClient.CHANNEL, (class_2540)buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendVehicleMovePacket(class_1309 vehicle) {
        try {
            class_310 client = class_310.method_1551();
            if (client.method_1562() == null) {
                return;
            }
            class_2833 packet = new class_2833((class_1297)vehicle);
            client.method_1562().method_2883((class_2596)packet);
        }
        catch (Exception e) {
            this.sendPositionToServer(vehicle);
        }
    }

    private void sendPositionToServer(class_1309 vehicle) {
        try {
            JsonObject packet = new JsonObject();
            packet.addProperty("packetType", "VEHICLE_POSITION");
            packet.addProperty("entityUUID", vehicle.method_5845());
            packet.addProperty("x", (Number)vehicle.method_23317());
            packet.addProperty("y", (Number)vehicle.method_23318());
            packet.addProperty("z", (Number)vehicle.method_23321());
            packet.addProperty("yaw", (Number)Float.valueOf(vehicle.method_36454()));
            packet.addProperty("pitch", (Number)Float.valueOf(vehicle.method_36455()));
            packet.addProperty("onGround", Boolean.valueOf(vehicle.method_24828()));
            String json = new Gson().toJson((JsonElement)packet);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)GeckoMythicClient.CHANNEL, (class_2540)buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void syncMainVehiclePosition(class_1309 vehicle) {
        UUID vehicleUUID = vehicle.method_5667();
        LocationCache currentPos = new LocationCache(vehicle);
        LocationCache lastPos = this.lastVehiclePositions.get(vehicleUUID);
        boolean needsSync = true;
        if (needsSync) {
            this.sendVehiclePositionToServer(vehicle);
            this.lastVehiclePositions.put(vehicleUUID, currentPos);
        }
    }

    private void sendVehiclePositionToServer(class_1309 vehicle) {
        if (this.globalSendingBlocked) {
            GeckoMythicClient.getLogger().warn("BLOCKED by global flag: Attempted to send position during global block");
            return;
        }
        if (this.predictionHandler.isBlacklisted(vehicle.method_5667())) {
            GeckoMythicClient.getLogger().warn("BLOCKED: Attempted to send position for blacklisted vehicle {}", (Object)vehicle.method_5845());
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !client.field_1724.method_5765() || client.field_1724.method_5854() == null || !client.field_1724.method_5854().method_5667().equals(vehicle.method_5667())) {
            GeckoMythicClient.getLogger().warn("BLOCKED: Player no longer on vehicle {}, blacklisting", (Object)vehicle.method_5845());
            this.predictionHandler.blacklistAndClearMount(vehicle.method_5667());
            return;
        }
        try {
            class_746 player = client.field_1724;
            boolean isMoving = Math.abs(vehicle.method_18798().field_1352) > 0.01 || Math.abs(vehicle.method_18798().field_1350) > 0.01;
            JsonObject packet = new JsonObject();
            packet.addProperty("packetType", "CLIENT_VEHICLE_POSITION");
            packet.addProperty("vehicleUUID", vehicle.method_5845());
            packet.addProperty("x", (Number)vehicle.method_23317());
            packet.addProperty("y", (Number)vehicle.method_23318());
            packet.addProperty("z", (Number)vehicle.method_23321());
            packet.addProperty("yaw", (Number)Float.valueOf(player != null ? player.method_36454() : vehicle.method_36454()));
            packet.addProperty("pitch", (Number)Float.valueOf(vehicle.method_36455()));
            packet.addProperty("velocityX", (Number)vehicle.method_18798().field_1352);
            packet.addProperty("velocityY", (Number)vehicle.method_18798().field_1351);
            packet.addProperty("velocityZ", (Number)vehicle.method_18798().field_1350);
            packet.addProperty("onGround", Boolean.valueOf(vehicle.method_24828()));
            packet.addProperty("isMoving", Boolean.valueOf(isMoving));
            String json = new Gson().toJson((JsonElement)packet);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)GeckoMythicClient.CHANNEL, (class_2540)buf);
            GeckoMythicClient.getLogger().debug("Sent vehicle position to server: {} at {},{},{}", new Object[]{vehicle.method_5845(), vehicle.method_23317(), vehicle.method_23318(), vehicle.method_23321()});
        }
        catch (Exception e) {
            GeckoMythicClient.getLogger().error("Failed to send vehicle position", (Throwable)e);
        }
    }

    public void updateServerAuthority(UUID vehicleUUID, double x, double y, double z, double velX, double velY, double velZ, float yaw) {
        this.predictionHandler.updateServerState(vehicleUUID, new class_243(x, y, z), new class_243(velX, velY, velZ), yaw);
    }

    public void onDismount(UUID vehicleUUID) {
        GeckoMythicClient.getLogger().info("VehicleInputSender.onDismount called for vehicle {}", (Object)vehicleUUID);
        this.globalSendingBlocked = true;
        this.blockStartTime = System.currentTimeMillis();
        GeckoMythicClient.getLogger().warn("GLOBAL SENDING BLOCKED for 1 second!");
        this.predictionHandler.blacklistAndClearMount(vehicleUUID);
        this.lastVehiclePositions.remove(vehicleUUID);
        if (vehicleUUID.equals(this.currentVehicleUUID)) {
            this.currentVehicleUUID = null;
        }
        GeckoMythicClient.getLogger().info("Blacklisted and cleared all data for vehicle {}", (Object)vehicleUUID);
    }

    public void onMount(UUID vehicleUUID) {
        GeckoMythicClient.getLogger().info("VehicleInputSender.onMount called for vehicle {}", (Object)vehicleUUID);
        this.predictionHandler.unblacklistMount(vehicleUUID);
    }

    private static class LocationCache {
        final double x;
        final double y;
        final double z;
        final float yaw;
        final float pitch;
        final double velocityX;
        final double velocityY;
        final double velocityZ;

        LocationCache(class_1309 entity) {
            this.x = entity.method_23317();
            this.y = entity.method_23318();
            this.z = entity.method_23321();
            this.yaw = entity.method_36454();
            this.pitch = entity.method_36455();
            class_243 vel = entity.method_18798();
            this.velocityX = vel.field_1352;
            this.velocityY = vel.field_1351;
            this.velocityZ = vel.field_1350;
        }

        double distanceSquaredTo(LocationCache other) {
            double dx = this.x - other.x;
            double dy = this.y - other.y;
            double dz = this.z - other.z;
            return dx * dx + dy * dy + dz * dz;
        }
    }
}

