/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.votive.geckomythicclient.GeckoMythicClient;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class VehicleControlHandler {
    private static final int SEND_INTERVAL = 1;
    private int tickCounter = 0;

    public void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.onClientTick(client));
    }

    private void onClientTick(class_310 client) {
        ++this.tickCounter;
        if (this.tickCounter >= 1) {
            this.tickCounter = 0;
            class_746 player = client.field_1724;
            if (player == null || !player.method_5765()) {
                return;
            }
            class_1297 vehicle = player.method_5854();
            if (vehicle == null) {
                return;
            }
            if (!GeckoMythicClient.getInstance().getMountManager().hasMountData(vehicle.method_5667())) {
                GeckoMythicClient.LOGGER.debug("Vehicle {} has no mount data, skipping control", (Object)vehicle.method_5667());
                return;
            }
            GeckoMythicClient.LOGGER.debug("Vehicle {} has mount data, processing control", (Object)vehicle.method_5667());
            float forward = 0.0f;
            float strafe = 0.0f;
            boolean jump = false;
            if (client.field_1690.field_1894.method_1434()) {
                forward = 1.0f;
            }
            if (client.field_1690.field_1881.method_1434()) {
                forward = -1.0f;
            }
            if (client.field_1690.field_1913.method_1434()) {
                strafe = 1.0f;
            }
            if (client.field_1690.field_1849.method_1434()) {
                strafe = -1.0f;
            }
            if (client.field_1690.field_1903.method_1434()) {
                jump = true;
            }
            if (forward != 0.0f || strafe != 0.0f || jump) {
                GeckoMythicClient.LOGGER.info("Sending vehicle control: forward={}, strafe={}, jump={}, vehicle={}", new Object[]{Float.valueOf(forward), Float.valueOf(strafe), jump, vehicle.method_5667()});
                this.sendVehicleControl(forward, strafe, jump, player.method_36454());
            }
        }
    }

    private void sendVehicleControl(float forward, float strafe, boolean jump, float yaw) {
        try {
            JsonObject packet = new JsonObject();
            packet.addProperty("packetType", "VEHICLE_CONTROL");
            packet.addProperty("forward", (Number)Float.valueOf(forward));
            packet.addProperty("strafe", (Number)Float.valueOf(strafe));
            packet.addProperty("jump", Boolean.valueOf(jump));
            packet.addProperty("yaw", (Number)Float.valueOf(yaw));
            String json = new Gson().toJson((JsonElement)packet);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)GeckoMythicClient.CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.debug("Error sending vehicle control: " + e.getMessage());
        }
    }
}

