/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.mount.MountBoneData;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MountManager {
    private final Map<UUID, MountBoneData> vehicleMountData = new ConcurrentHashMap<UUID, MountBoneData>();

    public void registerMountData(UUID vehicleUUID, MountBoneData mountData) {
        if (mountData == null) {
            GeckoMythicClient.LOGGER.warn("Attempted to register null mount data for " + String.valueOf(vehicleUUID));
            return;
        }
        this.vehicleMountData.put(vehicleUUID, mountData);
        GeckoMythicClient.LOGGER.info("Registered mount data for vehicle " + String.valueOf(vehicleUUID) + ": " + String.valueOf(mountData));
    }

    public void unregisterMountData(UUID vehicleUUID) {
        this.vehicleMountData.remove(vehicleUUID);
        GeckoMythicClient.LOGGER.debug("Unregistered mount data for vehicle " + String.valueOf(vehicleUUID));
    }

    public Optional<MountBoneData> getMountData(UUID vehicleUUID) {
        return Optional.ofNullable(this.vehicleMountData.get(vehicleUUID));
    }

    public boolean hasMountData(UUID vehicleUUID) {
        return this.vehicleMountData.containsKey(vehicleUUID);
    }

    public int getRegisteredCount() {
        return this.vehicleMountData.size();
    }

    public void clear() {
        int count = this.vehicleMountData.size();
        this.vehicleMountData.clear();
        if (count > 0) {
            GeckoMythicClient.LOGGER.info("Cleared " + count + " mount data entries");
        }
    }
}

