/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_243;

public class MountBoneData {
    private class_243 driverBonePosition;
    private final Map<Integer, class_243> passengerBonePositions;
    private final String modelIdentifier;

    public MountBoneData(String modelIdentifier) {
        this.modelIdentifier = modelIdentifier;
        this.passengerBonePositions = new HashMap<Integer, class_243>();
    }

    public void setDriverBonePosition(class_243 position) {
        this.driverBonePosition = position;
    }

    public void addPassengerBonePosition(int seatNumber, class_243 position) {
        if (seatNumber < 1 || seatNumber > 9) {
            throw new IllegalArgumentException("Seat number must be between 1 and 9, got: " + seatNumber);
        }
        this.passengerBonePositions.put(seatNumber, position);
    }

    public Optional<class_243> getDriverBonePosition() {
        return Optional.ofNullable(this.driverBonePosition);
    }

    public Optional<class_243> getPassengerBonePosition(int seatNumber) {
        return Optional.ofNullable(this.passengerBonePositions.get(seatNumber));
    }

    public Optional<class_243> getPositionForPassengerIndex(int passengerIndex) {
        if (passengerIndex == 0) {
            return this.getDriverBonePosition();
        }
        return this.getPassengerBonePosition(passengerIndex);
    }

    public boolean hasDriverBone() {
        return this.driverBonePosition != null;
    }

    public boolean hasPassengerBones() {
        return !this.passengerBonePositions.isEmpty();
    }

    public int getPassengerSeatCount() {
        return this.passengerBonePositions.size();
    }

    public int getMaxPassengerSeat() {
        return this.passengerBonePositions.keySet().stream().max(Integer::compareTo).orElse(0);
    }

    public boolean hasPassengerSeat(int seatNumber) {
        return this.passengerBonePositions.containsKey(seatNumber);
    }

    public Set<Integer> getAvailableSeats() {
        return new HashSet<Integer>(this.passengerBonePositions.keySet());
    }

    public int getTotalSeatCount() {
        int count = this.hasDriverBone() ? 1 : 0;
        return count + this.passengerBonePositions.size();
    }

    public String getModelIdentifier() {
        return this.modelIdentifier;
    }

    public String toString() {
        return "MountBoneData{model=" + this.modelIdentifier + ", hasDriver=" + this.hasDriverBone() + ", passengerSeats=" + this.passengerBonePositions.size() + ", totalSeats=" + this.getTotalSeatCount() + "}";
    }
}

