/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public class DismountBlocker {
    private static final Map<UUID, Long> recentlyDismountedEntities = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, class_243> correctPositions = new ConcurrentHashMap<UUID, class_243>();
    private static final Map<UUID, Float> correctYaws = new ConcurrentHashMap<UUID, Float>();
    private static final Map<UUID, Boolean> receivedServerUpdate = new ConcurrentHashMap<UUID, Boolean>();

    public static void markEntityAsDismounted(UUID entityUUID, float finalYaw) {
        recentlyDismountedEntities.put(entityUUID, System.currentTimeMillis());
        correctYaws.put(entityUUID, Float.valueOf(finalYaw));
        receivedServerUpdate.put(entityUUID, false);
    }

    public static void markEntityAsDismounted(UUID entityUUID) {
        DismountBlocker.markEntityAsDismounted(entityUUID, 0.0f);
    }

    public static boolean isEntityBlocked(UUID entityUUID) {
        Long dismountTime = recentlyDismountedEntities.get(entityUUID);
        return dismountTime != null;
    }

    public static void updateCorrectPosition(UUID entityUUID, double x, double y, double z) {
        Boolean hasReceived;
        if (recentlyDismountedEntities.containsKey(entityUUID) && (hasReceived = receivedServerUpdate.get(entityUUID)) != null && !hasReceived.booleanValue()) {
            correctPositions.put(entityUUID, new class_243(x, y, z));
            receivedServerUpdate.put(entityUUID, true);
        }
    }

    public static class_243 getCorrectPosition(UUID entityUUID) {
        return correctPositions.get(entityUUID);
    }

    public static void forceCorrectPosition(class_1297 entity) {
        class_243 correctPos = correctPositions.get(entity.method_5667());
        Float correctYaw = correctYaws.get(entity.method_5667());
        if (correctPos != null) {
            entity.method_5814(correctPos.field_1352, correctPos.field_1351, correctPos.field_1350);
        }
        if (correctYaw != null) {
            entity.method_36456(correctYaw.floatValue());
            entity.field_5982 = correctYaw.floatValue();
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                living.field_6283 = correctYaw.floatValue();
                living.field_6220 = correctYaw.floatValue();
                living.field_6241 = correctYaw.floatValue();
                living.field_6259 = correctYaw.floatValue();
            }
        }
    }

    public static Long getTimeSinceDismount(UUID entityUUID) {
        Long dismountTime = recentlyDismountedEntities.get(entityUUID);
        if (dismountTime == null) {
            return null;
        }
        return System.currentTimeMillis() - dismountTime;
    }

    public static void clear(UUID entityUUID) {
        recentlyDismountedEntities.remove(entityUUID);
        correctPositions.remove(entityUUID);
        correctYaws.remove(entityUUID);
        receivedServerUpdate.remove(entityUUID);
    }

    public static boolean checkAndUnblockIfMoving(class_1297 entity) {
        if (!DismountBlocker.isEntityBlocked(entity.method_5667())) {
            return false;
        }
        class_243 correctPos = DismountBlocker.getCorrectPosition(entity.method_5667());
        if (correctPos == null) {
            return false;
        }
        class_243 currentPos = entity.method_19538();
        double distance = Math.sqrt((currentPos.field_1352 - correctPos.field_1352) * (currentPos.field_1352 - correctPos.field_1352) + (currentPos.field_1351 - correctPos.field_1351) * (currentPos.field_1351 - correctPos.field_1351) + (currentPos.field_1350 - correctPos.field_1350) * (currentPos.field_1350 - correctPos.field_1350));
        if (distance > 5.0) {
            DismountBlocker.clear(entity.method_5667());
            return true;
        }
        if (!entity.method_5685().isEmpty()) {
            DismountBlocker.clear(entity.method_5667());
            return true;
        }
        return false;
    }
}

