/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.votive.geckomythicclient.GeckoMythicClient;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ClientVehicleController {
    private int syncTicks = 0;

    public void register() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
    }

    private void onClientTick(class_310 client) {
        class_746 player = client.field_1724;
        if (player == null || !player.method_5765()) {
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (!(vehicle instanceof class_1309)) {
            return;
        }
        if (!GeckoMythicClient.getInstance().getMountManager().hasMountData(vehicle.method_5667())) {
            return;
        }
        class_1309 livingVehicle = (class_1309)vehicle;
        livingVehicle.method_36456(player.method_36454());
        livingVehicle.method_36457(player.method_36455() * 0.5f);
        float forward = 0.0f;
        float strafe = 0.0f;
        boolean jump = false;
        if (client.field_1690.field_1894.method_1434()) {
            forward = 1.0f;
        }
        if (client.field_1690.field_1881.method_1434()) {
            forward = -1.0f;
        }
        if (client.field_1690.field_1913.method_1434()) {
            strafe = 1.0f;
        }
        if (client.field_1690.field_1849.method_1434()) {
            strafe = -1.0f;
        }
        if (client.field_1690.field_1903.method_1434()) {
            jump = true;
        }
        if (forward == 0.0f && strafe == 0.0f && !jump) {
            return;
        }
        double speed = 0.2;
        double yawRad = Math.toRadians(livingVehicle.method_36454());
        double moveX = -Math.sin(yawRad) * (double)forward * speed;
        double moveZ = Math.cos(yawRad) * (double)forward * speed;
        double strafeX = Math.cos(yawRad) * (double)strafe * speed;
        double strafeZ = Math.sin(yawRad) * (double)strafe * speed;
        double newX = livingVehicle.method_23317() + moveX + strafeX;
        double newY = livingVehicle.method_23318();
        double newZ = livingVehicle.method_23321() + moveZ + strafeZ;
        if (jump && livingVehicle.method_24828()) {
            newY += 0.42;
        }
        livingVehicle.method_5814(newX, newY, newZ);
        this.sendPositionToServer(livingVehicle);
    }

    private void sendPositionToServer(class_1309 vehicle) {
        try {
            JsonObject packet = new JsonObject();
            packet.addProperty("packetType", "VEHICLE_POSITION");
            packet.addProperty("entityUUID", vehicle.method_5845());
            packet.addProperty("x", (Number)vehicle.method_23317());
            packet.addProperty("y", (Number)vehicle.method_23318());
            packet.addProperty("z", (Number)vehicle.method_23321());
            packet.addProperty("yaw", (Number)Float.valueOf(vehicle.method_36454()));
            packet.addProperty("pitch", (Number)Float.valueOf(vehicle.method_36455()));
            packet.addProperty("onGround", Boolean.valueOf(vehicle.method_24828()));
            String json = new Gson().toJson((JsonElement)packet);
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)GeckoMythicClient.CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Error sending position: " + e.getMessage());
        }
    }
}

