/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import com.votive.geckomythicclient.GeckoMythicClient;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class ClientSidePredictionHandler {
    private static final int INPUT_HISTORY_SIZE = 60;
    private static final double INTERPOLATION_SPEED = 0.08;
    private static final double MAX_EXTRAPOLATION_TIME = 100.0;
    private static final double POSITION_CORRECTION_THRESHOLD = 3.0;
    private static final double MAX_MOVEMENT_PER_TICK = 0.5;
    private final Map<UUID, LinkedList<InputFrame>> inputHistory = new HashMap<UUID, LinkedList<InputFrame>>();
    private final Map<UUID, AuthoritativeState> serverStates = new HashMap<UUID, AuthoritativeState>();
    private final Map<UUID, PredictedState> predictedStates = new HashMap<UUID, PredictedState>();
    private final Map<UUID, Long> lastServerUpdate = new HashMap<UUID, Long>();
    private final Set<UUID> blacklistedMounts = new HashSet<UUID>();

    public void applyPredictedMovement(class_1309 mount, float forward, float strafe, boolean jump, float playerYaw) {
        class_243 movement;
        double movementLength;
        UUID mountId = mount.method_5667();
        long currentTime = System.currentTimeMillis();
        if (this.blacklistedMounts.contains(mountId)) {
            GeckoMythicClient.getLogger().debug("Mount {} is blacklisted, skipping prediction", (Object)mountId);
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !client.field_1724.method_5765() || client.field_1724.method_5854() == null || !client.field_1724.method_5854().method_5667().equals(mountId)) {
            if (this.predictedStates.containsKey(mountId)) {
                GeckoMythicClient.getLogger().debug("Player no longer on mount {}, clearing prediction", (Object)mountId);
            }
            this.clearMount(mountId);
            return;
        }
        mount.method_36456(playerYaw);
        mount.method_5636(playerYaw);
        mount.method_5847(playerYaw);
        InputFrame input = new InputFrame(currentTime, forward, strafe, jump, playerYaw);
        this.inputHistory.computeIfAbsent(mountId, k -> new LinkedList()).add(input);
        LinkedList<InputFrame> history = this.inputHistory.get(mountId);
        while (history.size() > 60) {
            history.removeFirst();
        }
        PredictedState predicted = this.predictedStates.computeIfAbsent(mountId, k -> new PredictedState(mount.method_19538(), mount.method_18798(), playerYaw));
        double speed = GeckoMythicClient.getMountSpeed((UUID)mountId);
        class_243 targetVelocity = this.calculateTargetVelocity(forward, strafe, playerYaw, speed *= 2.5);
        class_243 smoothedVelocity = this.interpolateVelocity(predicted.velocity, targetVelocity, 0.08);
        if (jump && mount.method_24828()) {
            smoothedVelocity = smoothedVelocity.method_1031(0.0, 0.5, 0.0);
        }
        if (!mount.method_24828()) {
            smoothedVelocity = smoothedVelocity.method_1031(0.0, -0.08, 0.0);
        }
        if ((movementLength = (movement = smoothedVelocity.method_1021(0.05)).method_1033()) > 0.5) {
            movement = movement.method_1029().method_1021(0.5);
        }
        class_243 newPosition = predicted.position.method_1019(movement);
        AuthoritativeState serverState = this.serverStates.get(mountId);
        if (serverState != null) {
            double timeSinceServer = currentTime - this.lastServerUpdate.getOrDefault(mountId, currentTime);
            if (timeSinceServer < 1000.0) {
                class_243 serverPos = serverState.position;
                double distance = newPosition.method_1022(serverPos);
                if (distance > 3.0) {
                    newPosition = serverPos;
                    smoothedVelocity = serverState.velocity;
                    GeckoMythicClient.getLogger().debug("Hard correction for mount {}: distance {}", (Object)mountId, (Object)distance);
                } else if (distance > 0.5) {
                    double correctionFactor = 0.1;
                    newPosition = newPosition.method_1019(serverPos.method_1020(newPosition).method_1021(correctionFactor));
                }
            } else if (timeSinceServer < 100.0) {
                GeckoMythicClient.getLogger().debug("Extrapolating mount {} for {}ms", (Object)mountId, (Object)timeSinceServer);
            }
        }
        mount.method_5814(newPosition.field_1352, newPosition.field_1351, newPosition.field_1350);
        mount.method_18799(smoothedVelocity);
        predicted.position = newPosition;
        predicted.velocity = smoothedVelocity;
        predicted.yaw = mount.method_36454();
    }

    public void updateServerState(UUID mountId, class_243 position, class_243 velocity, float yaw) {
        if (this.blacklistedMounts.contains(mountId)) {
            GeckoMythicClient.getLogger().debug("Mount {} is blacklisted, ignoring server state update", (Object)mountId);
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.serverStates.put(mountId, new AuthoritativeState(position, velocity, yaw, currentTime));
        this.lastServerUpdate.put(mountId, currentTime);
        this.reconcilePrediction(mountId);
    }

    private void reconcilePrediction(UUID mountId) {
        if (this.blacklistedMounts.contains(mountId)) {
            GeckoMythicClient.getLogger().debug("Mount {} is blacklisted, skipping reconciliation", (Object)mountId);
            return;
        }
        AuthoritativeState serverState = this.serverStates.get(mountId);
        if (serverState == null) {
            return;
        }
        LinkedList<InputFrame> history = this.inputHistory.get(mountId);
        if (history == null || history.isEmpty()) {
            return;
        }
        LinkedList<InputFrame> unacknowledgedInputs = new LinkedList<InputFrame>();
        for (InputFrame frame : history) {
            if (frame.timestamp <= serverState.timestamp) continue;
            unacknowledgedInputs.add(frame);
        }
        class_243 position = serverState.position;
        class_243 velocity = serverState.velocity;
        for (InputFrame input : unacknowledgedInputs) {
            class_243 targetVel = this.calculateTargetVelocity(input.forward, input.strafe, input.yaw, 0.4);
            velocity = this.interpolateVelocity(velocity, targetVel, 0.08);
            position = position.method_1019(velocity.method_1021(0.05));
        }
        PredictedState predicted = this.predictedStates.get(mountId);
        if (predicted != null) {
            predicted.position = position;
            predicted.velocity = velocity;
        }
    }

    private class_243 calculateTargetVelocity(float forward, float strafe, float yaw, double speed) {
        double motionX = 0.0;
        double motionZ = 0.0;
        if (forward != 0.0f) {
            motionX += -Math.sin(Math.toRadians(yaw)) * (double)forward * speed;
            motionZ += Math.cos(Math.toRadians(yaw)) * (double)forward * speed;
        }
        if (strafe != 0.0f) {
            motionX += Math.cos(Math.toRadians(yaw)) * (double)strafe * speed * 0.75;
            motionZ += Math.sin(Math.toRadians(yaw)) * (double)strafe * speed * 0.75;
        }
        return new class_243(motionX, 0.0, motionZ);
    }

    private class_243 interpolateVelocity(class_243 current, class_243 target, double factor) {
        return current.method_35590(target, factor);
    }

    public void clearMount(UUID mountId) {
        boolean hadData = false;
        if (this.inputHistory.remove(mountId) != null) {
            hadData = true;
        }
        if (this.serverStates.remove(mountId) != null) {
            hadData = true;
        }
        if (this.predictedStates.remove(mountId) != null) {
            hadData = true;
        }
        if (this.lastServerUpdate.remove(mountId) != null) {
            hadData = true;
        }
        if (hadData) {
            GeckoMythicClient.getLogger().info("ClientSidePredictionHandler: Cleared all prediction data for mount {}", (Object)mountId);
        }
    }

    public void blacklistAndClearMount(UUID mountId) {
        this.blacklistedMounts.add(mountId);
        GeckoMythicClient.getLogger().info("ClientSidePredictionHandler: Blacklisted mount {} to prevent further prediction", (Object)mountId);
        this.clearMount(mountId);
    }

    public void unblacklistMount(UUID mountId) {
        if (this.blacklistedMounts.remove(mountId)) {
            GeckoMythicClient.getLogger().info("ClientSidePredictionHandler: Removed mount {} from blacklist", (Object)mountId);
        }
    }

    public boolean isBlacklisted(UUID mountId) {
        return this.blacklistedMounts.contains(mountId);
    }

    private static class InputFrame {
        final long timestamp;
        final float forward;
        final float strafe;
        final boolean jump;
        final float yaw;

        InputFrame(long timestamp, float forward, float strafe, boolean jump, float yaw) {
            this.timestamp = timestamp;
            this.forward = forward;
            this.strafe = strafe;
            this.jump = jump;
            this.yaw = yaw;
        }
    }

    private static class PredictedState {
        class_243 position;
        class_243 velocity;
        float yaw;

        PredictedState(class_243 position, class_243 velocity, float yaw) {
            this.position = position;
            this.velocity = velocity;
            this.yaw = yaw;
        }
    }

    private static class AuthoritativeState {
        final class_243 position;
        final class_243 velocity;
        final float yaw;
        final long timestamp;

        AuthoritativeState(class_243 position, class_243 velocity, float yaw, long timestamp) {
            this.position = position;
            this.velocity = velocity;
            this.yaw = yaw;
            this.timestamp = timestamp;
        }
    }
}

