/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.mount;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_243;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;

public class AnimatedMountBoneTracker {
    private static final Map<UUID, AnimatedBonePositions> animatedPositions = new ConcurrentHashMap<UUID, AnimatedBonePositions>();

    public static void updateAnimatedBonePositions(UUID entityUUID, GeoModel<?> model, GeoAnimatable animatable) {
        try {
            AnimatedBonePositions positions = new AnimatedBonePositions();
            GeoBone mountBone = model.getBone("mount").orElse(null);
            if (mountBone != null && !mountBone.isHidden()) {
                double x = (double)mountBone.getPivotX() / 16.0;
                double y = (double)mountBone.getPivotY() / 16.0;
                double z = (double)mountBone.getPivotZ() / 16.0;
                positions.driverPosition = new class_243(x, y, z);
            }
            for (int i = 1; i <= 9; ++i) {
                String boneName = "pass_" + i;
                GeoBone passBone = model.getBone(boneName).orElse(null);
                if (passBone == null || passBone.isHidden()) continue;
                double x = (double)passBone.getPivotX() / 16.0;
                double y = (double)passBone.getPivotY() / 16.0;
                double z = (double)passBone.getPivotZ() / 16.0;
                positions.passengerPositions[i - 1] = new class_243(x, y, z);
            }
            animatedPositions.put(entityUUID, positions);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class_243 getAnimatedDriverPosition(UUID vehicleUUID) {
        AnimatedBonePositions positions = animatedPositions.get(vehicleUUID);
        return positions != null ? positions.driverPosition : null;
    }

    public static class_243 getAnimatedPassengerPosition(UUID vehicleUUID, int seatIndex) {
        AnimatedBonePositions positions = animatedPositions.get(vehicleUUID);
        if (positions != null && seatIndex >= 0 && seatIndex < 9) {
            return positions.passengerPositions[seatIndex];
        }
        return null;
    }

    public static void clearVehicleData(UUID vehicleUUID) {
        animatedPositions.remove(vehicleUUID);
    }

    private static class AnimatedBonePositions {
        class_243 driverPosition = null;
        class_243[] passengerPositions = new class_243[9];

        private AnimatedBonePositions() {
        }
    }
}

