/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.hitbox;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.hitbox.HitboxData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3966;

public class HitboxManager {
    private final Map<UUID, HitboxData> entityHitboxes = new ConcurrentHashMap<UUID, HitboxData>();
    private final Map<UUID, class_1297> entityCache = new ConcurrentHashMap<UUID, class_1297>();

    public void registerHitbox(UUID entityUUID, HitboxData hitboxData) {
        if (hitboxData != null && hitboxData.hasHitboxes()) {
            this.entityHitboxes.put(entityUUID, hitboxData);
            GeckoMythicClient.LOGGER.debug("Registered {} hitboxes for entity {}", (Object)hitboxData.getCubeCount(), (Object)entityUUID);
        }
    }

    public void unregisterHitbox(UUID entityUUID) {
        this.entityHitboxes.remove(entityUUID);
        this.entityCache.remove(entityUUID);
    }

    public boolean hasCustomHitbox(UUID entityUUID) {
        return this.entityHitboxes.containsKey(entityUUID);
    }

    public class_3966 rayTraceCustomHitboxes(class_243 start, class_243 end, double maxDistance) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return null;
        }
        class_3966 closestHit = null;
        double closestDistance = maxDistance;
        for (Map.Entry<UUID, HitboxData> entry : this.entityHitboxes.entrySet()) {
            UUID entityUUID = entry.getKey();
            HitboxData hitboxData = entry.getValue();
            class_1297 entity = this.entityCache.get(entityUUID);
            if (entity == null || entity.method_31481()) {
                entity = null;
                for (class_1297 e : client.field_1687.method_18112()) {
                    if (!e.method_5667().equals(entityUUID)) continue;
                    entity = e;
                    this.entityCache.put(entityUUID, e);
                    break;
                }
            }
            if (entity == null || !(entity instanceof class_1309)) {
                this.entityCache.remove(entityUUID);
                continue;
            }
            for (HitboxData.HitboxCube cube : hitboxData.getCubes()) {
                double distance;
                class_243 entityPos;
                class_238 worldBox = cube.createWorldBox(entityPos = entity.method_19538(), class_243.field_1353, 1.0);
                class_243 hitPos = worldBox.method_992(start, end).orElse(null);
                if (hitPos == null || !((distance = start.method_1022(hitPos)) < closestDistance)) continue;
                closestDistance = distance;
                closestHit = new class_3966(entity, hitPos);
            }
        }
        return closestHit;
    }

    public void clear() {
        this.entityHitboxes.clear();
        this.entityCache.clear();
    }

    public int getHitboxCount() {
        return this.entityHitboxes.size();
    }
}

