/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.emotecraft;

import com.votive.geckomythicclient.GeckoMythicClient;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_742;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;

public class EmoteCraftBridge {
    private static final Map<String, String[]> BONE_NAME_VARIANTS = new HashMap<String, String[]>();
    private static final String[] EMOTE_BONES = new String[]{"head", "body", "rightArm", "leftArm", "rightLeg", "leftLeg"};

    public static void applyEmoteCraftAnimations(class_1657 player, Map<String, CoreGeoBone> boneMap, float tickDelta) {
        if (!(player instanceof class_742)) {
            return;
        }
        class_742 clientPlayer = (class_742)player;
        try {
            AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((class_742)clientPlayer);
            if (animationStack == null || !animationStack.isActive()) {
                return;
            }
            animationStack.setupAnim(tickDelta);
            for (String boneName : EMOTE_BONES) {
                EmoteCraftBridge.applyBoneTransform(boneMap, boneName, animationStack, tickDelta);
            }
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("EmoteCraft integration error", (Throwable)e);
        }
    }

    private static void applyBoneTransform(Map<String, CoreGeoBone> boneMap, String emoteBoneName, AnimationStack animationStack, float tickDelta) {
        try {
            Vec3f bendBase;
            Vec3f bend;
            Vec3f defaultRot;
            Vec3f rotation;
            CoreGeoBone bone = EmoteCraftBridge.findBone(boneMap, emoteBoneName);
            if (bone == null) {
                return;
            }
            Vec3f defaultPos = EmoteCraftBridge.getDefaultPosition(emoteBoneName);
            Vec3f position = animationStack.get3DTransform(emoteBoneName, TransformType.POSITION, tickDelta, defaultPos);
            if (position != null) {
                bone.setPosX((((Float)position.getX()).floatValue() - ((Float)defaultPos.getX()).floatValue()) / 16.0f);
                bone.setPosY((((Float)position.getY()).floatValue() - ((Float)defaultPos.getY()).floatValue()) / 16.0f);
                bone.setPosZ((((Float)position.getZ()).floatValue() - ((Float)defaultPos.getZ()).floatValue()) / 16.0f);
            }
            if ((rotation = animationStack.get3DTransform(emoteBoneName, TransformType.ROTATION, tickDelta, defaultRot = new Vec3f(0.0f, 0.0f, 0.0f))) != null) {
                bone.setRotX(-((Float)rotation.getX()).floatValue());
                bone.setRotY(-((Float)rotation.getY()).floatValue());
                bone.setRotZ(-((Float)rotation.getZ()).floatValue());
            }
            if (!emoteBoneName.equals("head") && (bend = animationStack.get3DTransform(emoteBoneName, TransformType.BEND, tickDelta, bendBase = new Vec3f(0.0f, 0.0f, 0.0f))) != null && (Math.abs(((Float)bend.getX()).floatValue()) > 0.001f || Math.abs(((Float)bend.getY()).floatValue()) > 0.001f)) {
                CoreGeoBone lowerBone;
                Object lowerBoneName = emoteBoneName + "Lower";
                if (emoteBoneName.equals("body")) {
                    lowerBoneName = "bodyLower";
                }
                if ((lowerBone = EmoteCraftBridge.findBone(boneMap, (String)lowerBoneName)) != null) {
                    float bendDirection = -((Float)bend.getX()).floatValue();
                    float bendAmount = ((Float)bend.getY()).floatValue();
                    if (emoteBoneName.equals("body")) {
                        lowerBone.setRotX((float)(Math.sin(bendDirection) * (double)bendAmount));
                        lowerBone.setRotZ((float)(Math.cos(bendDirection) * (double)bendAmount));
                    } else if (emoteBoneName.equals("rightArm") || emoteBoneName.equals("leftArm")) {
                        lowerBone.setRotY(-bendAmount);
                    } else if (emoteBoneName.equals("rightLeg") || emoteBoneName.equals("leftLeg")) {
                        lowerBone.setRotX(bendAmount);
                    }
                }
            }
        }
        catch (Exception e) {
            GeckoMythicClient.LOGGER.error("Failed to apply transform for " + emoteBoneName, (Throwable)e);
        }
    }

    private static Vec3f getDefaultPosition(String emoteBoneName) {
        switch (emoteBoneName) {
            case "rightArm": {
                return new Vec3f(-5.0f, 2.0f, 0.0f);
            }
            case "leftArm": {
                return new Vec3f(5.0f, 2.0f, 0.0f);
            }
            case "rightLeg": {
                return new Vec3f(-1.9f, 12.0f, 0.1f);
            }
            case "leftLeg": {
                return new Vec3f(1.9f, 12.0f, 0.1f);
            }
        }
        return new Vec3f(0.0f, 0.0f, 0.0f);
    }

    private static CoreGeoBone findBone(Map<String, CoreGeoBone> boneMap, String emotecraftBoneName) {
        String[] variants = BONE_NAME_VARIANTS.get(emotecraftBoneName);
        if (variants == null) {
            return null;
        }
        for (String variant : variants) {
            CoreGeoBone bone = boneMap.get(variant);
            if (bone == null) continue;
            return bone;
        }
        return null;
    }

    static {
        BONE_NAME_VARIANTS.put("head", new String[]{"head", "Head", "bipedHead"});
        BONE_NAME_VARIANTS.put("body", new String[]{"body", "Body", "torso", "Torso", "bipedBody"});
        BONE_NAME_VARIANTS.put("bodyLower", new String[]{"bodyLower", "BodyLower", "torsoLower", "TorsoLower", "waist", "Waist", "lowerBody", "LowerBody"});
        BONE_NAME_VARIANTS.put("rightArm", new String[]{"rightArm", "RightArm", "bipedRightArm", "armRight", "ArmRight"});
        BONE_NAME_VARIANTS.put("leftArm", new String[]{"leftArm", "LeftArm", "bipedLeftArm", "armLeft", "ArmLeft"});
        BONE_NAME_VARIANTS.put("rightArmLower", new String[]{"rightArmLower", "RightArmLower", "rightForearm", "RightForearm", "rightElbow", "RightElbow"});
        BONE_NAME_VARIANTS.put("leftArmLower", new String[]{"leftArmLower", "LeftArmLower", "leftForearm", "LeftForearm", "leftElbow", "LeftElbow"});
        BONE_NAME_VARIANTS.put("rightLeg", new String[]{"rightLeg", "RightLeg", "bipedRightLeg", "legRight", "LegRight"});
        BONE_NAME_VARIANTS.put("leftLeg", new String[]{"leftLeg", "LeftLeg", "bipedLeftLeg", "legLeft", "LeftLeg"});
        BONE_NAME_VARIANTS.put("rightLegLower", new String[]{"rightLegLower", "RightLegLower", "rightShin", "RightShin", "rightKnee", "RightKnee"});
        BONE_NAME_VARIANTS.put("leftLegLower", new String[]{"leftLegLower", "LeftLegLower", "leftShin", "LeftShin", "leftKnee", "LeftKnee"});
    }
}

