/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.client;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_310;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GeckoEntityWrapper
implements GeoReplacedEntity {
    private class_1309 wrappedEntity;
    private final String modelNamespace;
    private final String modelName;
    private final Map<String, String> animationMappings;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private volatile String triggeredAnimation = null;
    private volatile boolean triggeredLoop = false;
    private volatile int triggeredDuration = 0;
    private final AtomicInteger triggeredTicks = new AtomicInteger(0);
    private volatile String customIdleAnimation = null;
    private volatile String customWalkAnimation = null;
    private class_243 lastPosition = null;
    private long lastPositionCheckAge = 0L;
    private boolean isCurrentlyWalking = false;
    private static final int POSITION_CHECK_INTERVAL = 3;
    private static final double WALK_START_THRESHOLD = 0.15;
    private static final double WALK_STOP_THRESHOLD = 0.1;
    private static final double TELEPORT_THRESHOLD = 5.0;

    public GeckoEntityWrapper(class_1309 entity, String modelNamespace, String modelName, Map<String, String> animationMappings) {
        this.wrappedEntity = entity;
        this.modelNamespace = modelNamespace;
        this.modelName = modelName;
        this.animationMappings = animationMappings;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main_controller", 0, state -> {
            if (this.triggeredAnimation != null) {
                int currentTicks = this.triggeredTicks.incrementAndGet();
                if (this.triggeredDuration > 0 && currentTicks >= this.triggeredDuration) {
                    this.triggeredAnimation = null;
                    this.triggeredLoop = false;
                    this.triggeredDuration = 0;
                    this.triggeredTicks.set(0);
                    try {
                        state.getController().forceAnimationReset();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.wrappedEntity != null) {
                        boolean isMoving;
                        double velocitySquared = this.wrappedEntity.method_18798().method_37268();
                        boolean bl = isMoving = velocitySquared > 0.001 || this.isCurrentlyWalking;
                        if (isMoving && this.customWalkAnimation != null) {
                            return state.setAndContinue(RawAnimation.begin().thenLoop(this.customWalkAnimation));
                        }
                        String fallbackIdle = this.customIdleAnimation != null ? this.customIdleAnimation : "idle";
                        return state.setAndContinue(RawAnimation.begin().thenLoop(fallbackIdle));
                    }
                    String fallbackIdle = this.customIdleAnimation != null ? this.customIdleAnimation : "idle";
                    return state.setAndContinue(RawAnimation.begin().thenLoop(fallbackIdle));
                }
                if (this.triggeredLoop) {
                    return state.setAndContinue(RawAnimation.begin().thenLoop(this.triggeredAnimation));
                }
                return state.setAndContinue(RawAnimation.begin().thenPlay(this.triggeredAnimation));
            }
            if (this.wrappedEntity != null) {
                if (this.wrappedEntity.method_29504() || this.wrappedEntity.method_6032() <= 0.0f) {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("death"));
                }
                if (this.wrappedEntity.field_6252) {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("attack"));
                }
                if (this.wrappedEntity.method_5681()) {
                    return state.setAndContinue(RawAnimation.begin().thenLoop("swim"));
                }
                class_310 client = class_310.method_1551();
                boolean isLocalPlayer = client.field_1724 != null && this.wrappedEntity.method_5667().equals(client.field_1724.method_5667());
                boolean isMount = this.wrappedEntity.method_5782();
                boolean isPlayerMount = client.field_1724 != null && client.field_1724.method_5765() && client.field_1724.method_5854() != null && client.field_1724.method_5854().method_5667().equals(this.wrappedEntity.method_5667());
                double velocitySquared = this.wrappedEntity.method_18798().method_37268();
                if (isMount || isPlayerMount) {
                    double mountVelocityThreshold;
                    long currentAge = this.wrappedEntity.field_6012;
                    class_243 currentPos = this.wrappedEntity.method_19538();
                    if (this.lastPosition == null || currentAge - this.lastPositionCheckAge >= 3L) {
                        if (this.lastPosition != null) {
                            double deltaX = currentPos.field_1352 - this.lastPosition.field_1352;
                            double deltaZ = currentPos.field_1350 - this.lastPosition.field_1350;
                            double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                            double distance = Math.sqrt(distanceSquared);
                            double ticksSinceLastCheck = Math.max(1L, currentAge - this.lastPositionCheckAge);
                            double distancePerTick = distance / ticksSinceLastCheck;
                            if (distance < 5.0) {
                                if (this.isCurrentlyWalking) {
                                    if (distancePerTick < 0.01) {
                                        this.isCurrentlyWalking = false;
                                    }
                                } else if (distancePerTick > 0.015) {
                                    this.isCurrentlyWalking = true;
                                }
                            }
                        }
                        this.lastPosition = currentPos;
                        this.lastPositionCheckAge = currentAge;
                    }
                    if (velocitySquared > (mountVelocityThreshold = 0.01)) {
                        this.isCurrentlyWalking = true;
                    }
                    if (this.isCurrentlyWalking) {
                        String walkAnim = this.customWalkAnimation != null ? this.customWalkAnimation : "walk";
                        return state.setAndContinue(RawAnimation.begin().thenLoop(walkAnim));
                    }
                } else if (isLocalPlayer) {
                    double walkStopThreshold;
                    double walkStartThreshold;
                    boolean isSneaking = this.wrappedEntity.method_5715();
                    if (isSneaking) {
                        walkStartThreshold = 3.0E-4;
                        walkStopThreshold = 5.0E-5;
                    } else {
                        walkStartThreshold = 0.002;
                        walkStopThreshold = 1.0E-4;
                    }
                    if (this.isCurrentlyWalking) {
                        if (velocitySquared < walkStopThreshold) {
                            this.isCurrentlyWalking = false;
                        }
                    } else if (velocitySquared > walkStartThreshold) {
                        this.isCurrentlyWalking = true;
                    }
                    if (this.isCurrentlyWalking) {
                        String walkAnim = this.customWalkAnimation != null ? this.customWalkAnimation : "walk";
                        return state.setAndContinue(RawAnimation.begin().thenLoop(walkAnim));
                    }
                } else {
                    float limbDist = this.wrappedEntity.field_6225;
                    if (limbDist > 0.1f) {
                        String walkAnim = this.customWalkAnimation != null ? this.customWalkAnimation : "walk";
                        return state.setAndContinue(RawAnimation.begin().thenLoop(walkAnim));
                    }
                }
            }
            String idleAnim = this.customIdleAnimation != null ? this.customIdleAnimation : "idle";
            return state.setAndContinue(RawAnimation.begin().thenLoop(idleAnim));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class_1299<?> getReplacingEntityType() {
        if (this.wrappedEntity == null) {
            return class_1299.field_6051;
        }
        return this.wrappedEntity.method_5864();
    }

    public String determineAnimationState() {
        if (this.wrappedEntity == null) {
            return "idle";
        }
        if (this.wrappedEntity.method_29504() || this.wrappedEntity.method_6032() <= 0.0f) {
            return "death";
        }
        if (this.wrappedEntity.field_6252) {
            return "attack";
        }
        if (this.wrappedEntity.method_5681()) {
            return "swim";
        }
        return this.isCurrentlyWalking ? "walk" : "idle";
    }

    public class_1309 getWrappedEntity() {
        return this.wrappedEntity;
    }

    public void updateEntity(class_1309 entity) {
        this.wrappedEntity = entity;
    }

    public String getModelNamespace() {
        return this.modelNamespace;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelIdentifier() {
        return this.modelNamespace + ":" + this.modelName;
    }

    public Map<String, String> getAnimationMappings() {
        return this.animationMappings;
    }

    public void triggerAnimation(String animationName, boolean loop, int duration) {
        this.triggeredAnimation = animationName;
        this.triggeredLoop = loop;
        this.triggeredDuration = duration;
        this.triggeredTicks.set(0);
        try {
            AnimationController controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(this.wrappedEntity != null ? (long)this.wrappedEntity.method_5628() : 0L).getAnimationControllers().get("main_controller");
            if (controller != null) {
                controller.forceAnimationReset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopTriggeredAnimation() {
        this.triggeredAnimation = null;
        this.triggeredLoop = false;
        this.triggeredDuration = 0;
        this.triggeredTicks.set(0);
    }

    public void setDefaultAnimations(String idleAnimation, String walkAnimation) {
        if (idleAnimation != null) {
            this.customIdleAnimation = idleAnimation;
        }
        if (walkAnimation != null) {
            this.customWalkAnimation = walkAnimation;
        }
        this.isCurrentlyWalking = false;
        this.lastPosition = null;
        this.lastPositionCheckAge = 0L;
    }

    public synchronized void setDefaultAnimationsAndStopTriggered(String idleAnimation, String walkAnimation) {
        this.triggeredAnimation = null;
        this.triggeredLoop = false;
        this.triggeredDuration = 0;
        this.triggeredTicks.set(0);
        if (idleAnimation != null) {
            this.customIdleAnimation = idleAnimation;
        }
        if (walkAnimation != null) {
            this.customWalkAnimation = walkAnimation;
        }
        this.isCurrentlyWalking = false;
        this.lastPosition = null;
        this.lastPositionCheckAge = 0L;
    }

    public void resetDefaultAnimations() {
        this.customIdleAnimation = null;
        this.customWalkAnimation = null;
    }

    public void reset() {
        this.triggeredAnimation = null;
        this.triggeredLoop = false;
        this.triggeredDuration = 0;
        this.triggeredTicks.set(0);
        this.customIdleAnimation = null;
        this.customWalkAnimation = null;
        this.lastPosition = null;
        this.lastPositionCheckAge = 0L;
        this.isCurrentlyWalking = false;
    }
}

