/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.client;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.client.GeckoEntityWrapper;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1309;

public class GeckoEntityModelRegistry {
    private final Map<UUID, GeckoEntityWrapper> entityWrappers = new ConcurrentHashMap<UUID, GeckoEntityWrapper>();
    private final Map<UUID, PendingModelData> pendingModels = new ConcurrentHashMap<UUID, PendingModelData>();
    private static final long PENDING_MODEL_TIMEOUT = 600000L;

    public GeckoEntityWrapper getWrapper(class_1309 entity, UUID entityUUID, String modelNamespace, String modelName, Map<String, String> animationMappings) {
        return this.entityWrappers.computeIfAbsent(entityUUID, uuid -> {
            GeckoMythicClient.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0432\u0440\u0430\u043f\u0435\u0440\u0430 \u0434\u043b\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 {}", uuid);
            return new GeckoEntityWrapper(entity, modelNamespace, modelName, animationMappings);
        });
    }

    public boolean hasModel(UUID entityUUID) {
        return this.entityWrappers.containsKey(entityUUID);
    }

    public GeckoEntityWrapper getWrapper(UUID entityUUID) {
        return this.entityWrappers.get(entityUUID);
    }

    public void unregisterEntity(UUID entityUUID) {
        PendingModelData removedPending;
        GeckoEntityWrapper removed = this.entityWrappers.remove(entityUUID);
        if (removed != null) {
            removed.reset();
            GeckoMythicClient.getLogger().debug("Wrapper \u0443\u0434\u0430\u043b\u0435\u043d \u0434\u043b\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 {}", (Object)entityUUID);
        }
        if ((removedPending = this.pendingModels.remove(entityUUID)) != null) {
            GeckoMythicClient.getLogger().debug("Pending \u043c\u043e\u0434\u0435\u043b\u044c \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0434\u043b\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 {}", (Object)entityUUID);
        }
        GeckoMythicClient.getLogger().info("\u041c\u043e\u0434\u0435\u043b\u044c \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0434\u043b\u044f \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 {} (wrapper: {}, pending: {})", new Object[]{entityUUID, removed != null, removedPending != null});
    }

    public int getRegisteredCount() {
        return this.entityWrappers.size();
    }

    public void clear() {
        GeckoMythicClient.LOGGER.info("Clearing model registry: {} wrappers, {} pending", (Object)this.entityWrappers.size(), (Object)this.pendingModels.size());
        this.entityWrappers.values().forEach(wrapper -> {
            if (wrapper != null) {
                wrapper.reset();
            }
        });
        this.entityWrappers.clear();
        this.pendingModels.clear();
        GeckoMythicClient.LOGGER.info("Model registry cleared");
    }

    public void registerEntityModel(UUID entityUUID, String modelNamespace, String modelName, Map<String, String> animationMappings) {
        String newModelId = modelNamespace + ":" + modelName;
        PendingModelData newPending = new PendingModelData(modelNamespace, modelName, animationMappings);
        this.pendingModels.put(entityUUID, newPending);
        this.entityWrappers.computeIfPresent(entityUUID, (uuid, existingWrapper) -> {
            String existingModelId = existingWrapper.getModelIdentifier();
            if (!existingModelId.equals(newModelId)) {
                GeckoMythicClient.getLogger().debug("Removed old wrapper for entity {} (model changed from {} to {})", new Object[]{uuid, existingModelId, newModelId});
                existingWrapper.reset();
                return null;
            }
            return existingWrapper;
        });
        GeckoMythicClient.getLogger().debug("Registered model {} for entity {} (pending: {})", new Object[]{newModelId, entityUUID, this.pendingModels.containsKey(entityUUID)});
    }

    public GeckoEntityWrapper getOrCreateWrapper(class_1309 entity) {
        UUID entityUUID = entity.method_5667();
        GeckoEntityWrapper existing = this.entityWrappers.get(entityUUID);
        if (existing != null) {
            existing.updateEntity(entity);
            return existing;
        }
        PendingModelData pending = this.pendingModels.get(entityUUID);
        if (pending == null) {
            return null;
        }
        return this.entityWrappers.computeIfAbsent(entityUUID, uuid -> {
            PendingModelData currentPending = this.pendingModels.get(uuid);
            if (currentPending == null) {
                return null;
            }
            GeckoEntityWrapper wrapper = new GeckoEntityWrapper(entity, currentPending.modelNamespace, currentPending.modelName, currentPending.animationMappings);
            if (currentPending.pendingIdleAnimation != null || currentPending.pendingWalkAnimation != null) {
                wrapper.setDefaultAnimationsAndStopTriggered(currentPending.pendingIdleAnimation, currentPending.pendingWalkAnimation);
                GeckoMythicClient.getLogger().debug("Applied pending DEFAULT_STATE to new wrapper for entity {}: idle={}, walk={}", new Object[]{uuid, currentPending.pendingIdleAnimation, currentPending.pendingWalkAnimation});
            }
            this.pendingModels.remove(uuid);
            try {
                wrapper.getAnimatableInstanceCache().getManagerForId((long)entity.method_5628());
            }
            catch (Exception e) {
                GeckoMythicClient.getLogger().error("Failed to initialize animation system for entity {}", uuid, (Object)e);
            }
            return wrapper;
        });
    }

    public boolean hasModelData(UUID entityUUID) {
        return this.entityWrappers.containsKey(entityUUID) || this.pendingModels.containsKey(entityUUID);
    }

    public void setPendingDefaultState(UUID entityUUID, String idleAnimation, String walkAnimation) {
        PendingModelData pending = this.pendingModels.get(entityUUID);
        if (pending != null) {
            pending.pendingIdleAnimation = idleAnimation;
            pending.pendingWalkAnimation = walkAnimation;
            GeckoMythicClient.getLogger().debug("Saved pending DEFAULT_STATE for entity {}: idle={}, walk={}", new Object[]{entityUUID, idleAnimation, walkAnimation});
        }
    }

    public void cleanupOldPendingModels() {
        long now = System.currentTimeMillis();
        AtomicInteger cleaned = new AtomicInteger(0);
        this.pendingModels.entrySet().removeIf(entry -> {
            if (now - ((PendingModelData)entry.getValue()).timestamp > 600000L) {
                GeckoMythicClient.getLogger().debug("Removed expired pending model for entity {} (age: {}ms)", entry.getKey(), (Object)(now - ((PendingModelData)entry.getValue()).timestamp));
                cleaned.incrementAndGet();
                return true;
            }
            return false;
        });
    }

    private static class PendingModelData {
        final String modelNamespace;
        final String modelName;
        final Map<String, String> animationMappings;
        final long timestamp;
        String pendingIdleAnimation;
        String pendingWalkAnimation;

        PendingModelData(String modelNamespace, String modelName, Map<String, String> animationMappings) {
            this.modelNamespace = modelNamespace;
            this.modelName = modelName;
            this.animationMappings = animationMappings;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

