/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient.api;

import com.votive.geckomythicclient.GeckoMythicClient;
import com.votive.geckomythicclient.client.GeckoEntityWrapper;
import com.votive.geckomythicclient.hitbox.HitboxData;
import com.votive.geckomythicclient.hitbox.HitboxParser;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class GeckoModelAPI {
    public static boolean hasModel(class_1657 player) {
        if (player == null) {
            return false;
        }
        try {
            GeckoMythicClient instance = GeckoMythicClient.getInstance();
            if (instance == null || instance.getModelRegistry() == null) {
                return false;
            }
            return instance.getModelRegistry().hasModel(player.method_5667());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    public static class_243 getHeadOffset(class_1657 player) {
        if (player == null) {
            return null;
        }
        try {
            GeckoMythicClient instance = GeckoMythicClient.getInstance();
            if (instance == null) {
                return new class_243(0.0, 1.8, 0.0);
            }
            GeckoEntityWrapper wrapper = instance.getModelRegistry().getWrapper(player.method_5667());
            if (wrapper == null) {
                return new class_243(0.0, 1.8, 0.0);
            }
            HitboxData hitboxData = HitboxParser.parseHitboxes(wrapper.getModelNamespace(), wrapper.getModelName());
            if (hitboxData != null && hitboxData.hasHitboxes()) {
                double maxY = 0.0;
                for (HitboxData.HitboxCube cube : hitboxData.getCubes()) {
                    double cubeTop = cube.origin.field_1351 + cube.size.field_1351;
                    maxY = Math.max(maxY, cubeTop);
                }
                return new class_243(0.0, maxY, 0.0);
            }
            return new class_243(0.0, 1.8, 0.0);
        }
        catch (Exception e) {
            return new class_243(0.0, 1.8, 0.0);
        }
    }

    public static float getModelScale(class_1657 player) {
        if (player == null) {
            return 1.0f;
        }
        try {
            GeckoMythicClient instance = GeckoMythicClient.getInstance();
            if (instance == null) {
                return 1.0f;
            }
            GeckoEntityWrapper wrapper = instance.getModelRegistry().getWrapper(player.method_5667());
            if (wrapper == null) {
                return 1.0f;
            }
            HitboxData hitboxData = HitboxParser.parseHitboxes(wrapper.getModelNamespace(), wrapper.getModelName());
            if (hitboxData == null || !hitboxData.hasHitboxes()) {
                return 1.0f;
            }
            double modelHeight = 0.0;
            for (HitboxData.HitboxCube cube : hitboxData.getCubes()) {
                double cubeTop = cube.origin.field_1351 + cube.size.field_1351;
                modelHeight = Math.max(modelHeight, cubeTop);
            }
            return (float)(modelHeight / 1.8);
        }
        catch (Exception e) {
            return 1.0f;
        }
    }
}

