/*
 * Decompiled with CFR 0.152.
 */
package com.votive.geckomythicclient;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.votive.geckomythicclient.client.GeckoEntityModelRegistry;
import com.votive.geckomythicclient.client.GeckoEntityWrapper;
import com.votive.geckomythicclient.hitbox.HitboxData;
import com.votive.geckomythicclient.hitbox.HitboxManager;
import com.votive.geckomythicclient.hitbox.HitboxParser;
import com.votive.geckomythicclient.packets.AnimationStatePacket;
import com.votive.geckomythicclient.packets.DefaultStatePacket;
import com.votive.geckomythicclient.packets.EntityModelPacket;
import com.votive.geckomythicclient.packets.RemoveModelPacket;
import com.votive.geckomythicclient.packets.RequestModelPacket;
import com.votive.geckomythicclient.renderer.GeckoEntityRenderer;
import com.votive.geckomythicclient.util.ModelResourceValidator;
import io.netty.buffer.Unpooled;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeckoMythicClient
implements ClientModInitializer {
    public static final String MOD_ID = "geckomythicclient";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"geckomythicclient");
    public static final class_2960 CHANNEL = new class_2960("geckomythic", "models");
    private static GeckoMythicClient instance;
    private GeckoEntityModelRegistry modelRegistry;
    private HitboxManager hitboxManager;
    private final Set<UUID> sentEyeHeightPlayers = new ConcurrentHashMap().keySet(true);

    public void onInitializeClient() {
        instance = this;
        this.modelRegistry = new GeckoEntityModelRegistry();
        this.hitboxManager = new HitboxManager();
        this.registerPacketHandlers();
        this.registerDisconnectHandler();
        this.registerJoinHandler();
        this.startPendingModelsCleanup();
    }

    private void startPendingModelsCleanup() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 != null && client.field_1687.method_8510() % 600L == 0L) {
                this.modelRegistry.cleanupOldPendingModels();
            }
        });
    }

    private void registerDisconnectHandler() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            LOGGER.info("========================================");
            LOGGER.info("DISCONNECTING FROM SERVER!");
            LOGGER.info("Clearing all data...");
            LOGGER.info("  - Model registry: {} wrappers, {} pending", (Object)this.modelRegistry.getRegisteredCount(), (Object)(this.modelRegistry.hasModelData(client.field_1724 != null ? client.field_1724.method_5667() : null) ? "has local player model" : "no local player model"));
            LOGGER.info("  - Sent eye heights: {} players", (Object)this.sentEyeHeightPlayers.size());
            this.modelRegistry.clear();
            this.hitboxManager.clear();
            this.sentEyeHeightPlayers.clear();
            GeckoEntityRenderer.clearCache();
            ModelResourceValidator.clearCache();
            LOGGER.info("All client data cleared!");
            LOGGER.info("========================================");
        });
    }

    private void registerJoinHandler() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            LOGGER.info("========================================");
            LOGGER.info("JOINED SERVER!");
            LOGGER.info("Checking for stale data...");
            int wrappers = this.modelRegistry.getRegisteredCount();
            int sentHeights = this.sentEyeHeightPlayers.size();
            if (wrappers > 0 || sentHeights > 0) {
                LOGGER.warn("FOUND STALE DATA FROM PREVIOUS SESSION!");
                LOGGER.warn("  - Model registry: {} wrappers", (Object)wrappers);
                LOGGER.warn("  - Sent eye heights: {} players", (Object)sentHeights);
                LOGGER.warn("DISCONNECT handler did NOT fire! Clearing now...");
                this.modelRegistry.clear();
                this.hitboxManager.clear();
                this.sentEyeHeightPlayers.clear();
                GeckoEntityRenderer.clearCache();
                ModelResourceValidator.clearCache();
                LOGGER.info("Stale data cleared on JOIN!");
            } else {
                LOGGER.info("No stale data found. Clean join.");
            }
            LOGGER.info("========================================");
        });
    }

    private void registerPacketHandlers() {
        LOGGER.info("Registering packet handler for channel: " + String.valueOf(CHANNEL));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL, (client, handler, buf, responseSender) -> {
            LOGGER.info("=== Packet received on " + String.valueOf(CHANNEL) + ", size: " + buf.readableBytes() + " bytes ===");
            try {
                byte[] arrayData = new byte[buf.readableBytes()];
                buf.readBytes(arrayData);
                ByteArrayDataInput in = ByteStreams.newDataInput((byte[])arrayData);
                String json = in.readUTF();
                LOGGER.info("Received JSON: " + json);
                JsonObject jsonObj = (JsonObject)new Gson().fromJson(json, JsonObject.class);
                String packetType = jsonObj.has("packetType") ? jsonObj.get("packetType").getAsString() : "MODEL";
                LOGGER.info("Packet type: " + packetType);
                if (packetType.equals("MODEL")) {
                    LOGGER.info("MODEL packet received! JSON: " + json);
                }
                client.execute(() -> {
                    try {
                        switch (packetType) {
                            case "MODEL": {
                                EntityModelPacket modelPacket = EntityModelPacket.fromJson(json);
                                if (modelPacket != null && modelPacket.isValid()) {
                                    this.handleModelPacket(modelPacket);
                                    break;
                                }
                                LOGGER.error("MODEL packet failed validation! Packet: {}, Valid: {}", (Object)modelPacket, (Object)(modelPacket != null && modelPacket.isValid() ? 1 : 0));
                                if (modelPacket != null) {
                                    LOGGER.error("  - EntityUUID: {}", (Object)modelPacket.getEntityUUID());
                                    LOGGER.error("  - Model: {}", (Object)modelPacket.getModelIdentifier());
                                }
                                break;
                            }
                            case "ANIMATION": {
                                AnimationStatePacket animPacket = AnimationStatePacket.fromJson(json);
                                if (animPacket != null && animPacket.isValid()) {
                                    this.handleAnimationPacket(animPacket);
                                    break;
                                }
                                LOGGER.warn("ANIMATION packet failed validation or is null");
                                break;
                            }
                            case "REMOVE_MODEL": {
                                RemoveModelPacket removePacket = RemoveModelPacket.fromJson(json);
                                if (removePacket != null && removePacket.isValid()) {
                                    this.handleRemoveModelPacket(removePacket);
                                    break;
                                }
                                LOGGER.warn("REMOVE_MODEL packet failed validation or is null");
                                break;
                            }
                            case "DEFAULT_STATE": {
                                DefaultStatePacket defaultStatePacket = DefaultStatePacket.fromJson(json);
                                if (defaultStatePacket != null && defaultStatePacket.isValid()) {
                                    this.handleDefaultStatePacket(defaultStatePacket);
                                    break;
                                }
                                LOGGER.warn("DEFAULT_STATE packet failed validation or is null");
                                break;
                            }
                            default: {
                                LOGGER.warn("Unknown packet type: {}", (Object)packetType);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception in main thread packet handler for type {}", (Object)packetType, (Object)e);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Error processing packet", (Throwable)e);
            }
        });
    }

    private void handleModelPacket(EntityModelPacket packet) {
        boolean hadOldModel;
        boolean isLocalPlayer;
        class_310 client = class_310.method_1551();
        boolean bl = isLocalPlayer = client.field_1724 != null && packet.getEntityUUID().equals(client.field_1724.method_5667());
        if (isLocalPlayer && (hadOldModel = this.modelRegistry.hasModelData(packet.getEntityUUID()))) {
            LOGGER.warn("Local player already has model data! Clearing old data before registering new model...");
            LOGGER.warn("This happens when disconnect handler didn't finish before reconnect");
            this.modelRegistry.unregisterEntity(packet.getEntityUUID());
            this.hitboxManager.unregisterHitbox(packet.getEntityUUID());
            this.sentEyeHeightPlayers.remove(packet.getEntityUUID());
            LOGGER.info("Old model data cleared. Ready to register new model.");
        }
        this.modelRegistry.registerEntityModel(packet.getEntityUUID(), packet.getModelNamespace(), packet.getModelName(), packet.getAnimationMappings());
        HitboxData hitboxData = HitboxParser.parseHitboxes(packet.getModelNamespace(), packet.getModelName());
        if (hitboxData != null) {
            this.hitboxManager.registerHitbox(packet.getEntityUUID(), hitboxData);
        }
        if (isLocalPlayer) {
            boolean alreadySent = this.sentEyeHeightPlayers.contains(packet.getEntityUUID());
            if (alreadySent) {
                LOGGER.warn("Eye height already sent for this player, skipping PeckhuiSyn update!");
                LOGGER.warn("This might cause issues if model changed or player reconnected!");
                return;
            }
            double eyeHeight = HitboxParser.calculateEyeHeight(packet.getModelNamespace(), packet.getModelName());
            double width = 0.6;
            double height = 1.8;
            if (hitboxData != null && hitboxData.hasHitboxes()) {
                double maxWidth = 0.0;
                double maxHeight = 0.0;
                for (HitboxData.HitboxCube cube : hitboxData.getCubes()) {
                    double cubeWidth = Math.max(Math.abs(cube.size.field_1352), Math.abs(cube.size.field_1350));
                    double cubeHeight = Math.abs(cube.size.field_1351);
                    maxWidth = Math.max(maxWidth, cubeWidth);
                    maxHeight = Math.max(maxHeight, cubeHeight);
                }
                if (maxWidth > 0.0) {
                    width = maxWidth;
                }
                if (maxHeight > 0.0) {
                    height = maxHeight;
                }
            }
            this.sendScaleToPeckhuiSyn(client.field_1724.method_5477().getString(), eyeHeight, width, height);
            this.sentEyeHeightPlayers.add(packet.getEntityUUID());
        }
    }

    private void sendScaleToPeckhuiSyn(String playerName, double eyeHeight, double width, double height) {
        try {
            JsonObject scaleData = new JsonObject();
            scaleData.addProperty("playerName", playerName);
            JsonObject typesScales = new JsonObject();
            if (eyeHeight > 0.0) {
                typesScales.addProperty("EYE_HEIGHT", (Number)Float.valueOf((float)eyeHeight));
            }
            scaleData.add("typesScales", (JsonElement)typesScales);
            String json = new Gson().toJson((JsonElement)scaleData);
            class_2960 peckhuiChannel = new class_2960("pekhuisyn", "channel");
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)peckhuiChannel, (class_2540)buf);
        }
        catch (Exception e) {
            LOGGER.error("Error sending scale to PeckhuiSyn", (Throwable)e);
        }
    }

    public static GeckoMythicClient getInstance() {
        return instance;
    }

    public GeckoEntityModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public HitboxManager getHitboxManager() {
        return this.hitboxManager;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    private void handleAnimationPacket(AnimationStatePacket packet) {
        GeckoEntityWrapper wrapper = this.modelRegistry.getWrapper(packet.getEntityUUID());
        if (wrapper != null) {
            wrapper.triggerAnimation(packet.getAnimationName(), packet.isLoop(), packet.getDuration());
        } else {
            LOGGER.warn("No wrapper found for entity {} - cannot trigger animation", (Object)packet.getEntityUUID());
        }
    }

    private void handleRemoveModelPacket(RemoveModelPacket packet) {
        class_310 client = class_310.method_1551();
        boolean isLocalPlayer = client.field_1724 != null && packet.getEntityUUID().equals(client.field_1724.method_5667());
        this.modelRegistry.unregisterEntity(packet.getEntityUUID());
        this.hitboxManager.unregisterHitbox(packet.getEntityUUID());
        if (isLocalPlayer) {
            this.resetEyeHeightInPeckhuiSyn(client.field_1724.method_5477().getString());
            this.sentEyeHeightPlayers.remove(packet.getEntityUUID());
        }
    }

    private void resetEyeHeightInPeckhuiSyn(String playerName) {
        try {
            JsonObject packet = new JsonObject();
            packet.addProperty("action", "remove");
            packet.addProperty("playerName", playerName);
            JsonArray typesToRemove = new JsonArray();
            typesToRemove.add("EYE_HEIGHT");
            typesToRemove.add("HITBOX_WIDTH");
            typesToRemove.add("HITBOX_HEIGHT");
            packet.add("typesToRemove", (JsonElement)typesToRemove);
            String json = new Gson().toJson((JsonElement)packet);
            class_2960 peckhuiChannel = new class_2960("pekhuisyn", "channel");
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)peckhuiChannel, (class_2540)buf);
        }
        catch (Exception e) {
            LOGGER.error("Error resetting scales in PeckhuiSyn", (Throwable)e);
        }
    }

    private void handleDefaultStatePacket(DefaultStatePacket packet) {
        GeckoEntityWrapper wrapper = this.modelRegistry.getWrapper(packet.getEntityUUID());
        if (wrapper != null) {
            wrapper.setDefaultAnimationsAndStopTriggered(packet.getIdleAnimation(), packet.getWalkAnimation());
            LOGGER.debug("Applied DEFAULT_STATE to existing wrapper for entity {}", (Object)packet.getEntityUUID());
        } else {
            this.modelRegistry.setPendingDefaultState(packet.getEntityUUID(), packet.getIdleAnimation(), packet.getWalkAnimation());
            LOGGER.debug("Saved DEFAULT_STATE to pending for entity {}", (Object)packet.getEntityUUID());
        }
    }

    public void requestModelForEntity(UUID entityUUID) {
        try {
            RequestModelPacket requestPacket = new RequestModelPacket(entityUUID);
            String json = requestPacket.toJson();
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(json);
            class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])out.toByteArray()));
            ClientPlayNetworking.send((class_2960)CHANNEL, (class_2540)buf);
        }
        catch (Exception e) {
            LOGGER.error("Error sending REQUEST_MODEL packet", (Throwable)e);
        }
    }
}

