/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import forge.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.ticks.LevelChunkTicks;

public class ChunkLoader {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;

    private static BlendingData readBlendingData(CompoundTag chunkData) {
        BlendingData blendingData = null;
        if (chunkData.m_128425_("blending_data", 10)) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)chunkData.m_128469_("blending_data"));
            blendingData = BlendingData.f_190254_.parse(blendingDataTag).resultOrPartial(x$0 -> LOGGER.error((String)x$0, new Object[0])).orElse(null);
        }
        return blendingData;
    }

    private static LevelChunkSection[] readSections(LevelAccessor level, LevelLightEngine lightEngine, ChunkPos chunkPos, CompoundTag chunkData) {
        Registry biomes = level.m_8891_().m_175515_(Registries.f_256952_);
        Codec biomeCodec = PalettedContainer.m_238371_((IdMap)biomes.m_206115_(), (Codec)biomes.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)biomes.m_246971_(Biomes.f_48202_));
        int i = level.m_151559_();
        LevelChunkSection[] chunkSections = new LevelChunkSection[i];
        boolean isLightOn = chunkData.m_128471_("isLightOn");
        boolean hasSkyLight = level.m_6042_().f_223549_();
        ListTag tagSections = chunkData.m_128437_("Sections", 10);
        if (tagSections.isEmpty()) {
            tagSections = chunkData.m_128437_("sections", 10);
        }
        for (int j = 0; j < tagSections.size(); ++j) {
            CompoundTag tagSection = tagSections.m_128728_(j);
            byte sectionYPos = tagSection.m_128445_("Y");
            int sectionId = level.m_151566_((int)sectionYPos);
            if (sectionId >= 0 && sectionId < chunkSections.length) {
                PalettedContainer blockStateContainer;
                PalettedContainer palettedContainer = tagSection.m_128425_("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tagSection.m_128469_("block_states")).promotePartial(string -> ChunkLoader.logErrors(chunkPos, sectionYPos, string)).getOrThrow(false, x$0 -> LOGGER.error((String)x$0, new Object[0])) : (blockStateContainer = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_));
                PalettedContainer biomeContainer = tagSection.m_128425_("biomes", 10) ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)tagSection.m_128469_("biomes")).promotePartial(string -> ChunkLoader.logErrors(chunkPos, i, string)).getOrThrow(false, x$0 -> LOGGER.error((String)x$0, new Object[0])) : new PalettedContainer(biomes.m_206115_(), (Object)biomes.m_246971_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
                chunkSections[sectionId] = new LevelChunkSection((int)sectionYPos, blockStateContainer, (PalettedContainerRO)biomeContainer);
            }
            if (!isLightOn) continue;
            if (tagSection.m_128425_("BlockLight", 7)) {
                lightEngine.m_5687_(LightLayer.BLOCK, SectionPos.m_123196_((ChunkPos)chunkPos, (int)sectionYPos), new DataLayer(tagSection.m_128463_("BlockLight")), true);
            }
            if (!hasSkyLight || !tagSection.m_128425_("SkyLight", 7)) continue;
            lightEngine.m_5687_(LightLayer.SKY, SectionPos.m_123196_((ChunkPos)chunkPos, (int)sectionYPos), new DataLayer(tagSection.m_128463_("SkyLight")), true);
        }
        return chunkSections;
    }

    private static void readHeightmaps(LevelChunk chunk, CompoundTag chunkData) {
        CompoundTag tagHeightmaps = chunkData.m_128469_("Heightmaps");
        for (Heightmap.Types type : ChunkStatus.f_62326_.m_62500_()) {
            String heightmap = type.m_64294_();
            if (!tagHeightmaps.m_128425_(heightmap, 12)) continue;
            chunk.m_6511_(type, tagHeightmaps.m_128467_(heightmap));
        }
        Heightmap.m_64256_((ChunkAccess)chunk, (Set)ChunkStatus.f_62326_.m_62500_());
    }

    private static void readPostPocessings(LevelChunk chunk, CompoundTag chunkData) {
        ListTag tagPostProcessings = chunkData.m_128437_("PostProcessing", 9);
        for (int n = 0; n < tagPostProcessings.size(); ++n) {
            ListTag listTag3 = tagPostProcessings.m_128744_(n);
            for (int o = 0; o < listTag3.size(); ++o) {
                chunk.m_6561_(listTag3.m_128757_(o), n);
            }
        }
    }

    public static ChunkStatus.ChunkType readChunkType(CompoundTag tagLevel) {
        ChunkStatus chunkStatus = ChunkStatus.m_62397_((String)tagLevel.m_128461_("Status"));
        if (chunkStatus != null) {
            return chunkStatus.m_62494_();
        }
        return ChunkStatus.ChunkType.PROTOCHUNK;
    }

    public static LevelChunk read(WorldGenLevel level, LevelLightEngine lightEngine, ChunkPos chunkPos, CompoundTag chunkData) {
        CompoundTag tagLevel = chunkData;
        ChunkPos actualPos = new ChunkPos(tagLevel.m_128451_("xPos"), tagLevel.m_128451_("zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; Ignoring. (Expected {}, got {})", chunkPos, chunkPos, actualPos);
            return null;
        }
        ChunkStatus.ChunkType chunkType = ChunkLoader.readChunkType(tagLevel);
        BlendingData blendingData = ChunkLoader.readBlendingData(tagLevel);
        if (chunkType == ChunkStatus.ChunkType.PROTOCHUNK && (blendingData == null || level.m_6325_(chunkPos.m_151390_(), chunkPos.m_151393_()).m_187675_())) {
            return null;
        }
        long inhabitedTime = tagLevel.m_128454_("InhabitedTime");
        UpgradeData upgradeData = tagLevel.m_128425_(TAG_UPGRADE_DATA, 10) ? new UpgradeData(tagLevel.m_128469_(TAG_UPGRADE_DATA), (LevelHeightAccessor)level) : UpgradeData.f_63320_;
        boolean isLightOn = tagLevel.m_128471_("isLightOn");
        if (isLightOn) {
            lightEngine.m_6462_(chunkPos, true);
        }
        LevelChunkTicks blockTicks = LevelChunkTicks.m_193185_((ListTag)tagLevel.m_128437_(BLOCK_TICKS_TAG_18, 10), string -> BuiltInRegistries.f_256975_.m_6612_(ResourceLocation.m_135820_((String)string)), (ChunkPos)chunkPos);
        LevelChunkTicks fluidTicks = LevelChunkTicks.m_193185_((ListTag)tagLevel.m_128437_(FLUID_TICKS_TAG_18, 10), string -> BuiltInRegistries.f_257020_.m_6612_(ResourceLocation.m_135820_((String)string)), (ChunkPos)chunkPos);
        LevelChunkSection[] levelChunkSections = ChunkLoader.readSections((LevelAccessor)level, lightEngine, chunkPos, tagLevel);
        LevelChunk chunk = new LevelChunk((Level)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.m_8094_(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static void logErrors(ChunkPos chunkPos, int i, String string) {
        LOGGER.error("Distant Horizons: Recoverable errors when loading section [" + chunkPos.f_45578_ + ", " + i + ", " + chunkPos.f_45579_ + "]: " + string, new Object[0]);
    }
}

