/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.handlers.dependencyInjection.ModAccessorHandler;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.lod.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.lod.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import forge.com.seibel.lod.common.wrappers.WrapperFactory;
import forge.com.seibel.lod.common.wrappers.block.BlockPosWrapper;
import forge.com.seibel.lod.common.wrappers.minecraft.MinecraftClientWrapper;
import forge.com.seibel.lod.common.wrappers.misc.LightMapWrapper;
import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final GameRenderer GAME_RENDERER = MinecraftRenderWrapper.MC.f_91063_;
    private static final IWrapperFactory FACTORY = WrapperFactory.INSTANCE;
    public LightMapWrapper lightmap = null;
    public boolean usingBackupGetVanillaRenderedChunks = false;

    @Override
    public Vec3f getLookAtVector() {
        Camera camera = GAME_RENDERER.m_109153_();
        Vector3f cameraDir = camera.m_253058_();
        return new Vec3f(cameraDir.x(), cameraDir.y(), cameraDir.z());
    }

    @Override
    public AbstractBlockPosWrapper getCameraBlockPosition() {
        Camera camera = GAME_RENDERER.m_109153_();
        BlockPos blockPos = camera.m_90588_();
        return new BlockPosWrapper(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    @Override
    public boolean playerHasBlindnessEffect() {
        return MinecraftRenderWrapper.MC.f_91074_.m_21221_().get(MobEffects.f_19610_) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        Camera camera = GAME_RENDERER.m_109153_();
        Vec3 projectedView = camera.m_90583_();
        return new Vec3d(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_);
    }

    @Override
    public Mat4f getDefaultProjectionMatrix(float partialTicks) {
        return McObjectConverter.Convert(GAME_RENDERER.m_253088_(GAME_RENDERER.m_109141_(GAME_RENDERER.m_109153_(), partialTicks, true)));
    }

    @Override
    public double getGamma() {
        return (Double)MinecraftRenderWrapper.MC.f_91066_.m_231927_().m_231551_();
    }

    @Override
    public Color getFogColor(float partialTicks) {
        FogRenderer.m_109018_((Camera)GAME_RENDERER.m_109153_(), (float)partialTicks, (ClientLevel)MinecraftRenderWrapper.MC.f_91073_, (int)1, (float)GAME_RENDERER.m_109131_(partialTicks));
        float[] colorValues = RenderSystem.m_157198_();
        return new Color(colorValues[0], colorValues[1], colorValues[2], colorValues[3]);
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.f_91073_.m_6042_().f_223549_()) {
            Vec3 colorValues = MinecraftRenderWrapper.MC.f_91073_.m_171660_(MinecraftRenderWrapper.MC.f_91063_.m_109153_().m_90583_(), MC.m_91296_());
            return new Color((float)colorValues.f_82479_, (float)colorValues.f_82480_, (float)colorValues.f_82481_);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return GAME_RENDERER.m_109141_(GAME_RENDERER.m_109153_(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.f_91066_.m_193772_();
    }

    @Override
    public int getScreenWidth() {
        return MC.m_91268_().m_85441_();
    }

    @Override
    public int getScreenHeight() {
        return MC.m_91268_().m_85442_();
    }

    private RenderTarget getRenderTarget() {
        RenderTarget r = null;
        return r != null ? r : MC.m_91385_();
    }

    @Override
    public int getTargetFrameBuffer() {
        return this.getRenderTarget().f_83920_;
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().f_83917_;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().f_83918_;
    }

    @Override
    public HashSet<AbstractChunkPosWrapper> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorHandler.get(ISodiumAccessor.class);
        if (sodium != null) {
            return sodium.getNormalRenderedChunks();
        }
        IOptifineAccessor optifine = ModAccessorHandler.get(IOptifineAccessor.class);
        if (optifine != null) {
            HashSet<AbstractChunkPosWrapper> pos = optifine.getNormalRenderedChunks();
            if (pos == null) {
                pos = this.getMaximumRenderedChunks();
            }
            return pos;
        }
        if (!this.usingBackupGetVanillaRenderedChunks) {
            try {
                LevelRenderer levelRenderer = MinecraftRenderWrapper.MC.f_91060_;
                LinkedHashSet chunks = ((LevelRenderer.RenderChunkStorage)levelRenderer.f_194307_.get()).f_194376_;
                return chunks.stream().map(chunk -> {
                    AABB chunkBoundingBox = chunk.f_109839_.m_202440_();
                    return FACTORY.createChunkPos(Math.floorDiv((int)chunkBoundingBox.f_82288_, 16), Math.floorDiv((int)chunkBoundingBox.f_82290_, 16));
                }).collect(Collectors.toCollection(HashSet::new));
            }
            catch (LinkageError e) {
                try {
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7e\u00a7l\u00a7uWARNING: Distant Horizons: getVanillaRenderedChunks method failed. Using Backup Method.");
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7eOverdraw prevention will be worse than normal.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ApiShared.LOGGER.error("getVanillaRenderedChunks Error: ", (Throwable)e);
                this.usingBackupGetVanillaRenderedChunks = true;
            }
        }
        return this.getMaximumRenderedChunks();
    }

    @Override
    public ILightMapWrapper getLightmapWrapper() {
        return this.lightmap;
    }

    @Override
    public boolean isFogStateSpecial() {
        Entity entity = GAME_RENDERER.m_109153_().m_90592_();
        boolean isBlind = entity instanceof LivingEntity && ((LivingEntity)entity).m_21023_(MobEffects.f_19610_);
        return GAME_RENDERER.m_109153_().m_167685_() != FogType.NONE || isBlind;
    }

    @Override
    public boolean tryDisableVanillaFog() {
        return true;
    }

    public void updateLightmap(NativeImage lightPixels) {
        if (this.lightmap == null) {
            this.lightmap = new LightMapWrapper();
        }
        this.lightmap.uploadLightmap(lightPixels);
    }
}

