/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.minecraft;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import forge.com.seibel.lod.common.wrappers.block.BlockPosWrapper;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkPosWrapper;
import forge.com.seibel.lod.common.wrappers.minecraft.ProfilerWrapper;
import forge.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import forge.com.seibel.lod.common.wrappers.world.WorldWrapper;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper {
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    public final Minecraft mc = Minecraft.m_91087_();
    private NativeImage lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(LodDirection lodDirection) {
        if (this.mc.f_91073_ != null) {
            Direction mcDir = McObjectConverter.Convert(lodDirection);
            return this.mc.f_91073_.m_7717_(mcDir, true);
        }
        return 0.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return this.mc.m_91091_();
    }

    @Override
    public String getCurrentServerName() {
        return this.mc.m_91089_().f_105362_;
    }

    @Override
    public String getCurrentServerIp() {
        return this.mc.m_91089_().f_105363_;
    }

    @Override
    public String getCurrentServerVersion() {
        return this.mc.m_91089_().f_105368_.getString();
    }

    @Override
    public IDimensionTypeWrapper getCurrentDimension() {
        if (this.mc.f_91074_ != null) {
            return DimensionTypeWrapper.getDimensionTypeWrapper(this.mc.f_91074_.f_19853_.m_6042_());
        }
        return null;
    }

    @Override
    public String getCurrentDimensionId() {
        return LodUtil.getDimensionIDFromWorld(WorldWrapper.getWorldWrapper((LevelAccessor)this.mc.f_91073_));
    }

    public LocalPlayer getPlayer() {
        return this.mc.f_91074_;
    }

    @Override
    public boolean playerExists() {
        return this.mc.f_91074_ != null;
    }

    @Override
    public BlockPosWrapper getPlayerBlockPos() {
        BlockPos playerPos = this.getPlayer().m_20183_();
        return new BlockPosWrapper(playerPos.m_123341_(), playerPos.m_123342_(), playerPos.m_123343_());
    }

    @Override
    public ChunkPosWrapper getPlayerChunkPos() {
        ChunkPos playerPos = this.getPlayer().m_146902_();
        return new ChunkPosWrapper(playerPos.f_45578_, playerPos.f_45579_);
    }

    public Options getOptions() {
        return this.mc.f_91066_;
    }

    public ModelManager getModelManager() {
        return this.mc.m_91304_();
    }

    public ClientLevel getClientLevel() {
        return this.mc.f_91073_;
    }

    @Override
    public IWorldWrapper getWrappedServerWorld() {
        if (this.mc.f_91073_ == null) {
            return null;
        }
        DimensionType dimension = this.mc.f_91073_.m_6042_();
        IntegratedServer server = this.mc.m_91092_();
        if (server == null) {
            return null;
        }
        ServerLevel serverWorld = null;
        Iterable worlds = server.m_129785_();
        for (ServerLevel world : worlds) {
            if (world.m_6042_() != dimension) continue;
            serverWorld = world;
            break;
        }
        return WorldWrapper.getWorldWrapper(serverWorld);
    }

    public WorldWrapper getWrappedClientLevel() {
        return WorldWrapper.getWorldWrapper((LevelAccessor)this.mc.f_91073_);
    }

    public WorldWrapper getWrappedServerLevel() {
        if (this.mc.f_91073_ == null) {
            return null;
        }
        DimensionType dimension = this.mc.f_91073_.m_6042_();
        IntegratedServer server = this.mc.m_91092_();
        if (server == null) {
            return null;
        }
        Iterable worlds = server.m_129785_();
        ServerLevel returnWorld = null;
        for (ServerLevel world : worlds) {
            if (world.m_6042_() != dimension) continue;
            returnWorld = world;
            break;
        }
        return WorldWrapper.getWorldWrapper(returnWorld);
    }

    @Override
    @Nullable
    public IWorldWrapper getWrappedClientWorld() {
        return WorldWrapper.getWorldWrapper((LevelAccessor)this.mc.f_91073_);
    }

    @Override
    public File getGameDirectory() {
        return this.mc.f_91069_;
    }

    @Override
    public IProfilerWrapper getProfiler() {
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(this.mc.m_91307_());
        } else if (this.mc.m_91307_() != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = this.mc.m_91307_();
        }
        return this.profilerWrapper;
    }

    public ClientPacketListener getConnection() {
        return this.mc.m_91403_();
    }

    public GameRenderer getGameRenderer() {
        return this.mc.f_91063_;
    }

    public Entity getCameraEntity() {
        return this.mc.f_91075_;
    }

    public Window getWindow() {
        return this.mc.m_91268_();
    }

    @Override
    public float getSkyDarken(float partialTicks) {
        return this.mc.f_91073_.m_104805_(partialTicks);
    }

    public IntegratedServer getSinglePlayerServer() {
        return this.mc.m_91092_();
    }

    @Override
    public boolean connectedToServer() {
        return this.mc.m_91089_() != null;
    }

    @Override
    public int getPlayerSkylight() {
        if (this.mc.f_91073_ == null) {
            return -1;
        }
        if (this.mc.f_91074_ == null) {
            return -1;
        }
        if (this.mc.f_91074_.m_20183_() == null) {
            return -1;
        }
        return this.mc.f_91073_.m_45517_(LightLayer.SKY, this.mc.f_91074_.m_20183_());
    }

    public ServerData getCurrentServer() {
        return this.mc.m_91089_();
    }

    public LevelRenderer getLevelRenderer() {
        return this.mc.f_91060_;
    }

    @Override
    public ArrayList<IWorldWrapper> getAllServerWorlds() {
        ArrayList<IWorldWrapper> worlds = new ArrayList<IWorldWrapper>();
        Iterable serverWorlds = this.mc.m_91092_().m_129785_();
        for (ServerLevel world : serverWorlds) {
            worlds.add(WorldWrapper.getWorldWrapper((LevelAccessor)world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        this.getPlayer().m_213846_((Component)Component.m_237115_((String)string));
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        ApiShared.LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...");
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.m_91332_((CrashReport)report);
    }
}

