/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.chunk;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import forge.com.seibel.lod.common.wrappers.WrapperUtil;
import forge.com.seibel.lod.common.wrappers.block.BlockDetailMap;
import forge.com.seibel.lod.common.wrappers.block.BlockDetailWrapper;
import forge.com.seibel.lod.common.wrappers.world.BiomeWrapper;
import forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightedWorldGenRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkWrapper
implements IChunkWrapper {
    private final ChunkAccess chunk;
    private final LevelReader lightSource;

    public ChunkWrapper(ChunkAccess chunk, LevelReader lightSource) {
        this.chunk = chunk;
        this.lightSource = lightSource;
    }

    @Override
    public int getHeight() {
        return this.chunk.m_141928_();
    }

    @Override
    public int getMinBuildHeight() {
        return this.chunk.m_141937_();
    }

    @Override
    public int getMaxBuildHeight() {
        return this.chunk.m_151558_();
    }

    @Override
    public int getHeightMapValue(int xRel, int zRel) {
        return this.chunk.m_6005_(WrapperUtil.DEFAULT_HEIGHTMAP).m_64242_(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int x, int y, int z) {
        return BiomeWrapper.getBiomeWrapper((Biome)this.chunk.m_203495_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z)).m_203334_());
    }

    @Override
    public IBlockDetailWrapper getBlockDetail(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState blockState = this.chunk.m_8055_(pos);
        BlockDetailWrapper blockDetail = BlockDetailMap.getOrMakeBlockDetailCache(blockState, pos, this.lightSource);
        return blockDetail == BlockDetailWrapper.NULL_BLOCK_DETAIL ? null : blockDetail;
    }

    @Override
    public IBlockDetailWrapper getBlockDetailAtFace(int x, int y, int z, LodDirection dir) {
        int fy = y + dir.getNormal().y;
        if (fy < this.getMinBuildHeight() || fy > this.getMaxBuildHeight()) {
            return null;
        }
        BlockPos pos = new BlockPos(x + dir.getNormal().x, fy, z + dir.getNormal().z);
        BlockState blockState = this.blockPosInsideChunk(x, y, z) ? this.chunk.m_8055_(pos) : this.lightSource.m_8055_(pos);
        if (blockState == null || blockState.m_60795_()) {
            return null;
        }
        BlockDetailWrapper blockDetail = BlockDetailMap.getOrMakeBlockDetailCache(blockState, pos, this.lightSource);
        return blockDetail == BlockDetailWrapper.NULL_BLOCK_DETAIL ? null : blockDetail;
    }

    public ChunkAccess getChunk() {
        return this.chunk;
    }

    @Override
    public int getChunkPosX() {
        return this.chunk.m_7697_().f_45578_;
    }

    @Override
    public int getChunkPosZ() {
        return this.chunk.m_7697_().f_45579_;
    }

    @Override
    public int getRegionPosX() {
        return LevelPosUtil.convert((byte)4, this.chunk.m_7697_().f_45578_, (byte)9);
    }

    @Override
    public int getRegionPosZ() {
        return LevelPosUtil.convert((byte)4, this.chunk.m_7697_().f_45579_, (byte)9);
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, Math.floorMod(x, 16), Math.floorMod(z, 16));
    }

    @Override
    public int getMaxX() {
        return this.chunk.m_7697_().m_45608_();
    }

    @Override
    public int getMaxZ() {
        return this.chunk.m_7697_().m_45609_();
    }

    @Override
    public int getMinX() {
        return this.chunk.m_7697_().m_45604_();
    }

    @Override
    public int getMinZ() {
        return this.chunk.m_7697_().m_45605_();
    }

    @Override
    public long getLongChunkPos() {
        return this.chunk.m_7697_().m_45588_();
    }

    @Override
    public boolean isLightCorrect() {
        if (this.chunk instanceof LevelChunk) {
            return ((LevelChunk)this.chunk).m_196863_();
        }
        return this.chunk.m_6332_();
    }

    @Override
    public boolean isWaterLogged(int x, int y, int z) {
        BlockState blockState = this.chunk.m_8055_(new BlockPos(x, y, z));
        return !(blockState.m_60734_() instanceof LiquidBlockContainer) && blockState.m_60734_() instanceof SimpleWaterloggedBlock && blockState.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_) != false;
    }

    @Override
    public int getEmittedBrightness(int x, int y, int z) {
        return this.chunk.m_7146_(new BlockPos(x, y, z));
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        if (this.lightSource == null) {
            return -1;
        }
        return this.lightSource.m_45517_(LightLayer.BLOCK, new BlockPos(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        if (this.lightSource == null) {
            return -1;
        }
        return this.lightSource.m_45517_(LightLayer.SKY, new BlockPos(x, y, z));
    }

    @Override
    public boolean doesNearbyChunksExist() {
        if (this.lightSource instanceof LightedWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.m_6522_(dx + this.getChunkPosX(), dz + this.getChunkPosZ(), ChunkStatus.f_62317_, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public LevelReader getColorResolver() {
        return this.lightSource;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + this.chunk.m_7697_();
    }
}

