/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.block;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.ColorUtil;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import forge.com.seibel.lod.common.wrappers.McObjectConverter;
import forge.com.seibel.lod.common.wrappers.block.TextureAtlasSpriteWrapper;
import forge.com.seibel.lod.common.wrappers.block.TintGetterOverrideFast;
import forge.com.seibel.lod.common.wrappers.block.TintGetterOverrideSmooth;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockDetailWrapper
extends IBlockDetailWrapper {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final int FLOWER_COLOR_SCALE = 5;
    public static final RandomSource random = RandomSource.m_216327_();
    private static final Block[] BLOCK_TO_AVOID = new Block[]{Blocks.f_50016_, Blocks.f_50627_, Blocks.f_50375_};
    private static final Direction[] DIRECTION_ORDER = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.DOWN};
    final BlockState state;
    boolean[] dontOccludeFaces = null;
    boolean noCollision = false;
    boolean noFullFace = false;
    boolean isColorResolved = false;
    int baseColor = 0;
    boolean needShade = true;
    boolean needPostTinting = false;
    int tintIndex = 0;
    public static BlockDetailWrapper NULL_BLOCK_DETAIL = new BlockDetailWrapper();

    private static int calculateColorFromTexture(TextureAtlasSprite texture, ColorMode colorMode) {
        int tempColor;
        int count = 0;
        double alpha = 0.0;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        for (int u = 0; u < texture.m_245424_().m_246492_(); ++u) {
            for (int v = 0; v < texture.m_245424_().m_245330_(); ++v) {
                tempColor = TextureAtlasSpriteWrapper.getPixelRGBA(texture, 0, u, v);
                double r = (double)(tempColor & 0xFF) / 255.0;
                double g = (double)((tempColor & 0xFF00) >>> 8) / 255.0;
                double b = (double)((tempColor & 0xFF0000) >>> 16) / 255.0;
                double a = (double)((tempColor & 0xFF000000) >>> 24) / 255.0;
                int scale = 1;
                if (colorMode == ColorMode.Leaves) {
                    r *= a;
                    g *= a;
                    b *= a;
                    a = 1.0;
                } else {
                    if (a == 0.0) continue;
                    if (colorMode == ColorMode.Flower && (g + 0.1 < b || g + 0.1 < r)) {
                        scale = 5;
                    }
                }
                count += scale;
                alpha += a * a * (double)scale;
                red += r * r * (double)scale;
                green += g * g * (double)scale;
                blue += b * b * (double)scale;
            }
        }
        tempColor = count == 0 ? ColorUtil.rgbToInt(255, 255, 0, 255) : ColorUtil.rgbToInt((int)(Math.sqrt(alpha / (double)count) * 255.0), (int)(Math.sqrt(red / (double)count) * 255.0), (int)(Math.sqrt(green / (double)count) * 255.0), (int)(Math.sqrt(blue / (double)count) * 255.0));
        double colorAlpha = (double)ColorUtil.getAlpha(tempColor) / 255.0;
        tempColor = ColorUtil.rgbToInt(ColorUtil.getAlpha(tempColor), (int)((double)ColorUtil.getRed(tempColor) * colorAlpha), (int)((double)ColorUtil.getGreen(tempColor) * colorAlpha), (int)((double)ColorUtil.getBlue(tempColor) * colorAlpha));
        return tempColor;
    }

    private static boolean isBlockToBeAvoid(Block b) {
        for (Block bta : BLOCK_TO_AVOID) {
            if (bta != b) continue;
            return true;
        }
        return false;
    }

    public BlockDetailWrapper(BlockState state, BlockPos pos, LevelReader getter) {
        this.state = state;
        this.resolveShapes(getter, pos);
    }

    private BlockDetailWrapper() {
        this.state = null;
    }

    static BlockDetailWrapper make(BlockState bs, BlockPos pos, LevelReader getter) {
        if (!bs.m_60819_().m_76178_()) {
            if (BlockDetailWrapper.isBlockToBeAvoid(bs.m_60734_())) {
                return NULL_BLOCK_DETAIL;
            }
            if (bs.m_60795_()) {
                return NULL_BLOCK_DETAIL;
            }
            return new BlockDetailWrapper(bs, pos, getter);
        }
        if (bs.m_60799_() != RenderShape.MODEL) {
            return NULL_BLOCK_DETAIL;
        }
        if (BlockDetailWrapper.isBlockToBeAvoid(bs.m_60734_())) {
            return NULL_BLOCK_DETAIL;
        }
        return new BlockDetailWrapper(bs, pos, getter);
    }

    private void resolveShapes(LevelReader sampleGetter, BlockPos samplePos) {
        if (this.state.m_60819_().m_76178_()) {
            this.noCollision = this.state.m_60812_((BlockGetter)sampleGetter, samplePos).m_83281_();
            this.dontOccludeFaces = new boolean[6];
            if (!this.state.m_60815_()) {
                Arrays.fill(this.dontOccludeFaces, true);
            }
            VoxelShape voxelShape = this.state.m_60808_((BlockGetter)sampleGetter, samplePos);
            if (voxelShape.m_83281_()) {
                this.noFullFace = true;
            } else {
                AABB bbox = voxelShape.m_83215_();
                double xWidth = bbox.f_82291_ - bbox.f_82288_;
                double yWidth = bbox.f_82292_ - bbox.f_82289_;
                double zWidth = bbox.f_82293_ - bbox.f_82290_;
                this.noFullFace = xWidth < 1.0 && zWidth < 1.0 && yWidth < 1.0;
            }
        } else {
            this.dontOccludeFaces = new boolean[6];
        }
    }

    private void resolveColors() {
        if (this.isColorResolved) {
            return;
        }
        if (this.state.m_60819_().m_76178_()) {
            List quads = null;
            for (Direction direction : DIRECTION_ORDER) {
                quads = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(this.state).m_213637_(this.state, direction, random);
                if (!quads.isEmpty() && (!(this.state.m_60734_() instanceof RotatedPillarBlock) || direction != Direction.UP)) break;
            }
            if (quads == null || quads.isEmpty()) {
                quads = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(this.state).m_213637_(this.state, null, random);
            }
            if (quads != null && !quads.isEmpty()) {
                this.needPostTinting = ((BakedQuad)quads.get(0)).m_111304_();
                this.needShade = ((BakedQuad)quads.get(0)).m_111307_();
                this.tintIndex = ((BakedQuad)quads.get(0)).m_111305_();
                this.baseColor = BlockDetailWrapper.calculateColorFromTexture(((BakedQuad)quads.get(0)).m_173410_(), ColorMode.getColorMode(this.state.m_60734_()));
            } else {
                this.needPostTinting = false;
                this.needShade = false;
                this.tintIndex = 0;
                this.baseColor = BlockDetailWrapper.calculateColorFromTexture(Minecraft.m_91087_().m_91304_().m_119430_().m_110882_(this.state), ColorMode.getColorMode(this.state.m_60734_()));
            }
        } else {
            this.needPostTinting = true;
            this.needShade = false;
            this.tintIndex = 0;
            this.baseColor = BlockDetailWrapper.calculateColorFromTexture(Minecraft.m_91087_().m_91304_().m_119430_().m_110882_(this.state), ColorMode.getColorMode(this.state.m_60734_()));
        }
        this.isColorResolved = true;
    }

    private BlockAndTintGetter wrapColorResolver(LevelReader level) {
        int blendDistance = CONFIG.client().graphics().quality().getLodBiomeBlending();
        if (blendDistance == 0) {
            return new TintGetterOverrideFast(level);
        }
        return new TintGetterOverrideSmooth(level, blendDistance);
    }

    @Override
    public int getAndResolveFaceColor(LodDirection dir, IChunkWrapper chunk, AbstractBlockPosWrapper blockPos) {
        this.resolveColors();
        if (!this.needPostTinting) {
            return this.baseColor;
        }
        int tintColor = Minecraft.m_91087_().m_91298_().m_92577_(this.state, this.wrapColorResolver(((ChunkWrapper)chunk).getColorResolver()), McObjectConverter.Convert(blockPos), this.tintIndex);
        if (tintColor == -1) {
            return this.baseColor;
        }
        return ColorUtil.multiplyARGBwithRGB(this.baseColor, tintColor);
    }

    @Override
    public boolean hasFaceCullingFor(LodDirection dir) {
        return !this.dontOccludeFaces[dir.ordinal()];
    }

    @Override
    public boolean hasNoCollision() {
        return this.noCollision;
    }

    @Override
    public boolean noFaceIsFullFace() {
        return this.noFullFace;
    }

    @Override
    public String serialize() {
        return null;
    }

    @Override
    protected boolean isSame(IBlockDetailWrapper iBlockDetail) {
        return ((BlockDetailWrapper)iBlockDetail).state.m_60734_().equals(this.state.m_60734_());
    }

    @Override
    public String toString() {
        return "BlockDetail{" + this.state + "}";
    }

    static enum ColorMode {
        Default,
        Flower,
        Leaves;


        static ColorMode getColorMode(Block b) {
            if (b instanceof LeavesBlock) {
                return Leaves;
            }
            if (b instanceof FlowerBlock) {
                return Flower;
            }
            return Default;
        }
    }
}

