/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.worldGeneration;

import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.builders.lodBuilding.LodBuilderConfig;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.logging.ConfigBasedSpamLogger;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.util.LodThreadFactory;
import com.seibel.lod.core.util.gridList.ArrayGridList;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import com.seibel.lod.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvionmentWrapper;
import fabric.com.seibel.lod.common.wrappers.DependencySetupDoneCheck;
import fabric.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import fabric.com.seibel.lod.common.wrappers.world.WorldWrapper;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.GenerationEvent;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.GlobalParameters;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.Rolling;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.ChunkLoader;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightedWorldGenRegion;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.WorldGenLevelLightEngine;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepBiomes;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepFeatures;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepLight;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepNoise;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepStructureReference;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepStructureStart;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.step.StepSurface;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2891;
import net.minecraft.class_2897;
import net.minecraft.class_3218;
import net.minecraft.class_3565;
import net.minecraft.class_3568;
import net.minecraft.class_3754;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;

public final class BatchGenerationEnvironment
extends AbstractBatchGenerationEnvionmentWrapper {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final ConfigBasedSpamLogger PREF_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger((String)"LodWorldGen"), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogWorldGenPerformance(), 1);
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogWorldGenEvent());
    public static final ConfigBasedLogger LOAD_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogWorldGenLoadEvent());
    public static final int TIMEOUT_SECONDS = 60;
    public final LinkedList<GenerationEvent> events = new LinkedList();
    public final GlobalParameters params;
    public final StepStructureStart stepStructureStart = new StepStructureStart(this);
    public final StepStructureReference stepStructureReference = new StepStructureReference(this);
    public final StepBiomes stepBiomes = new StepBiomes(this);
    public final StepNoise stepNoise = new StepNoise(this);
    public final StepSurface stepSurface = new StepSurface(this);
    public final StepFeatures stepFeatures = new StepFeatures(this);
    public final StepLight stepLight = new StepLight(this);
    public boolean unsafeThreadingRecorded = false;
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    public static final long EXCEPTION_TIMER_RESET_TIME = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    public static final int EXCEPTION_COUNTER_TRIGGER = 20;
    public static final int RANGE_TO_RANGE_EMPTY_EXTENSION = 1;
    public int unknownExceptionCount = 0;
    public long lastExceptionTriggerTime = 0L;
    public static final LodThreadFactory threadFactory = new LodThreadFactory("Gen-Worker-Thread", 1);
    public static ThreadLocal<Boolean> isDistantGeneratorThread = new ThreadLocal();
    public ExecutorService executors = Executors.newFixedThreadPool(CONFIG.client().advanced().threading()._getWorldGenerationThreadPoolSize(), threadFactory);

    public static boolean isCurrentThreadDistantGeneratorThread() {
        return isDistantGeneratorThread.get() != null;
    }

    public <T> T joinSync(CompletableFuture<T> f) {
        if (!this.unsafeThreadingRecorded && !f.isDone()) {
            EVENT_LOGGER.error("Unsafe Threading in Chunk Generator: ", new RuntimeException("Concurrent future"));
            EVENT_LOGGER.error("To increase stability, it is recommended to set world generation threads count to 1.", new Object[0]);
            this.unsafeThreadingRecorded = true;
        }
        return f.join();
    }

    @Override
    public void resizeThreadPool(int newThreadCount) {
        this.executors = Executors.newFixedThreadPool(newThreadCount, new LodThreadFactory("Gen-Worker-Thread", 1));
    }

    @Override
    public boolean tryAddPoint(int px, int pz, int range, AbstractBatchGenerationEnvionmentWrapper.Steps target, boolean genAllDetails, double runTimeRatio) {
        int boxSize = range * 2 + 1;
        int x = Math.floorDiv(px, boxSize) * boxSize + range;
        int z = Math.floorDiv(pz, boxSize) * boxSize + range;
        for (GenerationEvent event : this.events) {
            if (!event.tooClose(x, z, range)) continue;
            return false;
        }
        this.events.add(new GenerationEvent(new class_1923(x, z), range, this, target, genAllDetails, runTimeRatio));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllFutures() {
        if (this.unknownExceptionCount > 0 && System.nanoTime() - this.lastExceptionTriggerTime >= EXCEPTION_TIMER_RESET_TIME) {
            this.unknownExceptionCount = 0;
        }
        Iterator iter = this.events.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = (GenerationEvent)iter.next();
            if (event.isCompleted()) {
                try {
                    event.join();
                    continue;
                }
                catch (Throwable e) {
                    EVENT_LOGGER.error("Batching World Generator: Event {} gotten an exception", event);
                    EVENT_LOGGER.error("Exception: ", e);
                    ++this.unknownExceptionCount;
                    this.lastExceptionTriggerTime = System.nanoTime();
                    continue;
                }
                finally {
                    iter.remove();
                    continue;
                }
            }
            if (!event.hasTimeout(60, TimeUnit.SECONDS)) continue;
            EVENT_LOGGER.error("Batching World Generator: " + event + " timed out and terminated!", new Object[0]);
            EVENT_LOGGER.info("Dump PrefEvent: " + event.pEvent, new Object[0]);
            try {
                if (event.terminate()) continue;
                EVENT_LOGGER.error("Failed to terminate the stuck generation event!", new Object[0]);
            }
            finally {
                iter.remove();
            }
        }
        if (this.unknownExceptionCount > 20) {
            EVENT_LOGGER.error("Too many exceptions in Batching World Generator! Disabling the generator.", new Object[0]);
            this.unknownExceptionCount = 0;
            CONFIG.client().worldGenerator().setEnableDistantGeneration(false);
        }
    }

    public BatchGenerationEnvironment(IWorldWrapper serverlevel, LodBuilder lodBuilder, LodDimension lodDim) {
        super(serverlevel, lodBuilder, lodDim);
        EVENT_LOGGER.info("================WORLD_GEN_STEP_INITING=============", new Object[0]);
        class_2794 generator = ((WorldWrapper)serverlevel).getServerWorld().method_14178().method_12129();
        if (!(generator instanceof class_3754 || generator instanceof class_2891 || generator instanceof class_2897)) {
            if (generator.getClass().toString().equals("class com.terraforged.mod.chunk.TFChunkGenerator")) {
                EVENT_LOGGER.info("TerraForge Chunk Generator detected: [{}], Distant Generation will try its best to support it.", generator.getClass());
                EVENT_LOGGER.info("If it does crash, set Distant Generation to OFF or Generation Mode to None.", new Object[0]);
            } else {
                EVENT_LOGGER.warn("Unknown Chunk Generator detected: [{}], Distant Generation May Fail!", generator.getClass());
                EVENT_LOGGER.warn("If it does crash, set Distant Generation to OFF or Generation Mode to None.", new Object[0]);
            }
        }
        this.params = new GlobalParameters((class_3218)((WorldWrapper)serverlevel).getWorld(), lodBuilder, lodDim);
    }

    public static class_2791 loadOrMakeChunk(class_1923 chunkPos, class_3218 level, class_3568 lightEngine) {
        class_2487 chunkData = null;
        try {
            chunkData = ((Optional)level.method_14178().field_17254.method_43383(chunkPos).get()).orElse(null);
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: Couldn't load chunk {}", chunkPos, e);
        }
        if (chunkData == null) {
            return new class_2839(chunkPos, class_2843.field_12950, (class_5539)level, level.method_30349().method_30530(class_7924.field_41236), null);
        }
        try {
            return ChunkLoader.read((class_5281)level, lightEngine, chunkPos, chunkData);
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: Couldn't load chunk {}", chunkPos, e);
            return new class_2839(chunkPos, class_2843.field_12950, (class_5539)level, level.method_30349().method_30530(class_7924.field_41236), null);
        }
    }

    public void generateLodFromList(GenerationEvent e) {
        DistanceGenerationMode generationMode;
        ArrayGridList<class_2791> genChunks;
        LightedWorldGenRegion region;
        WorldGenLevelLightEngine lightEngine;
        EVENT_LOGGER.debug("Lod Generate Event: " + e.pos, new Object[0]);
        e.pEvent.beginNano = System.nanoTime();
        int refRange = e.range + 1;
        int refOffsetX = e.pos.field_9181 - refRange;
        int refOffsetZ = e.pos.field_9180 - refRange;
        try {
            LightGetterAdaptor adaptor = new LightGetterAdaptor((class_1922)this.params.level);
            lightEngine = new WorldGenLevelLightEngine(adaptor);
            EmptyChunkGenerator generator = (x, z) -> {
                class_1923 chunkPos = new class_1923(x, z);
                class_2791 target = null;
                try {
                    target = BatchGenerationEnvironment.loadOrMakeChunk(chunkPos, this.params.level, lightEngine);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (target == null) {
                    target = new class_2839(chunkPos, class_2843.field_12950, (class_5539)this.params.level, this.params.biomes, null);
                }
                return target;
            };
            ArrayGridList<class_2791> referencedChunks = new ArrayGridList<class_2791>(refRange * 2 + 1, (x, z) -> generator.generate(x + refOffsetX, z + refOffsetZ));
            e.pEvent.emptyNano = System.nanoTime();
            e.refreshTimeout();
            region = new LightedWorldGenRegion(this.params.level, lightEngine, referencedChunks, class_2806.field_16423, refRange, e.lightMode, generator);
            adaptor.setRegion(region);
            e.tParam.makeStructFeat((class_5281)region, this.params);
            genChunks = new ArrayGridList<class_2791>(referencedChunks, 1, referencedChunks.gridSize - 1);
            this.generateDirect(e, genChunks, e.target, region);
        }
        catch (StepStructureStart.StructStartCorruptedException f) {
            e.tParam.markAsInvalid();
            return;
        }
        switch (e.target) {
            case Empty: 
            case StructureStart: 
            case StructureReference: {
                generationMode = DistanceGenerationMode.NONE;
                break;
            }
            case Biomes: {
                generationMode = DistanceGenerationMode.BIOME_ONLY;
            }
            case Noise: {
                generationMode = DistanceGenerationMode.BIOME_ONLY_SIMULATE_HEIGHT;
                break;
            }
            case Surface: 
            case Carvers: {
                generationMode = DistanceGenerationMode.SURFACE;
                break;
            }
            case Features: {
                generationMode = DistanceGenerationMode.FEATURES;
                break;
            }
            default: {
                return;
            }
        }
        for (int oy = 0; oy < genChunks.gridSize; ++oy) {
            for (int ox = 0; ox < genChunks.gridSize; ++ox) {
                class_2791 target = genChunks.get(ox, oy);
                ChunkWrapper wrappedChunk = new ChunkWrapper(target, (class_4538)region);
                if (!wrappedChunk.isLightCorrect()) {
                    throw new RuntimeException("The generated chunk somehow has isLightCorrect() returning false");
                }
                boolean isFull = target.method_12009() == class_2806.field_12803 || target instanceof class_2818;
                boolean isPartial = target.method_39297();
                if (isFull) {
                    LOAD_LOGGER.info("Detected full existing chunk at {}", target.method_12004());
                    this.params.lodBuilder.generateLodNodeFromChunk(this.params.lodDim, wrappedChunk, new LodBuilderConfig(DistanceGenerationMode.FULL), true, e.genAllDetails);
                } else if (isPartial) {
                    LOAD_LOGGER.info("Detected old existing chunk at {}", target.method_12004());
                    this.params.lodBuilder.generateLodNodeFromChunk(this.params.lodDim, wrappedChunk, new LodBuilderConfig(generationMode), true, e.genAllDetails);
                } else if (target.method_12009() == class_2806.field_12798 && generationMode == DistanceGenerationMode.NONE) {
                    this.params.lodBuilder.generateLodNodeFromChunk(this.params.lodDim, wrappedChunk, LodBuilderConfig.getFillVoidConfig(), true, e.genAllDetails);
                } else {
                    this.params.lodBuilder.generateLodNodeFromChunk(this.params.lodDim, wrappedChunk, new LodBuilderConfig(generationMode), true, e.genAllDetails);
                }
                if (e.lightMode != LightGenerationMode.FANCY && !isFull) continue;
                lightEngine.method_20601(target.method_12004(), false);
            }
        }
        e.pEvent.endNano = System.nanoTime();
        e.refreshTimeout();
        if (PREF_LOGGER.canMaybeLog()) {
            e.tParam.perf.recordEvent(e.pEvent);
            PREF_LOGGER.infoInc("{}", e.tParam.perf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDirect(GenerationEvent e, ArrayGridList<class_2791> subRange, AbstractBatchGenerationEnvionmentWrapper.Steps step, LightedWorldGenRegion region) {
        try {
            subRange.forEach(chunk -> {
                if (chunk instanceof class_2839) {
                    ((class_2839)chunk).method_17032(region.method_22336());
                    region.method_22336().method_20601(chunk.method_12004(), true);
                }
            });
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.Empty) {
                return;
            }
            this.stepStructureStart.generateGroup(e.tParam, region, subRange);
            e.pEvent.structStartNano = System.nanoTime();
            e.refreshTimeout();
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.StructureStart) {
                return;
            }
            this.stepStructureReference.generateGroup(e.tParam, region, subRange);
            e.pEvent.structRefNano = System.nanoTime();
            e.refreshTimeout();
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.StructureReference) {
                return;
            }
            this.stepBiomes.generateGroup(e.tParam, region, subRange);
            e.pEvent.biomeNano = System.nanoTime();
            e.refreshTimeout();
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.Biomes) {
                return;
            }
            this.stepNoise.generateGroup(e.tParam, region, subRange);
            e.pEvent.noiseNano = System.nanoTime();
            e.refreshTimeout();
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.Noise) {
                return;
            }
            this.stepSurface.generateGroup(e.tParam, region, subRange);
            e.pEvent.surfaceNano = System.nanoTime();
            e.refreshTimeout();
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.Surface) {
                return;
            }
            if (step == AbstractBatchGenerationEnvionmentWrapper.Steps.Carvers) {
                return;
            }
            this.stepFeatures.generateGroup(e.tParam, region, subRange);
            e.pEvent.featureNano = System.nanoTime();
            e.refreshTimeout();
        }
        finally {
            switch (region.lightMode) {
                case FANCY: {
                    this.stepLight.generateGroup((class_3565)region.method_22336(), subRange);
                    break;
                }
                case FAST: {
                    subRange.forEach(p -> {
                        if (p instanceof class_2839) {
                            ((class_2839)p).method_12020(true);
                        }
                        if (p instanceof class_2818) {
                            ((class_2818)p).method_12020(true);
                            ((class_2818)p).method_39792(true);
                        }
                    });
                }
            }
            e.pEvent.lightNano = System.nanoTime();
            e.refreshTimeout();
        }
    }

    @Override
    public int getEventCount() {
        return this.events.size();
    }

    @Override
    public void stop(boolean blocking) {
        EVENT_LOGGER.info("Batch Chunk Generator shutting down...", new Object[0]);
        this.executors.shutdownNow();
        if (blocking) {
            try {
                if (!this.executors.awaitTermination(10L, TimeUnit.SECONDS)) {
                    EVENT_LOGGER.error("Batch Chunk Generator shutdown failed! Ignoring child threads...", new Object[0]);
                }
            }
            catch (InterruptedException e) {
                EVENT_LOGGER.error("Batch Chunk Generator shutdown failed! Ignoring child threads...", e);
            }
        }
    }

    static {
        DependencySetupDoneCheck.getIsCurrentThreadDistantGeneratorThread = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
    }

    public static class PrefEvent {
        long beginNano = 0L;
        long emptyNano = 0L;
        long structStartNano = 0L;
        long structRefNano = 0L;
        long biomeNano = 0L;
        long noiseNano = 0L;
        long surfaceNano = 0L;
        long carverNano = 0L;
        long featureNano = 0L;
        long lightNano = 0L;
        long endNano = 0L;

        public String toString() {
            return "beginNano: " + this.beginNano + ",\nemptyNano: " + this.emptyNano + ",\nstructStartNano: " + this.structStartNano + ",\nstructRefNano: " + this.structRefNano + ",\nbiomeNano: " + this.biomeNano + ",\nnoiseNano: " + this.noiseNano + ",\nsurfaceNano: " + this.surfaceNano + ",\ncarverNano: " + this.carverNano + ",\nfeatureNano: " + this.featureNano + ",\nlightNano: " + this.lightNano + ",\nendNano: " + this.endNano + "\n";
        }
    }

    public static interface EmptyChunkGenerator {
        public class_2791 generate(int var1, int var2);
    }

    public static class PerfCalculator {
        public static final int SIZE = 50;
        Rolling totalTime = new Rolling(50);
        Rolling emptyTime = new Rolling(50);
        Rolling structStartTime = new Rolling(50);
        Rolling structRefTime = new Rolling(50);
        Rolling biomeTime = new Rolling(50);
        Rolling noiseTime = new Rolling(50);
        Rolling surfaceTime = new Rolling(50);
        Rolling carverTime = new Rolling(50);
        Rolling featureTime = new Rolling(50);
        Rolling lightTime = new Rolling(50);
        Rolling lodTime = new Rolling(50);

        public void recordEvent(PrefEvent e) {
            long preTime = e.beginNano;
            this.totalTime.add(e.endNano - preTime);
            if (e.emptyNano != 0L) {
                this.emptyTime.add(e.emptyNano - preTime);
                preTime = e.emptyNano;
            }
            if (e.structStartNano != 0L) {
                this.structStartTime.add(e.structStartNano - preTime);
                preTime = e.structStartNano;
            }
            if (e.structRefNano != 0L) {
                this.structRefTime.add(e.structRefNano - preTime);
                preTime = e.structRefNano;
            }
            if (e.biomeNano != 0L) {
                this.biomeTime.add(e.biomeNano - preTime);
                preTime = e.biomeNano;
            }
            if (e.noiseNano != 0L) {
                this.noiseTime.add(e.noiseNano - preTime);
                preTime = e.noiseNano;
            }
            if (e.surfaceNano != 0L) {
                this.surfaceTime.add(e.surfaceNano - preTime);
                preTime = e.surfaceNano;
            }
            if (e.carverNano != 0L) {
                this.carverTime.add(e.carverNano - preTime);
                preTime = e.carverNano;
            }
            if (e.featureNano != 0L) {
                this.featureTime.add(e.featureNano - preTime);
                preTime = e.featureNano;
            }
            if (e.lightNano != 0L) {
                this.lightTime.add(e.lightNano - preTime);
                preTime = e.lightNano;
            }
            if (e.endNano != 0L) {
                this.lodTime.add(e.endNano - preTime);
            }
        }

        public String toString() {
            return "Total: " + Duration.ofNanos((long)this.totalTime.getAverage()) + ", Empty/LoadChunk: " + Duration.ofNanos((long)this.emptyTime.getAverage()) + ", StructStart: " + Duration.ofNanos((long)this.structStartTime.getAverage()) + ", StructRef: " + Duration.ofNanos((long)this.structRefTime.getAverage()) + ", Biome: " + Duration.ofNanos((long)this.biomeTime.getAverage()) + ", Noise: " + Duration.ofNanos((long)this.noiseTime.getAverage()) + ", Surface: " + Duration.ofNanos((long)this.surfaceTime.getAverage()) + ", Carver: " + Duration.ofNanos((long)this.carverTime.getAverage()) + ", Feature: " + Duration.ofNanos((long)this.featureTime.getAverage()) + ", Light: " + Duration.ofNanos((long)this.lightTime.getAverage()) + ", Lod: " + Duration.ofNanos((long)this.lodTime.getAverage());
        }
    }
}

