/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.world;

import com.google.common.collect.ImmutableBiMap;
import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import fabric.com.seibel.lod.common.wrappers.world.WorldWrapper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class BiomeWrapper
implements IBiomeWrapper {
    public static final ConcurrentMap<class_1959, BiomeWrapper> biomeWrapperMap = new ConcurrentHashMap<class_1959, BiomeWrapper>();
    private final class_1959 biome;
    private static final ImmutableBiMap<class_1959, Function<class_1959, Integer>> BIOME_COLOR_MAP = ImmutableBiMap.builder().put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35117), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9453), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9424), BiomeWrapper::_colorSand).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9471), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_38748), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9409), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9414), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9412), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9475), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35112), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35119), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35113), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9420), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9454), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35111), BiomeWrapper::_colorGravel).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35120), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9417), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9440), BiomeWrapper::_colorBamboo).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9415), BiomeWrapper::_colorRedSand).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9443), BiomeWrapper::_colorRedSand).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35110), BiomeWrapper::_colorStone).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_34471), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_34472), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_35115), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_34474), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_34475), BiomeWrapper::_colorStone).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9438), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9463), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9434), BiomeWrapper::_colorSand).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9478), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9419), BiomeWrapper::_colorStone).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9408), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9441), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9439), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9423), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9446), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9467), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9470), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9435), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9418), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9462), BiomeWrapper::_colorMushoom).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_28107), BiomeWrapper::_colorDripStone).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_29218), BiomeWrapper::_colorMoss).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_37543), BiomeWrapper::_colorSculk).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9461), BiomeWrapper::_colorNether).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_22075), BiomeWrapper::_colorNether).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_22077), BiomeWrapper::_colorNether).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_22076), BiomeWrapper::_colorSoulSand).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_23859), BiomeWrapper::_colorBasalt).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9411), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9442), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9447), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9457), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((class_5321<class_1959>)class_1972.field_9465), BiomeWrapper::_colorEnd).build();

    public BiomeWrapper(class_1959 biome) {
        this.biome = biome;
    }

    public static IBiomeWrapper getBiomeWrapper(class_1959 biome) {
        if (biomeWrapperMap.containsKey(biome) && biomeWrapperMap.get(biome) != null) {
            return (IBiomeWrapper)biomeWrapperMap.get(biome);
        }
        BiomeWrapper biomeWrapper = new BiomeWrapper(biome);
        biomeWrapperMap.put(biome, biomeWrapper);
        return biomeWrapper;
    }

    private static int _colorEnd(class_1959 b) {
        return class_2246.field_10471.method_26403().field_16011;
    }

    private static int _colorNether(class_1959 b) {
        return class_2246.field_10515.method_26403().field_16011;
    }

    private static int _colorSand(class_1959 b) {
        return class_2246.field_10102.method_26403().field_16011;
    }

    private static int _colorStone(class_1959 b) {
        return class_2246.field_10340.method_26403().field_16011;
    }

    private static int _colorGravel(class_1959 b) {
        return class_2246.field_10255.method_26403().field_16011;
    }

    private static int _colorDripStone(class_1959 b) {
        return class_2246.field_28049.method_26403().field_16011;
    }

    private static int _colorMoss(class_1959 b) {
        return class_2246.field_28681.method_26403().field_16011;
    }

    private static int _colorSculk(class_1959 b) {
        return class_2246.field_37568.method_26403().field_16011;
    }

    private static int _colorMushoom(class_1959 b) {
        return class_2246.field_10402.method_26403().field_16011;
    }

    private static int _colorBamboo(class_1959 b) {
        return class_2246.field_10211.method_26403().field_16011;
    }

    private static int _colorSnow(class_1959 b) {
        return class_2246.field_10477.method_26403().field_16011;
    }

    private static int _colorIce(class_1959 b) {
        return class_2246.field_10295.method_26403().field_16011;
    }

    private static int _colorRedSand(class_1959 b) {
        return class_2246.field_10534.method_26403().field_16011;
    }

    private static int _colorSoulSand(class_1959 b) {
        return class_2246.field_10114.method_26403().field_16011;
    }

    private static int _colorBasalt(class_1959 b) {
        return class_2246.field_22091.method_26403().field_16011;
    }

    private static int _colorWater(class_1959 b) {
        return b.method_8687();
    }

    private static int _colorFoliage(class_1959 b) {
        return b.method_8698();
    }

    private static class_1959 _get(class_5321<class_1959> r) {
        return (class_1959)((class_3218)((WorldWrapper)LodUtil.getServerWorldFromDimension(ApiShared.lodWorld.getLodDimension((IDimensionTypeWrapper)SingletonHandler.get(IMinecraftClientWrapper.class).getCurrentDimension()).dimension)).getWorld()).method_8503().method_30611().method_30530(class_7924.field_41236).method_31140(r);
    }

    @Override
    public int getColorForBiome(int x, int z) {
        Function colorFunction = (Function)BIOME_COLOR_MAP.get((Object)this.biome);
        int colorInt = colorFunction != null ? ((Integer)colorFunction.apply(this.biome)).intValue() : this.biome.method_8711((double)x, (double)z);
        return colorInt;
    }

    @Override
    public String getName() {
        return this.biome.toString();
    }

    @Override
    public int getGrassTint(int x, int z) {
        return this.biome.method_8711((double)x, (double)z);
    }

    @Override
    public int getFolliageTint() {
        return this.biome.method_8698();
    }

    @Override
    public int getWaterTint() {
        return this.biome.method_8687();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BiomeWrapper)) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }
}

