/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.lod;

import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.DropoffQuality;
import com.seibel.lod.core.enums.config.GenerationPriority;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.PosToGenerateContainer;
import com.seibel.lod.core.objects.PosToRenderContainer;
import com.seibel.lod.core.objects.lod.LevelContainer;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.objects.lod.VerticalLevelContainer;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class LodRegion {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final byte POSSIBLE_LOD = 10;
    private volatile byte minDetailLevel;
    public byte lastMaxDetailLevel = (byte)9;
    private final LevelContainer[] dataContainer;
    private final VerticalQuality verticalQuality;
    public final int regionPosX;
    public final int regionPosZ;
    public volatile boolean needRecheckGenPoint = true;
    public volatile boolean needSignalToRegenBuffer = true;
    public volatile boolean needSaving = false;
    public final AtomicInteger isWriting = new AtomicInteger(0);

    public static byte calculateFarModeSwitch(byte targetLevel) {
        if (targetLevel == 0) {
            return 0;
        }
        double part = (double)targetLevel / 9.0;
        int farModeLevel = 5;
        farModeLevel = (byte)((double)farModeLevel * part);
        farModeLevel = (byte)(farModeLevel + 5);
        return (byte)LodUtil.clamp(5, farModeLevel, 9);
    }

    public LodRegion(byte minDetailLevel, RegionPos regionPos, VerticalQuality verticalQuality) {
        this.minDetailLevel = minDetailLevel;
        this.regionPosX = regionPos.x;
        this.regionPosZ = regionPos.z;
        this.verticalQuality = verticalQuality;
        this.dataContainer = new LevelContainer[10];
        for (byte lod = minDetailLevel; lod <= 9; lod = (byte)(lod + 1)) {
            this.dataContainer[lod] = new VerticalLevelContainer(lod);
        }
    }

    public boolean addData(byte detailLevel, int posX, int posZ, int verticalIndex, long data) {
        if (this.isWriting.get() <= 0) {
            throw new ConcurrentModificationException("isWriting counter lock should have been aquired!");
        }
        posX = LevelPosUtil.getRegionModule(detailLevel, posX);
        posZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        if (this.dataContainer[detailLevel] == null) {
            return false;
        }
        this.dataContainer[detailLevel].addData(data, posX, posZ, verticalIndex);
        return true;
    }

    public boolean addVerticalData(byte detailLevel, int posX, int posZ, long[] data, boolean override) {
        if (this.isWriting.get() <= 0) {
            throw new ConcurrentModificationException("isWriting counter lock should have been aquired!");
        }
        posX = LevelPosUtil.getRegionModule(detailLevel, posX);
        posZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        if (this.dataContainer[detailLevel] == null) {
            return false;
        }
        boolean updated = this.dataContainer[detailLevel].addVerticalData(data, posX, posZ, override);
        if (updated) {
            this.needSignalToRegenBuffer = true;
            this.needSaving = true;
        }
        return updated;
    }

    public boolean addChunkOfData(byte detailLevel, int posX, int posZ, int widthX, int widthZ, long[] data, int verticalSize, boolean override) {
        if (this.isWriting.get() <= 0) {
            throw new ConcurrentModificationException("isWriting counter lock should have been aquired!");
        }
        posX = LevelPosUtil.getRegionModule(detailLevel, posX);
        posZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        if (this.dataContainer[detailLevel] == null) {
            return false;
        }
        if (this.dataContainer[detailLevel].getVerticalSize() != verticalSize) {
            throw new RuntimeException(String.format("Provided data's verticalSize [%d] is different from current storage's verticalSize [%d] at detail [%d]", verticalSize, this.dataContainer[detailLevel].getVerticalSize(), detailLevel));
        }
        boolean updated = this.dataContainer[detailLevel].addChunkOfData(data, posX, posZ, widthX, widthZ, override);
        if (updated) {
            this.needSignalToRegenBuffer = true;
            this.needSaving = true;
        }
        if (!this.doesDataExist(detailLevel, posX, posZ, DistanceGenerationMode.values()[DataPointUtil.getGenerationMode(data[0]) - 1])) {
            throw new RuntimeException("Data still doesn't exist after addChunkOfData!");
        }
        return updated;
    }

    public long getData(byte detailLevel, int posX, int posZ, int verticalIndex) {
        posX = LevelPosUtil.getRegionModule(detailLevel, posX);
        posZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        return this.dataContainer[detailLevel].getData(posX, posZ, verticalIndex);
    }

    public long[] getAllData(byte detailLevel, int posX, int posZ) {
        posX = LevelPosUtil.getRegionModule(detailLevel, posX);
        posZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        return this.dataContainer[detailLevel].getAllData(posX, posZ);
    }

    public long getSingleData(byte detailLevel, int posX, int posZ) {
        posX = LevelPosUtil.getRegionModule(detailLevel, posX);
        posZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        return this.dataContainer[detailLevel].getSingleData(posX, posZ);
    }

    public void getPosToGenerate(PosToGenerateContainer posToGenerate, int playerBlockPosX, int playerBlockPosZ, GenerationPriority priority, DistanceGenerationMode genMode, boolean shouldSort) {
        this.getPosToGenerate(posToGenerate, (byte)9, 0, 0, playerBlockPosX, playerBlockPosZ, priority, genMode, shouldSort, true);
    }

    private void getPosToGenerate(PosToGenerateContainer posToGenerate, byte detailLevel, int offsetPosX, int offsetPosZ, int playerPosX, int playerPosZ, GenerationPriority priority, DistanceGenerationMode genMode, boolean shouldSort, boolean needFarPos) {
        boolean isFarModeSwitchEdge;
        byte farModeSwitchLevel;
        int size = 1 << 9 - detailLevel;
        double minDistance = LevelPosUtil.minDistance(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size, playerPosX, playerPosZ);
        byte childDetailLevel = (byte)(detailLevel - 1);
        int childOffsetPosX = offsetPosX * 2;
        int childOffsetPosZ = offsetPosZ * 2;
        DistanceGenerationMode testerGenMode = genMode;
        byte targetDetailLevel = DetailDistanceUtil.getDetailLevelFromDistance(minDistance);
        byte by = farModeSwitchLevel = priority == GenerationPriority.NEAR_FIRST ? (byte)-1 : (byte)LodRegion.calculateFarModeSwitch(targetDetailLevel);
        if (priority == GenerationPriority.FAR_FIRST) {
            farModeSwitchLevel = 8;
        }
        boolean doesDataExist = this.doesDataExist(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size, testerGenMode);
        boolean bl = isFarModeSwitchEdge = needFarPos && detailLevel <= farModeSwitchLevel;
        if (isFarModeSwitchEdge) {
            needFarPos = false;
        }
        if (targetDetailLevel >= detailLevel) {
            if (!doesDataExist) {
                if (isFarModeSwitchEdge) {
                    posToGenerate.addFarPosToGenerate(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size, shouldSort);
                } else {
                    posToGenerate.addNearPosToGenerate(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size, shouldSort);
                }
            }
        } else if (!doesDataExist && isFarModeSwitchEdge) {
            posToGenerate.addFarPosToGenerate(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size, shouldSort);
        } else if (detailLevel > 4) {
            for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    this.getPosToGenerate(posToGenerate, childDetailLevel, childOffsetPosX + x, childOffsetPosZ + z, playerPosX, playerPosZ, priority, genMode, shouldSort, needFarPos);
                }
            }
        } else {
            this.getPosToGenerate(posToGenerate, childDetailLevel, childOffsetPosX, childOffsetPosZ, playerPosX, playerPosZ, priority, genMode, shouldSort, needFarPos);
        }
    }

    public byte getRenderDetailLevelAt(int playerPosX, int playerPosZ, byte detailLevel, int offsetX, int offsetZ) {
        byte renderLevel;
        GenerationPriority generationPriority = CONFIG.client().worldGenerator().getResolvedGenerationPriority();
        DropoffQuality dropoffQuality = CONFIG.client().graphics().quality().getResolvedDropoffQuality();
        double minDistance = LevelPosUtil.minDistance((byte)9, this.regionPosX, this.regionPosZ, playerPosX, playerPosZ);
        byte targetLevel = DetailDistanceUtil.getDetailLevelFromDistance(minDistance);
        if (targetLevel > dropoffQuality.fastModeSwitch) {
            double centerDistance = LevelPosUtil.centerDistance((byte)9, this.regionPosX, this.regionPosZ, playerPosX, playerPosZ);
            renderLevel = DetailDistanceUtil.getDetailLevelFromDistance(centerDistance);
        } else {
            int size = 1 << 9 - detailLevel;
            double posMinDistance = LevelPosUtil.minDistance(detailLevel, LevelPosUtil.getRegionModule(detailLevel, offsetX) + this.regionPosX * size, LevelPosUtil.getRegionModule(detailLevel, offsetZ) + this.regionPosZ * size, playerPosX, playerPosZ);
            renderLevel = DetailDistanceUtil.getDetailLevelFromDistance(posMinDistance);
        }
        return (byte)Math.max(this.getMinDetailLevel(), renderLevel);
    }

    public void getPosToRender(PosToRenderContainer posToRender, int playerPosX, int playerPosZ) {
        GenerationPriority generationPriority = CONFIG.client().worldGenerator().getResolvedGenerationPriority();
        DropoffQuality dropoffQuality = CONFIG.client().graphics().quality().getResolvedDropoffQuality();
        this.getPosToRender(posToRender, playerPosX, playerPosZ, generationPriority, dropoffQuality);
    }

    private void getPosToRender(PosToRenderContainer posToRender, int playerPosX, int playerPosZ, GenerationPriority priority, DropoffQuality dropoffQuality) {
        double minDistance = LevelPosUtil.minDistance((byte)9, this.regionPosX, this.regionPosZ, playerPosX, playerPosZ);
        byte targetLevel = DetailDistanceUtil.getDetailLevelFromDistance(minDistance);
        if (targetLevel <= dropoffQuality.fastModeSwitch) {
            this.getPosToRender(posToRender, (byte)9, 0, 0, playerPosX, playerPosZ, priority);
        } else {
            byte farModeSwitchLevel;
            double centerDistance = LevelPosUtil.centerDistance((byte)9, this.regionPosX, this.regionPosZ, playerPosX, playerPosZ);
            targetLevel = DetailDistanceUtil.getDetailLevelFromDistance(centerDistance);
            byte by = farModeSwitchLevel = priority == GenerationPriority.NEAR_FIRST ? (byte)0 : LodRegion.calculateFarModeSwitch(targetLevel);
            if (priority == GenerationPriority.FAR_FIRST) {
                farModeSwitchLevel = 8;
            }
            this.getPosToRenderFlat(posToRender, (byte)9, 0, 0, targetLevel, farModeSwitchLevel);
        }
    }

    private void getPosToRender(PosToRenderContainer posToRender, byte detailLevel, int offsetPosX, int offsetPosZ, int playerPosX, int playerPosZ, GenerationPriority priority) {
        byte farModeSwitchLevel;
        int size = 1 << 9 - detailLevel;
        double minDistance = LevelPosUtil.minDistance(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size, playerPosX, playerPosZ);
        byte minLevel = DetailDistanceUtil.getDetailLevelFromDistance(minDistance);
        byte by = farModeSwitchLevel = priority == GenerationPriority.NEAR_FIRST ? (byte)0 : LodRegion.calculateFarModeSwitch(minLevel);
        if (priority == GenerationPriority.FAR_FIRST) {
            farModeSwitchLevel = 8;
        }
        if (detailLevel <= minLevel) {
            posToRender.addPosToRender(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size);
        } else {
            int childPosX = (offsetPosX + this.regionPosX * size) * 2;
            int childPosZ = (offsetPosZ + this.regionPosZ * size) * 2;
            byte childDetailLevel = (byte)(detailLevel - 1);
            if (detailLevel > farModeSwitchLevel) {
                for (int x = 0; x <= 1; ++x) {
                    for (int z = 0; z <= 1; ++z) {
                        if (!this.doesDataExist(childDetailLevel, childPosX + x, childPosZ + z, DistanceGenerationMode.NONE)) continue;
                        this.getPosToRender(posToRender, childDetailLevel, offsetPosX * 2 + x, offsetPosZ * 2 + z, playerPosX, playerPosZ, priority);
                    }
                }
            } else {
                int z;
                int x;
                int childrenCount = 0;
                for (x = 0; x <= 1; ++x) {
                    for (z = 0; z <= 1; ++z) {
                        if (!this.doesDataExist(childDetailLevel, childPosX + x, childPosZ + z, DistanceGenerationMode.NONE)) continue;
                        ++childrenCount;
                    }
                }
                if (childrenCount == 4) {
                    for (x = 0; x <= 1; ++x) {
                        for (z = 0; z <= 1; ++z) {
                            this.getPosToRender(posToRender, childDetailLevel, offsetPosX * 2 + x, offsetPosZ * 2 + z, playerPosX, playerPosZ, priority);
                        }
                    }
                } else {
                    posToRender.addPosToRender(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size);
                }
            }
        }
    }

    private void getPosToRenderFlat(PosToRenderContainer posToRender, byte detailLevel, int offsetPosX, int offsetPosZ, byte targetLevel, byte farModeSwitchLevel) {
        int size = 1 << 9 - detailLevel;
        if (detailLevel == targetLevel) {
            posToRender.addPosToRender(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size);
        } else {
            int childPosX = (offsetPosX + this.regionPosX * size) * 2;
            int childPosZ = (offsetPosZ + this.regionPosZ * size) * 2;
            byte childDetailLevel = (byte)(detailLevel - 1);
            if (detailLevel > farModeSwitchLevel) {
                for (int x = 0; x <= 1; ++x) {
                    for (int z = 0; z <= 1; ++z) {
                        if (!this.doesDataExist(childDetailLevel, childPosX + x, childPosZ + z, DistanceGenerationMode.NONE)) continue;
                        this.getPosToRenderFlat(posToRender, childDetailLevel, offsetPosX * 2 + x, offsetPosZ * 2 + z, targetLevel, farModeSwitchLevel);
                    }
                }
            } else {
                int z;
                int x;
                int childrenCount = 0;
                for (x = 0; x <= 1; ++x) {
                    for (z = 0; z <= 1; ++z) {
                        if (!this.doesDataExist(childDetailLevel, childPosX + x, childPosZ + z, DistanceGenerationMode.RENDERABLE)) continue;
                        ++childrenCount;
                    }
                }
                if (childrenCount == 4) {
                    for (x = 0; x <= 1; ++x) {
                        for (z = 0; z <= 1; ++z) {
                            this.getPosToRenderFlat(posToRender, childDetailLevel, offsetPosX * 2 + x, offsetPosZ * 2 + z, targetLevel, farModeSwitchLevel);
                        }
                    }
                } else {
                    posToRender.addPosToRender(detailLevel, offsetPosX + this.regionPosX * size, offsetPosZ + this.regionPosZ * size);
                }
            }
        }
    }

    public Iterator<LevelPos> posToRenderIterator() {
        return new Iterator<LevelPos>(){
            final byte minDetail;
            int offsetX;
            int offsetZ;
            final int size;
            {
                this.minDetail = LodRegion.this.minDetailLevel;
                this.offsetX = 0;
                this.offsetZ = 0;
                this.size = 1 << 9 - this.minDetail;
            }

            private void advance() {
            }

            @Override
            public boolean hasNext() {
                return this.offsetZ >= this.size;
            }

            @Override
            public LevelPos next() {
                return null;
            }
        };
    }

    public void updateArea(byte detailLevel, int posX, int posZ) {
        for (byte down = (byte)(this.minDetailLevel + 1); down <= detailLevel; down = (byte)(down + 1)) {
            int startX = LevelPosUtil.convert(detailLevel, posX, down);
            int startZ = LevelPosUtil.convert(detailLevel, posZ, down);
            int width = 1 << detailLevel - down;
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    this.update(down, startX + x, startZ + z);
                }
            }
        }
        for (byte up = (byte)(Math.max(detailLevel, this.minDetailLevel) + 1); up <= 9; up = (byte)(up + 1)) {
            this.update(up, LevelPosUtil.convert(detailLevel, posX, up), LevelPosUtil.convert(detailLevel, posZ, up));
        }
        this.needSignalToRegenBuffer = true;
    }

    public boolean regenerateLodFromArea(byte detailLevel, int posX, int posZ, int widthX, int widthZ) {
        if (detailLevel >= 9) {
            return false;
        }
        int modPosX = LevelPosUtil.getRegionModule(detailLevel, posX);
        int modPosZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        if (detailLevel < this.minDetailLevel) {
            byte startLevel = this.minDetailLevel;
            int maxPosX = Math.floorDiv(modPosX + widthX - 1, 1 << this.minDetailLevel - startLevel) + 1;
            int maxPosZ = Math.floorDiv(modPosZ + widthZ - 1, 1 << this.minDetailLevel - startLevel) + 1;
            modPosX = Math.floorDiv(modPosX, 1 << this.minDetailLevel - startLevel);
            modPosZ = Math.floorDiv(modPosZ, 1 << this.minDetailLevel - startLevel);
            widthX = maxPosX - modPosX;
            widthZ = maxPosZ - modPosZ;
            detailLevel = this.minDetailLevel;
        }
        do {
            int maxPosX = Math.floorDiv(modPosX + widthX - 1, 2) + 1;
            int maxPosZ = Math.floorDiv(modPosZ + widthZ - 1, 2) + 1;
            modPosX = Math.floorDiv(modPosX, 2);
            modPosZ = Math.floorDiv(modPosZ, 2);
            widthX = maxPosX - modPosX;
            widthZ = maxPosZ - modPosZ;
            detailLevel = (byte)(detailLevel + 1);
            this.chunkUpdate(detailLevel, modPosX, modPosZ, widthX, widthZ);
        } while (detailLevel < 9);
        this.needSignalToRegenBuffer = true;
        return true;
    }

    private void update(byte detailLevel, int modPosX, int modPosZ) {
        this.dataContainer[detailLevel].updateData(this.dataContainer[detailLevel - 1], modPosX, modPosZ);
    }

    private void chunkUpdate(byte detailLevel, int modPosX, int modPosZ, int widthX, int widthZ) {
        for (int ox = 0; ox < widthX; ++ox) {
            for (int oz = 0; oz < widthZ; ++oz) {
                this.update(detailLevel, modPosX + ox, modPosZ + oz);
            }
        }
    }

    public boolean doesDataExist(byte detailLevel, int posX, int posZ, DistanceGenerationMode requiredMode) {
        int modPosZ;
        if (detailLevel < this.minDetailLevel || this.dataContainer[detailLevel] == null) {
            return false;
        }
        int modPosX = LevelPosUtil.getRegionModule(detailLevel, posX);
        if (!this.dataContainer[detailLevel].doesItExist(modPosX, modPosZ = LevelPosUtil.getRegionModule(detailLevel, posZ))) {
            return false;
        }
        if (requiredMode == DistanceGenerationMode.NONE) {
            return true;
        }
        byte mode = this.getGenerationMode(detailLevel, posX, posZ);
        return mode >= requiredMode.complexity;
    }

    public byte getGenerationMode(byte detailLevel, int posX, int posZ) {
        int modPosX = LevelPosUtil.getRegionModule(detailLevel, posX);
        int modPosZ = LevelPosUtil.getRegionModule(detailLevel, posZ);
        if (this.dataContainer[detailLevel] != null && this.dataContainer[detailLevel].doesItExist(modPosX, modPosZ)) {
            return DataPointUtil.getGenerationMode(this.dataContainer[detailLevel].getSingleData(modPosX, modPosZ));
        }
        throw new RuntimeException("Data does not exist!");
    }

    public byte getMinDetailLevel() {
        return this.minDetailLevel;
    }

    public LevelContainer getLevel(byte detailLevel) {
        if (detailLevel < this.minDetailLevel) {
            throw new IllegalArgumentException("getLevel asked for a detail level that does not exist: minimum: [" + this.minDetailLevel + "] level requested: [" + detailLevel + "]");
        }
        return this.dataContainer[detailLevel];
    }

    public void addLevelContainer(LevelContainer levelContainer) {
        if (levelContainer.getDetailLevel() < this.minDetailLevel - 1) {
            throw new IllegalArgumentException("the LevelContainer's detailLevel was [" + levelContainer.getDetailLevel() + "] but this region only allows adding LevelContainers with a detail level of [" + (this.minDetailLevel - 1) + "]");
        }
        this.dataContainer[levelContainer.getDetailLevel()] = levelContainer;
        if (levelContainer.getDetailLevel() == this.minDetailLevel - 1) {
            this.minDetailLevel = levelContainer.getDetailLevel();
        }
        this.needRecheckGenPoint = true;
    }

    public void cutTree(byte detailLevel) {
        if (detailLevel > this.minDetailLevel) {
            this.minDetailLevel = detailLevel;
            for (byte detailLevelIndex = 0; detailLevelIndex < detailLevel; detailLevelIndex = (byte)(detailLevelIndex + 1)) {
                this.dataContainer[detailLevelIndex] = null;
            }
        }
    }

    public void growTree(byte detailLevel) {
        if (detailLevel < this.minDetailLevel) {
            for (byte detailLevelIndex = (byte)(this.minDetailLevel - 1); detailLevelIndex >= detailLevel; detailLevelIndex = (byte)(detailLevelIndex - 1)) {
                if (this.dataContainer[detailLevelIndex + 1] == null) {
                    this.dataContainer[detailLevelIndex + 1] = new VerticalLevelContainer((byte)(detailLevelIndex + 1));
                }
                this.dataContainer[detailLevelIndex] = this.dataContainer[detailLevelIndex + 1].expand();
            }
            this.minDetailLevel = detailLevel;
            this.needRecheckGenPoint = true;
        }
    }

    public RegionPos getRegionPos() {
        return new RegionPos(this.regionPosX, this.regionPosZ);
    }

    public int getNumberOfLods() {
        int count = 0;
        for (LevelContainer container : this.dataContainer) {
            count += container.getMaxNumberOfLods();
        }
        return count;
    }

    public VerticalQuality getVerticalQuality() {
        return this.verticalQuality;
    }

    public int getMaxVerticalData(byte detailLevel) {
        return this.dataContainer[detailLevel].getVerticalSize();
    }

    public LevelContainer[] debugGetDataContainers() {
        return this.dataContainer;
    }

    public String toString() {
        return this.getLevel((byte)9).toString();
    }

    public static final class LevelPos {
        public final byte detail;
        public final int posX;
        public final int posZ;

        LevelPos(byte d, int x, int z) {
            this.detail = d;
            this.posX = x;
            this.posZ = z;
        }
    }
}

