/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.util.LevelPosUtil;
import java.util.Arrays;

public class PosToRenderContainer {
    public byte minDetail;
    private int regionPosX;
    private int regionPosZ;
    private int numberOfPosToRender;
    private int[] posToRender;
    private byte[][] population;

    public PosToRenderContainer(byte minDetail, int regionPosX, int regionPosZ) {
        this.minDetail = minDetail;
        this.numberOfPosToRender = 0;
        this.regionPosX = regionPosX;
        this.regionPosZ = regionPosZ;
        int size = 1 << 9 - minDetail;
        this.posToRender = new int[size * size * 3];
        this.population = new byte[size][size];
    }

    public void addPosToRender(byte detailLevel, int posX, int posZ) {
        if (this.numberOfPosToRender >= this.posToRender.length) {
            ApiShared.LOGGER.error("Unable to addPosToRender. numberOfPosToRender [" + this.numberOfPosToRender + "] detailLevel [" + detailLevel + "] Pos [" + posX + "," + posZ + "]");
            ++this.numberOfPosToRender;
            return;
        }
        this.posToRender[this.numberOfPosToRender * 3] = detailLevel;
        this.posToRender[this.numberOfPosToRender * 3 + 1] = posX;
        this.posToRender[this.numberOfPosToRender * 3 + 2] = posZ;
        ++this.numberOfPosToRender;
        this.population[LevelPosUtil.getRegionModule((byte)this.minDetail, (int)LevelPosUtil.convert((byte)detailLevel, (int)posX, (byte)this.minDetail))][LevelPosUtil.getRegionModule((byte)this.minDetail, (int)LevelPosUtil.convert((byte)detailLevel, (int)posZ, (byte)this.minDetail))] = (byte)(detailLevel + 1);
    }

    public boolean contains(byte detailLevel, int posX, int posZ) {
        if (LevelPosUtil.getRegion(detailLevel, posX) == this.regionPosX && LevelPosUtil.getRegion(detailLevel, posZ) == this.regionPosZ) {
            return this.population[LevelPosUtil.getRegionModule(this.minDetail, LevelPosUtil.convert(detailLevel, posX, this.minDetail))][LevelPosUtil.getRegionModule(this.minDetail, LevelPosUtil.convert(detailLevel, posZ, this.minDetail))] == detailLevel + 1;
        }
        return false;
    }

    public void clear(byte minDetail, int regionPosX, int regionPosZ) {
        this.numberOfPosToRender = 0;
        this.regionPosX = regionPosX;
        this.regionPosZ = regionPosZ;
        if (this.minDetail == minDetail) {
            Arrays.fill(this.posToRender, 0);
            for (byte[] bytes : this.population) {
                Arrays.fill(bytes, (byte)0);
            }
        } else {
            this.minDetail = minDetail;
            int size = 1 << 9 - minDetail;
            this.posToRender = new int[size * size * 3];
            this.population = new byte[size][size];
        }
    }

    public int getNumberOfPos() {
        return this.numberOfPosToRender;
    }

    public byte getNthDetailLevel(int n) {
        return (byte)this.posToRender[n * 3];
    }

    public int getNthPosX(int n) {
        return this.posToRender[n * 3 + 1];
    }

    public int getNthPosZ(int n) {
        return this.posToRender[n * 3 + 2];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("To render ");
        builder.append(this.numberOfPosToRender);
        builder.append('\n');
        for (int i = 0; i < this.numberOfPosToRender; ++i) {
            builder.append(this.posToRender[i * 3]);
            builder.append(" ");
            builder.append(this.posToRender[i * 3 + 1]);
            builder.append(" ");
            builder.append(this.posToRender[i * 3 + 2]);
            builder.append('\n');
        }
        builder.append('\n');
        return builder.toString();
    }
}

