/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpl.tag.TagType;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.tags.EditorTagManager;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelPartTags
implements IModelPart,
IResolvedModelPart {
    private TagType type;
    private Map<String, List<String>> tags;

    public ModelPartTags(IOHelper in, ModelDefinition def) throws IOException {
        this.type = (TagType)in.readEnum(TagType.VALUES);
        this.tags = new HashMap<String, List<String>>();
        int c = in.readVarInt();
        for (int i = 0; i < c; ++i) {
            String id = in.readUTF();
            int ec = in.readVarInt();
            ArrayList<String> elems = new ArrayList<String>();
            this.tags.put(id, elems);
            for (int j = 0; j < ec; ++j) {
                String el = in.readUTF();
                elems.add(el);
            }
        }
    }

    public ModelPartTags(TagType type, EditorTagManager<?> tagMngr) {
        this.type = type;
        this.tags = tagMngr.toMap();
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeEnum(this.type);
        dout.writeVarInt(this.tags.size());
        for (Map.Entry<String, List<String>> e : this.tags.entrySet()) {
            dout.writeUTF(e.getKey());
            dout.writeVarInt(e.getValue().size());
            for (String el : e.getValue()) {
                dout.writeUTF(el);
            }
        }
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.TAGS;
    }

    @Override
    public void apply(ModelDefinition def) {
        def.modelTagManager.getByType(this.type).fromMap(this.tags);
    }

    public String toString() {
        StringBuilder bb = new StringBuilder("Tags: ");
        bb.append((Object)this.type);
        for (Map.Entry<String, List<String>> e : this.tags.entrySet()) {
            bb.append("\n\t");
            bb.append(e.getKey());
            bb.append(":");
            for (String el : e.getValue()) {
                bb.append("\n\t\t");
                bb.append(el);
            }
        }
        return bb.toString();
    }
}

