/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.FirstPersonDetector;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.vr.VRPlayerRenderer;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.mixinplugin.FPMDetector;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_2190;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_591;
import net.minecraft.class_7923;

public class PlayerProfile
extends Player<class_1657> {
    public static boolean inGui;
    public static BooleanSupplier inFirstPerson;
    private final GameProfile profile;
    private String skinType;

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.getId(), profile.getName());
        PlayerProfile.cloneProperties(profile.getProperties(), this.profile.getProperties());
        if (profile.getId() != null) {
            this.skinType = class_1068.method_4647((UUID)profile.getId());
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    @Override
    public void updateFromPlayer(class_1657 player) {
        float f1;
        float f;
        class_1799 is;
        class_4050 p = player.method_18376();
        this.animState.resetPlayer();
        switch (p) {
            case field_18077: {
                this.animState.elytraFlying = true;
                break;
            }
            case field_18078: {
                this.animState.sleeping = true;
                break;
            }
            case field_18080: {
                this.animState.tridentSpin = true;
                break;
            }
        }
        this.animState.sneaking = player.method_18276();
        this.animState.crawling = player.method_20448();
        this.animState.swimming = player.method_20232();
        if (!player.method_5805()) {
            this.animState.dying = true;
        }
        if (Platform.isSitting(player)) {
            this.animState.riding = true;
        }
        if (player.method_5624()) {
            this.animState.sprinting = true;
        }
        if (player.method_6115()) {
            this.animState.usingAnimation = HandAnimation.of(player.method_6030().method_7976());
        }
        if (player.method_5799()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.method_23317() - player.field_6014);
        this.animState.moveAmountY = (float)(player.method_23318() - player.field_6036);
        this.animState.moveAmountZ = (float)(player.method_23321() - player.field_5969);
        this.animState.yaw = player.method_36454();
        this.animState.pitch = player.method_36455();
        this.animState.bodyYaw = player.field_6283;
        if (player.method_7348(class_1664.field_7563)) {
            this.animState.encodedState |= 1;
        }
        if (player.method_7348(class_1664.field_7564)) {
            this.animState.encodedState |= 2;
        }
        if (player.method_7348(class_1664.field_7566)) {
            this.animState.encodedState |= 4;
        }
        if (player.method_7348(class_1664.field_7565)) {
            this.animState.encodedState |= 8;
        }
        if (player.method_7348(class_1664.field_7568)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.method_7348(class_1664.field_7570)) {
            this.animState.encodedState |= 0x20;
        }
        this.animState.hasSkullOnHead = (is = player.method_6118(class_1304.field_6169)).method_7909() instanceof class_1747 && ((class_1747)is.method_7909()).method_7711() instanceof class_2190;
        this.animState.wearingHelm = !is.method_7960();
        is = player.method_6118(class_1304.field_6174);
        this.animState.wearingElytra = is.method_7909() instanceof class_1770;
        this.animState.wearingBody = !is.method_7960();
        this.animState.wearingLegs = !player.method_6118(class_1304.field_6172).method_7960();
        this.animState.wearingBoots = !player.method_6118(class_1304.field_6166).method_7960();
        this.animState.mainHand = Hand.of(player.method_6068());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.method_6058());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.field_6266);
        this.animState.hurtTime = player.field_6235;
        this.animState.isOnLadder = player.method_6101();
        this.animState.isBurning = player.method_5862();
        this.animState.isFreezing = player.method_32312() > 0;
        this.animState.inGui = inGui;
        this.animState.firstPersonMod = inFirstPerson.getAsBoolean();
        PlayerInventory.setInv(this.animState, player.method_31548());
        WorldImpl.setWorld(this.animState, (class_1297)player);
        if (player.method_5854() != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.method_5854().method_5864());
        }
        player.method_6026().forEach(e -> this.animState.allEffects.add(new ActiveEffect(class_7923.field_41174.method_10221((Object)e.method_5579()).toString(), e.method_5578(), e.method_5584(), !e.method_5581())));
        if (player.method_6030().method_7909() instanceof class_1764) {
            f = class_1764.method_7775((class_1799)player.method_6030());
            f1 = MathHelper.clamp((float)player.method_6048(), 0.0f, f);
            this.animState.crossbowPullback = f1 / f;
        }
        if (player.method_6030().method_7909() instanceof class_1753) {
            f = 20.0f;
            f1 = MathHelper.clamp((float)player.method_6048(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
        this.animState.parrotLeft = !player.method_7356().method_10558("id").isEmpty();
        this.animState.parrotRight = !player.method_7308().method_10558("id").isEmpty();
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof class_591) {
            class_591 m = (class_591)model;
            this.animState.resetModel();
            this.animState.attackTime = m.field_3447;
            this.animState.swimAmount = m.field_3396;
            this.animState.leftArm = PlayerModelSetup.ArmPose.of(m.field_3399);
            this.animState.rightArm = PlayerModelSetup.ArmPose.of(m.field_3395);
            if (CustomPlayerModelsClient.vrLoaded) {
                this.animState.vrState = VRPlayerRenderer.getVRState(this.animState.animationMode, model);
            }
        }
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        return new PlayerTextureLoader(class_310.method_1551().method_1582().field_5305){

            @Override
            protected CompletableFuture<Void> load0() {
                Map map = class_310.method_1551().method_1582().method_4654(PlayerProfile.this.profile);
                this.defineAll(map, MinecraftProfileTexture::getUrl, MinecraftProfileTexture::getHash);
                if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    MinecraftProfileTexture tex = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
                    PlayerProfile.this.skinType = tex.getMetadata("model");
                    if (PlayerProfile.this.skinType == null) {
                        PlayerProfile.this.skinType = "default";
                    }
                    return CompletableFuture.completedFuture(null);
                }
                final CompletableFuture<Void> cf = new CompletableFuture<Void>();
                class_310.method_1551().method_1582().method_4652(PlayerProfile.this.profile, new class_1071.class_1072(){

                    public void onSkinTextureAvailable(MinecraftProfileTexture.Type typeIn, class_2960 location, MinecraftProfileTexture profileTexture) {
                        this.defineTexture((Enum)typeIn, profileTexture.getUrl(), profileTexture.getHash());
                        switch (typeIn) {
                            case SKIN: {
                                PlayerProfile.this.skinType = profileTexture.getMetadata("model");
                                if (PlayerProfile.this.skinType == null) {
                                    PlayerProfile.this.skinType = "default";
                                }
                                RenderSystem.recordRenderCall(() -> cf.complete(null));
                                break;
                            }
                        }
                    }
                }, true);
                return cf;
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.getName();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    static {
        inFirstPerson = () -> false;
        if (FPMDetector.doApply()) {
            FirstPersonDetector.init();
        }
    }
}

