/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.itr;

import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

public class FilterListIterator<T>
implements ListIterator<T> {
    private final Predicate<T> predicate;
    private final ListIterator<T> itr;
    private T next;
    private T previous;

    public static <T> FilterListIterator<T> skipNull(ListIterator<T> itr) {
        return new FilterListIterator<Object>(itr, x -> x != null);
    }

    public FilterListIterator(List iterable, Class clazz) {
        this(iterable.listIterator(), clazz);
    }

    public FilterListIterator(ListIterator iterable, Class clazz) {
        this(iterable, (T x) -> clazz.isInstance(x));
    }

    public FilterListIterator(List<T> iterable, Predicate<T> predicate) {
        this(iterable.listIterator(), predicate);
    }

    public FilterListIterator(ListIterator<T> iterator, Predicate<T> predicate) {
        this.itr = iterator;
        this.predicate = predicate;
        this.findNext();
        this.findPrevious();
    }

    private void findNext() {
        while (this.next == null && this.itr.hasNext()) {
            T object = this.itr.next();
            if (!this.predicate.test(object)) continue;
            this.next = object;
            return;
        }
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T result = this.next;
        this.next = null;
        this.previous = result;
        this.findNext();
        return result;
    }

    @Override
    public int nextIndex() {
        return this.itr.nextIndex();
    }

    private void findPrevious() {
        while (this.previous == null && this.itr.hasPrevious()) {
            T object = this.itr.previous();
            if (!this.predicate.test(object)) continue;
            this.previous = object;
            return;
        }
        this.previous = null;
    }

    @Override
    public boolean hasPrevious() {
        return this.previous != null;
    }

    @Override
    public T previous() {
        T result = this.previous;
        this.previous = null;
        this.next = result;
        this.findPrevious();
        return result;
    }

    @Override
    public int previousIndex() {
        return this.itr.previousIndex();
    }

    @Override
    public void remove() {
        this.itr.remove();
    }

    @Override
    public void set(T e) {
        this.itr.set(e);
    }

    @Override
    public void add(T e) {
        this.itr.add(e);
    }
}

