/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.text.content.ContentItemStack;

public class TextBuilder {
    private static NumberFormat format = NumberFormat.getNumberInstance(Locale.US);
    private final List<class_2561> lines = new ArrayList<class_2561>();

    public TextBuilder() {
    }

    public TextBuilder add(List<class_2561> components) {
        for (class_2561 component : components) {
            this.add(component);
        }
        return this;
    }

    public TextBuilder add(class_2561 component) {
        if (this.lines.isEmpty()) {
            this.lines.add(component);
        } else {
            this.lines.get(this.lines.size() - 1).method_10855().add(component);
        }
        return this;
    }

    public TextBuilder(String text) {
        this.text(text);
    }

    public TextBuilder translateIfCan(String text) {
        String translated = GuiControl.translate(text, new Object[0]);
        if (!translated.equals(text)) {
            this.add((class_2561)class_2561.method_43471((String)text));
        }
        return this;
    }

    public TextBuilder translate(String text) {
        this.add((class_2561)class_2561.method_43471((String)text));
        return this;
    }

    public TextBuilder translate(String text, Object ... param) {
        this.add((class_2561)class_2561.method_43469((String)text, (Object[])param));
        return this;
    }

    public TextBuilder text(String text) {
        this.add((class_2561)class_2561.method_43470((String)text));
        return this;
    }

    public TextBuilder number(float number) {
        return this.number(number, false);
    }

    public TextBuilder number(float number, boolean rounded) {
        if (rounded) {
            this.text("" + Math.round(number));
        } else {
            this.text(format.format(number));
        }
        return this;
    }

    public TextBuilder number(double number) {
        return this.number(number, false);
    }

    public TextBuilder number(double number, boolean rounded) {
        if (rounded) {
            this.text("" + Math.round(number));
        } else {
            this.text(format.format(number));
        }
        return this;
    }

    public TextBuilder newLine() {
        this.lines.add((class_2561)class_2561.method_43473());
        return this;
    }

    public TextBuilder color(int color) {
        int r = ColorUtils.red(color);
        int g = ColorUtils.green(color);
        int b = ColorUtils.blue(color);
        int a = ColorUtils.alpha(color);
        this.text(class_124.field_1061 + r + " " + class_124.field_1060 + g + " " + class_124.field_1078 + b + (String)(a < 255 ? " " + class_124.field_1068 + a : ""));
        return this;
    }

    public TextBuilder stack(class_1799 stack) {
        this.add((class_2561)class_5250.method_43477((class_7417)new ContentItemStack(stack)));
        return this;
    }

    public List<class_2561> build() {
        return this.lines;
    }
}

