/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_7833;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.geo.NormalPlane;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Facing {
    DOWN(Axis.Y, false, new class_2382(0, -1, 0), -1){

        @Override
        public Facing opposite() {
            return UP;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11033;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1322;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40715;
        }
    }
    ,
    UP(Axis.Y, true, new class_2382(0, 1, 0), -1){

        @Override
        public Facing opposite() {
            return DOWN;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11036;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1325;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40716;
        }
    }
    ,
    NORTH(Axis.Z, false, new class_2382(0, 0, -1), 2){

        @Override
        public Facing opposite() {
            return SOUTH;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11043;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1321;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40717;
        }
    }
    ,
    SOUTH(Axis.Z, true, new class_2382(0, 0, 1), 0){

        @Override
        public Facing opposite() {
            return NORTH;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11035;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1324;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40718;
        }
    }
    ,
    WEST(Axis.X, false, new class_2382(-1, 0, 0), 1){

        @Override
        public Facing opposite() {
            return EAST;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11039;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1323;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40713;
        }
    }
    ,
    EAST(Axis.X, true, new class_2382(1, 0, 0), 3){

        @Override
        public Facing opposite() {
            return WEST;
        }

        @Override
        public class_2350 toVanilla() {
            return class_2350.field_11034;
        }

        @Override
        public double get(class_238 bb) {
            return bb.field_1320;
        }

        @Override
        public class_7833 rotation() {
            return class_7833.field_40714;
        }
    };

    public static final Facing[] VALUES;
    public static final Facing[] HORIZONTA_VALUES;
    public static final String[] FACING_NAMES;
    public static final String[] HORIZONTAL_FACING_NAMES;
    public final String name = this.name().toLowerCase();
    public final Axis axis;
    public final boolean positive;
    public final class_2382 normal;
    public final NormalPlane plane;
    public final int horizontalIndex;

    public static Facing get(int index) {
        switch (index) {
            case 0: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return NORTH;
            }
            case 3: {
                return SOUTH;
            }
            case 4: {
                return WEST;
            }
            case 5: {
                return EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Facing get(class_2350 direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> DOWN;
            case class_2350.field_11036 -> UP;
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
        };
    }

    public static Facing get(Axis axis, boolean positive) {
        switch (axis) {
            case X: {
                return positive ? EAST : WEST;
            }
            case Y: {
                return positive ? UP : DOWN;
            }
            case Z: {
                return positive ? SOUTH : NORTH;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Facing getHorizontal(int index) {
        return HORIZONTA_VALUES[index];
    }

    public static Facing direction(class_2382 pos, class_2382 second) {
        if (pos.method_10263() == second.method_10263()) {
            if (pos.method_10264() == second.method_10264()) {
                if (pos.method_10260() == second.method_10260() + 1) {
                    return SOUTH;
                }
                return NORTH;
            }
            if (pos.method_10264() == second.method_10264() + 1) {
                return UP;
            }
            return DOWN;
        }
        if (pos.method_10263() == second.method_10263() + 1) {
            return EAST;
        }
        return WEST;
    }

    private Facing(Axis axis, boolean positive, class_2382 normal, int horizontalIndex) {
        this.axis = axis;
        this.positive = positive;
        this.normal = normal;
        this.plane = new NormalPlane(this);
        this.horizontalIndex = horizontalIndex;
    }

    public int offset() {
        return this.positive ? 1 : -1;
    }

    public int offset(Axis axis) {
        if (this.axis == axis) {
            return this.offset();
        }
        return 0;
    }

    public abstract Facing opposite();

    public abstract class_2350 toVanilla();

    public Axis one() {
        return this.axis.one();
    }

    public Axis two() {
        return this.axis.two();
    }

    public Axis getUAxis() {
        switch (this.axis) {
            case X: {
                return Axis.Z;
            }
            case Y: {
                return Axis.X;
            }
            case Z: {
                return Axis.X;
            }
        }
        return null;
    }

    public Axis getVAxis() {
        switch (this.axis) {
            case X: {
                return Axis.Y;
            }
            case Y: {
                return Axis.Z;
            }
            case Z: {
                return Axis.Y;
            }
        }
        return null;
    }

    public float getU(float x, float y, float z) {
        switch (this.axis) {
            case X: {
                return z;
            }
            case Y: {
                return x;
            }
            case Z: {
                return x;
            }
        }
        return 0.0f;
    }

    public float getV(float x, float y, float z) {
        switch (this.axis) {
            case X: {
                return y;
            }
            case Y: {
                return z;
            }
            case Z: {
                return y;
            }
        }
        return 0.0f;
    }

    public abstract double get(class_238 var1);

    public abstract class_7833 rotation();

    static {
        VALUES = new Facing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        HORIZONTA_VALUES = new Facing[]{SOUTH, WEST, NORTH, EAST};
        FACING_NAMES = new String[]{"down", "up", "north", "south", "west", "east"};
        HORIZONTAL_FACING_NAMES = new String[]{"north", "south", "west", "east"};
    }
}

