/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_3614;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientMaterial;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CreativeIngredient {
    public static final NamedTypeRegistry<CreativeIngredient> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[0]);
    private static List<Function<Object, ? extends CreativeIngredient>> objectParsers = new ArrayList<Function<Object, ? extends CreativeIngredient>>();

    public static <T extends CreativeIngredient> void registerType(String id, Class<T> classType, Function<Object, T> parser) {
        REGISTRY.register(id, classType);
        if (parser != null) {
            objectParsers.add(parser);
        }
    }

    public static CreativeIngredient parse(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CreativeIngredient) {
            return (CreativeIngredient)object;
        }
        for (int i = 0; i < objectParsers.size(); ++i) {
            try {
                CreativeIngredient ingredient = objectParsers.get(i).apply(object);
                if (ingredient == null) continue;
                return ingredient;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CreativeIngredient load(class_2487 nbt) {
        Class<CreativeIngredient> classType = REGISTRY.get(nbt.method_10558("id"));
        if (classType == null) {
            throw new IllegalArgumentException("'" + nbt.method_10558("id") + "' is an invalid type");
        }
        try {
            CreativeIngredient ingredient = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            ingredient.loadExtra(nbt);
            return ingredient;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public class_2487 save() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("id", REGISTRY.getId(this));
        this.saveExtra(nbt);
        return nbt;
    }

    protected abstract void saveExtra(class_2487 var1);

    protected abstract void loadExtra(class_2487 var1);

    public abstract boolean is(class_1799 var1);

    public abstract boolean is(CreativeIngredient var1);

    public abstract class_1799 getExample();

    public abstract CreativeIngredient copy();

    public boolean equals(Object object) {
        return object instanceof CreativeIngredient && this.equals((CreativeIngredient)object);
    }

    public abstract boolean equals(CreativeIngredient var1);

    public abstract class_2561 description();

    public abstract class_2561 descriptionDetail();

    static {
        CreativeIngredient.registerType("block", CreativeIngredientBlock.class, x -> {
            class_2248 block = null;
            if (x instanceof class_2248) {
                block = (class_2248)x;
            }
            if (x instanceof class_1747) {
                block = class_2248.method_9503((class_1792)((class_1792)x));
            }
            if (block != null && !(block instanceof class_2189)) {
                return new CreativeIngredientBlock(block);
            }
            return null;
        });
        CreativeIngredient.registerType("blocktag", CreativeIngredientBlockTag.class, x -> {
            class_6862 key;
            if (x instanceof class_6862 && (key = (class_6862)x).method_41007(class_7924.field_41254)) {
                return new CreativeIngredientBlockTag((class_6862<class_2248>)((class_6862)x));
            }
            return null;
        });
        CreativeIngredient.registerType("item", CreativeIngredientItem.class, x -> {
            if (x instanceof class_1792 && !(x instanceof class_1747)) {
                return new CreativeIngredientItem((class_1792)x);
            }
            return null;
        });
        CreativeIngredient.registerType("itemtag", CreativeIngredientItemTag.class, x -> {
            class_6862 key;
            if (x instanceof class_6862 && (key = (class_6862)x).method_41007(class_7924.field_41197)) {
                return new CreativeIngredientItemTag((class_6862<class_1792>)((class_6862)x));
            }
            return null;
        });
        CreativeIngredient.registerType("itemstack", CreativeIngredientItemStack.class, x -> x instanceof class_1799 ? new CreativeIngredientItemStack((class_1799)x, false) : null);
        CreativeIngredient.registerType("material", CreativeIngredientMaterial.class, x -> x instanceof class_3614 ? new CreativeIngredientMaterial((class_3614)x) : null);
        CreativeIngredient.registerType("fuel", CreativeIngredientFuel.class, null);
        CreativeIngredientBlock temp = new CreativeIngredientBlock(class_2246.field_10566);
        ConfigTypeConveration.registerSpecialType(x -> CreativeIngredient.class.isAssignableFrom((Class<?>)x), new ConfigTypeConveration.SimpleConfigTypeConveration<CreativeIngredient>(){

            @Override
            public CreativeIngredient readElement(CreativeIngredient defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return CreativeIngredient.load(class_2522.method_10718((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(CreativeIngredient value, CreativeIngredient defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.save().toString());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiInfoStackButton("data", CreativeIngredient.this).setExpandable());
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            public void loadValue(CreativeIngredient value, GuiParent parent) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                button.set(value);
            }

            @Override
            @Environment(value=EnvType.CLIENT)
            protected CreativeIngredient saveValue(GuiParent parent, Class clazz) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                return button.get();
            }

            @Override
            public CreativeIngredient set(ConfigKey.ConfigKeyField key, CreativeIngredient value) {
                return value;
            }
        });
    }
}

