/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativeNetworkPacket;
import team.creative.creativecore.common.network.CreativePacket;

public class CreativeNetwork {
    public final class_2960 CHANNEL;
    private final HashMap<Class<? extends CreativePacket>, CreativeNetworkPacket> packetTypes = new HashMap();
    private final HashMap<Class<? extends CreativePacket>, class_2960> packetTypeChannels = new HashMap();
    private final Logger logger;
    private int id = 0;

    public CreativeNetwork(String version, Logger logger, class_2960 location) {
        this.logger = logger;
        this.CHANNEL = location;
        this.logger.debug("Created network " + location);
    }

    @Environment(value=EnvType.CLIENT)
    private static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    public <T extends CreativePacket> void registerType(Class<T> classType, Supplier<T> supplier) {
        int CURR_ID = this.id++;
        class_2960 CURR_CHANNEL = new class_2960(this.CHANNEL.method_12836(), this.CHANNEL.method_12832() + CURR_ID);
        CreativeNetworkPacket<T> packet_handler = new CreativeNetworkPacket<T>(classType, supplier);
        ServerHandler.INSTANCE.register(CURR_CHANNEL, packet_handler);
        this.packetTypes.put(classType, packet_handler);
        this.packetTypeChannels.put(classType, CURR_CHANNEL);
    }

    public CreativeNetworkPacket getPacketType(Class<? extends CreativePacket> clazz) {
        return this.packetTypes.get(clazz);
    }

    public void sendToServer(CreativePacket message) {
        class_2540 BUFF = new class_2540(Unpooled.buffer());
        this.packetTypes.get(message.getClass()).write(message, BUFF);
        ClientPlayNetworking.send((class_2960)this.packetTypeChannels.get(message.getClass()), (class_2540)BUFF);
    }

    public void sendToClient(CreativePacket message, class_3222 player) {
        class_2540 BUFF = new class_2540(Unpooled.buffer());
        this.packetTypes.get(message.getClass()).write(message, BUFF);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.packetTypeChannels.get(message.getClass()), (class_2540)BUFF);
    }

    public void sendToClientAll(MinecraftServer server, CreativePacket message) {
        class_2540 BUFF = new class_2540(Unpooled.buffer());
        this.packetTypes.get(message.getClass()).write(message, BUFF);
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.packetTypeChannels.get(message.getClass()), (class_2540)BUFF);
        }
    }

    private static class ServerHandler {
        public static ServerHandler INSTANCE = new ClientHandler();

        private ServerHandler() {
        }

        public <T extends CreativePacket> void register(class_2960 CURR_CHANNEL, CreativeNetworkPacket<T> packet_handler) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)CURR_CHANNEL, (server, player, handler, buf, responseSender) -> {
                Object message = packet_handler.read(buf);
                server.execute(() -> message.execute((class_1657)handler.method_32311()));
            });
        }
    }

    private static class ClientHandler
    extends ServerHandler {
        private ClientHandler() {
        }

        @Override
        @Environment(value=EnvType.CLIENT)
        public <T extends CreativePacket> void register(class_2960 CURR_CHANNEL, CreativeNetworkPacket<T> packet_handler) {
            super.register(CURR_CHANNEL, packet_handler);
            ClientPlayNetworking.registerGlobalReceiver((class_2960)CURR_CHANNEL, new Handler<T>(packet_handler));
        }

        @Environment(value=EnvType.CLIENT)
        private static class Handler<T extends CreativePacket>
        implements ClientPlayNetworking.PlayChannelHandler {
            private final CreativeNetworkPacket<T> packet_handler;

            Handler(CreativeNetworkPacket<T> packet) {
                this.packet_handler = packet;
            }

            public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
                Object message = this.packet_handler.read(buf);
                client.execute(() -> {
                    try {
                        message.execute((class_1657)client.field_1724);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }
}

