/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.controls.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.manager.GuiManager;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobal;
import team.creative.creativecore.common.gui.sync.GuiSyncHolder;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiManagerItem
extends GuiManager {
    private static final GuiSyncGlobal<GuiLayer, class_2487> HAND = GuiSyncHolder.GLOBAL.register("hand", (c, t) -> c.itemManager().setHand(class_1799.method_7915((class_2487)t)));
    public static final GuiSyncGlobal<GuiSlot, class_2481> DROP = GuiSyncHolder.GLOBAL.register("drop", (c, t) -> {
        boolean ctrl = t.method_10698() == 1;
        class_1735 slot = c.slot;
        class_1657 player = c.getPlayer();
        if (slot.method_7681() && slot.method_7674(player)) {
            class_1799 drop = slot.method_7677().method_7972();
            if (ctrl) {
                slot.method_7673(class_1799.field_8037);
            } else {
                drop.method_7939(1);
            }
            class_1799 newStack = slot.method_7677();
            newStack.method_7934(1);
            player.method_7328(drop, true);
            slot.method_7667(player, drop);
            c.changed();
        }
    });
    public static final GuiSyncGlobal<GuiLayer, class_2491> DROP_HAND = GuiSyncHolder.GLOBAL.register("drop_hand", (c, t) -> {
        class_1799 hand = c.itemManager().getHand();
        class_1657 player = c.getPlayer();
        if (!hand.method_7960()) {
            player.method_7328(hand, true);
            c.itemManager().setHand(class_1799.field_8037);
        }
    });
    public static final GuiSyncGlobal<GuiSlot, class_2497> INSERT = GuiSyncHolder.GLOBAL.register("insert", (c, t) -> {
        class_1735 slot = c.slot;
        GuiLayer layer = c.getLayer();
        class_1799 stack = slot.method_7677();
        int amount = Math.min(t.method_10701(), stack.method_7947());
        class_1799 insert = stack.method_7972();
        insert.method_7939(amount);
        stack.method_7934(amount);
        for (IGuiInventory inv : layer.inventoriesToInsert()) {
            if (inv == c.inventory()) continue;
            inv.insert(insert, false);
            if (!insert.method_7960()) {
                inv.insert(insert, true);
            }
            if (!insert.method_7960()) continue;
            break;
        }
        stack.method_7933(insert.method_7947());
        c.changed();
    });
    public static final GuiSyncGlobal<GuiSlot, class_2497> EXTRACT = GuiSyncHolder.GLOBAL.register("exract", (c, t) -> {
        class_1735 slot = c.slot;
        GuiLayer layer = c.getLayer();
        class_1799 stack = slot.method_7677();
        if (stack.method_7960()) {
            return;
        }
        int amount = Math.min(t.method_10701(), slot.method_7676(stack) - stack.method_7947());
        class_1799 extract = stack.method_7972();
        extract.method_7939(amount);
        for (IGuiInventory inv : layer.inventoriesToExract()) {
            if (inv == c.inventory()) continue;
            inv.extract(extract);
            if (!extract.method_7960()) continue;
            break;
        }
        stack.method_7933(amount - extract.method_7947());
        c.changed();
    });
    public static final GuiSyncGlobal<GuiSlot, class_2491> DUPLICATE = GuiSyncHolder.GLOBAL.register("duplicate", (c, t) -> {
        class_1735 slot = c.slot;
        class_1657 player = c.getPlayer();
        if (player.method_7337()) {
            class_1799 stack = slot.method_7677().method_7972();
            stack.method_7939(stack.method_7914());
            c.itemManager().setHand(stack);
        }
    });
    public static final GuiSyncGlobal<GuiSlot, class_2481> SWAP = GuiSyncHolder.GLOBAL.register("swap", (c, t) -> {
        boolean rightClick = t.method_10698() == 1;
        class_1735 slot = c.slot;
        class_1657 player = c.getPlayer();
        class_1799 hand = c.itemManager().getHand();
        if (slot.method_7674(player) && (hand.method_7960() || slot.method_7680(hand))) {
            class_1799 pickup;
            if (hand.method_7960() && rightClick) {
                pickup = slot.method_7677().method_7971(Math.max(1, slot.method_7677().method_7947() / 2));
            } else {
                pickup = slot.method_7677().method_7972();
                slot.method_7673(hand.method_7972());
            }
            slot.method_7667(player, pickup);
            c.itemManager().setHand(pickup);
            c.changed();
        }
    });
    public static final GuiSyncGlobal<GuiLayer, class_2487> SPREAD = GuiSyncHolder.GLOBAL.register("spread", (c, t) -> {
        class_1799 hand = c.itemManager().getHand().method_7972();
        class_1657 player = c.getPlayer();
        if (hand.method_7960()) {
            return;
        }
        ArrayList<IGuiInventory> inventories = new ArrayList<IGuiInventory>();
        class_2499 names = t.method_10554("names", 8);
        for (int i = 0; i < names.size(); ++i) {
            inventories.add((IGuiInventory)c.get(names.method_10608(i)));
        }
        ArrayList<GuiSlot> slots = new ArrayList<GuiSlot>();
        int[] ids = t.method_10561("ids");
        for (int i = 0; i < ids.length; i += 2) {
            slots.add(((IGuiInventory)inventories.get(ids[i])).getSlot(ids[i + 1]));
        }
        int countPerSlot = Math.max(1, class_3532.method_15375((float)((float)hand.method_7947() / (float)slots.size())));
        boolean rightClick = t.method_10577("rightClick");
        if (rightClick) {
            countPerSlot = 1;
        }
        for (GuiSlot slot : slots) {
            if (!slot.slot.method_7680(hand)) continue;
            class_1799 stack = slot.getStack();
            int transfer = Math.min(countPerSlot, slot.slot.method_7676(hand) - slot.getStack().method_7947());
            class_1799 toTransfer = hand.method_7972();
            toTransfer.method_7939(transfer);
            if (transfer <= 0) continue;
            if (!toTransfer.method_31575(slot.slot, rightClick ? class_5536.field_27014 : class_5536.field_27013, player) && !stack.method_31576(toTransfer, slot.slot, rightClick ? class_5536.field_27014 : class_5536.field_27013, player, c.itemManager().handAccess)) {
                if (!slot.slot.method_7681()) {
                    slot.slot.method_7673(toTransfer);
                } else {
                    if (!class_1799.method_31577((class_1799)toTransfer, (class_1799)stack)) continue;
                    stack.method_7933(transfer);
                }
                hand.method_7934(transfer);
            } else {
                hand = c.itemManager().getHand();
            }
            slot.changed();
        }
        c.itemManager().setHand(hand);
    });
    private class_1799 hand = class_1799.field_8037;
    private boolean drag;
    private boolean rightClick;
    private List<GuiSlot> dragged;
    private List<Integer> stackSizes;
    private boolean handChanged;
    public class_5630 handAccess = new class_5630(){

        public class_1799 method_32327() {
            return GuiManagerItem.this.getHand();
        }

        public boolean method_32332(class_1799 hand) {
            GuiManagerItem.this.setHand(hand);
            return true;
        }
    };

    public static int freeSpace(class_1735 slot, class_1799 hand) {
        if (slot.method_7680(hand) && class_1703.method_7592((class_1735)slot, (class_1799)hand, (boolean)true)) {
            int stackSize = slot.method_7676(hand);
            if (slot.method_7681()) {
                stackSize -= slot.method_7677().method_7947();
            }
            return stackSize;
        }
        return -1;
    }

    public GuiManagerItem(GuiLayer layer) {
        super(layer);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderOverlay(class_4587 matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        class_1799 stack = this.hand;
        int count = stack.method_7947();
        if (this.drag) {
            int used = 0;
            int countPerSlot = Math.max(1, class_3532.method_15375((float)((float)this.hand.method_7947() / (float)this.stackSizes.size())));
            if (this.rightClick) {
                countPerSlot = 1;
            }
            for (int i = 0; i < this.stackSizes.size(); ++i) {
                used += Math.min(countPerSlot, this.stackSizes.get(i));
            }
            int left = this.hand.method_7947() - used;
            count = Math.max(0, left);
        }
        if (!(stack.method_7960() || this.drag && !this.rightClick && this.dragged.size() <= 1)) {
            matrix.method_22903();
            RenderSystem.disableScissor();
            matrix.method_46416((float)(mouseX - 8), (float)(mouseY - 8), 200.0f);
            GuiRenderHelper.drawItemStack(matrix, stack, 1.0f);
            GuiRenderHelper.drawItemStackDecorations(matrix, stack, count);
            matrix.method_22909();
        }
    }

    @Override
    public void tick() {
        if (this.handChanged) {
            this.handChanged = false;
            if (!this.layer.isClient()) {
                HAND.send(this.layer, this.hand.method_7953(new class_2487()));
            }
        }
        super.tick();
    }

    @Override
    public void closed() {
        if (!(this.layer.isClient() || this.hand.method_7960() || this.layer.getPlayer().method_7270(this.hand))) {
            this.layer.getPlayer().method_7328(this.hand, false);
        }
        super.closed();
    }

    @Override
    public void mouseClickedOutside(double x, double y) {
        if (!this.hand.method_7960()) {
            DROP_HAND.send(this.layer, class_2491.field_21033);
        }
    }

    @Override
    public void mouseReleased(double x, double y, int button) {
        if (this.isDragged() && this.rightClick == (button == 1)) {
            this.endDrag();
        }
    }

    public void startDrag(GuiSlot slot, boolean rightClick, int stackSize) {
        this.drag = true;
        this.dragged = new ArrayList<GuiSlot>();
        this.dragged.add(slot);
        this.rightClick = rightClick;
        this.stackSizes = new ArrayList<Integer>();
        this.stackSizes.add(stackSize);
        slot.draggedIndex = 0;
    }

    public void addToDrag(GuiSlot slot) {
        int stackSize = GuiManagerItem.freeSpace(slot.slot, this.hand);
        if (stackSize > 0) {
            slot.draggedIndex = this.dragged.size();
            this.dragged.add(slot);
            this.stackSizes.add(stackSize);
        }
    }

    public void modifyDrag(GuiSlot slot) {
        this.stackSizes.set(slot.draggedIndex, GuiManagerItem.freeSpace(slot.slot, this.hand));
    }

    public void abortDrag() {
        for (GuiSlot slot : this.dragged) {
            slot.draggedIndex = -1;
        }
        this.drag = false;
        this.rightClick = false;
        this.dragged = null;
        this.stackSizes = null;
    }

    public void endDrag() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("rightClick", this.rightClick);
        HashMap<String, Integer> inventories = new HashMap<String, Integer>();
        class_2499 names = new class_2499();
        int[] ids = new int[this.dragged.size() * 2];
        int i = 0;
        for (GuiSlot slot : this.dragged) {
            String inventory = slot.inventory().name();
            Integer inventoryId = (Integer)inventories.get(inventory);
            if (inventoryId == null) {
                inventoryId = inventories.size();
                inventories.put(inventory, inventoryId);
                names.add((Object)class_2519.method_23256((String)inventory));
            }
            ids[i] = inventoryId;
            ids[i + 1] = slot.slot.method_34266();
            i += 2;
        }
        nbt.method_10539("ids", ids);
        nbt.method_10566("names", (class_2520)names);
        SPREAD.sendAndExecute(this.layer, nbt);
        if (this.isDragged()) {
            this.abortDrag();
        }
    }

    public boolean isDragged() {
        return this.drag;
    }

    public class_1799 getHand() {
        return this.hand;
    }

    public void setHandChanged() {
        this.handChanged = true;
    }

    public void setHand(class_1799 stack) {
        if (this.isDragged()) {
            this.abortDrag();
        }
        this.hand = stack;
        this.setHandChanged();
    }

    public int additionalDragCount(int index) {
        if (index >= this.hand.method_7947()) {
            return 0;
        }
        if (this.rightClick) {
            return 1;
        }
        return Math.max(1, class_3532.method_15375((float)(this.hand.method_7947() / this.dragged.size())));
    }
}

