/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.GuiFocusControl;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;

public class GuiTextfield
extends GuiFocusControl {
    private String text = "";
    private int maxStringLength = 128;
    private int frame;
    private boolean shift;
    private int lineScrollOffset;
    private int cursorPosition;
    private int selectionEnd;
    private String suggestion;
    private Predicate<String> validator = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> textFormatter = (text, pos) -> class_5481.method_30747((String)text, (class_2583)class_2583.field_24360);
    private int cachedWidth;

    public GuiTextfield(String name) {
        super(name);
        this.setText("");
    }

    public GuiTextfield(String name, String text2) {
        super(name);
        this.setText(text2);
    }

    @Override
    public GuiTextfield setDim(int width, int height) {
        return (GuiTextfield)super.setDim(width, height);
    }

    public GuiTextfield setDim(int width) {
        return (GuiTextfield)super.setDim(width, 20);
    }

    public GuiTextfield setFloatOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                Float.parseFloat(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public GuiTextfield setNumbersIncludingNegativeOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                Integer.parseInt(x);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public GuiTextfield setNumbersOnly() {
        this.validator = x -> {
            if (x.isEmpty()) {
                return true;
            }
            try {
                return Integer.parseInt(x) >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return this;
    }

    public float parseFloat() {
        try {
            return Float.parseFloat(this.text);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public int parseInteger() {
        try {
            return Integer.parseInt(this.text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
        ++this.frame;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_4587 matrix, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        class_327 fontRenderer = GuiRenderHelper.getFont();
        int j = this.cursorPosition - this.lineScrollOffset;
        int k = this.selectionEnd - this.lineScrollOffset;
        GuiStyle style = this.getStyle();
        int color = this.enabled ? style.fontColor.toInt() : style.fontColorDisabled.toInt();
        String s = fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), (int)rect.getWidth());
        boolean flag = j >= 0 && j <= s.length();
        boolean flag1 = this.isFocused() && this.frame / 6 % 2 == 0 && flag;
        int yOffset = 0;
        int xOffset = 0;
        if (k > s.length()) {
            k = s.length();
        }
        if (!s.isEmpty()) {
            String s1 = flag ? s.substring(0, j) : s;
            xOffset = fontRenderer.method_27528(matrix, this.textFormatter.apply(s1, this.lineScrollOffset), (float)xOffset, (float)yOffset, color) + 1;
        }
        boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
        int k1 = xOffset;
        if (!flag) {
            k1 = j > 0 ? control.getWidth() : 0;
        } else if (flag2) {
            k1 = xOffset - 1;
            --xOffset;
        }
        if (!s.isEmpty() && flag && j < s.length()) {
            fontRenderer.method_27528(matrix, this.textFormatter.apply(s.substring(j), this.cursorPosition), (float)xOffset, (float)yOffset, color);
        }
        if (!flag2 && this.suggestion != null) {
            fontRenderer.method_1720(matrix, this.suggestion, (float)(k1 - 1), (float)yOffset, -8355712);
        }
        if (flag1) {
            if (flag2) {
                class_332.method_25294((class_4587)matrix, (int)k1, (int)(yOffset - 1), (int)(k1 + 1), (int)(yOffset + 1 + 9), (int)-3092272);
            } else {
                fontRenderer.method_1720(matrix, "_", (float)k1, (float)yOffset, color);
            }
        }
        if (k != j) {
            int l1 = fontRenderer.method_1727(s.substring(0, k));
            this.drawSelectionBox(control, matrix.method_23760().method_23761(), k1, yOffset - 1, l1 - 1, yOffset + 1 + 9);
        }
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionZero();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        return this.text.substring(i, j);
    }

    public void setValidator(Predicate<String> validatorIn) {
        this.validator = validatorIn;
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int j = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = class_155.method_644((String)textToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.validator.test(s1 = new StringBuilder(this.text).replace(i, j, s).toString())) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        this.raiseEvent(new GuiControlChangedEvent(this));
    }

    private void delete(int p_212950_1_) {
        if (class_437.method_25441()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
        this.onTextChanged(this.text);
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.getCursorPos(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.getCursorPos(num));
    }

    private int getCursorPos(int p_238516_1_) {
        return class_156.method_27761((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.shift) {
            this.setSelectionPos(this.cursorPosition);
        }
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = class_3532.method_15340((int)pos, (int)0, (int)this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        this.shift = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.writeText(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (keyCode) {
            case 259: {
                this.shift = false;
                this.delete(-1);
                this.shift = class_437.method_25442();
                return true;
            }
            case 258: 
            case 260: 
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                return false;
            }
            default: {
                return class_155.method_643((char)((char)keyCode));
            }
            case 261: {
                this.shift = false;
                this.delete(1);
                this.shift = class_437.method_25442();
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.isFocused();
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        if (!this.canWrite()) {
            return false;
        }
        if (class_155.method_643((char)codePoint)) {
            this.writeText(Character.toString(codePoint));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(Rect rect, double mouseX, double mouseY, int button) {
        super.mouseClicked(rect, mouseX, mouseY, button);
        if (button == 0) {
            int i = class_3532.method_15357((double)mouseX);
            class_327 fontRenderer = GuiRenderHelper.getFont();
            String s = fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), (int)rect.getWidth());
            this.shift = class_437.method_25442();
            this.setCursorPosition(fontRenderer.method_27523(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    private void drawSelectionBox(GuiChildControl control, Matrix4f matrix, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if ((double)endX > control.rect.maxX) {
            endX = (int)control.rect.maxX;
        }
        if ((double)startX > control.rect.maxX) {
            startX = (int)control.rect.maxX;
        }
        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferbuilder.method_22918(matrix, (float)startX, (float)endY, 0.0f).method_1344();
        bufferbuilder.method_22918(matrix, (float)endX, (float)endY, 0.0f).method_1344();
        bufferbuilder.method_22918(matrix, (float)endX, (float)startY, 0.0f).method_1344();
        bufferbuilder.method_22918(matrix, (float)startX, (float)startY, 0.0f).method_1344();
        tesselator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    @Override
    protected void focusChanged() {
        if (this.isFocused()) {
            this.frame = 0;
        }
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedWidth = width - this.getContentOffset() * 2;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    public void setSelectionPos(int position) {
        int textLength = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)position, (int)0, (int)textLength);
        if (this.getParent() == null || !this.hasLayer()) {
            return;
        }
        class_327 fontRenderer = GuiRenderHelper.getFont();
        if (fontRenderer != null) {
            if (this.lineScrollOffset > textLength) {
                this.lineScrollOffset = textLength;
            }
            int j = this.cachedWidth;
            String s = fontRenderer.method_27523(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= fontRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = class_3532.method_15340((int)this.lineScrollOffset, (int)0, (int)textLength);
        }
    }

    public void setSuggestion(@Nullable String p_195612_1_) {
        this.suggestion = p_195612_1_;
    }
}

