/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.parent;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;

public class GuiScrollX
extends GuiParent {
    public int maxScroll = 0;
    public SmoothValue scrolled = new SmoothValue(200L);
    public boolean dragged;
    public int scrollbarHeight = 3;
    protected int cachedWidth;

    public GuiScrollX() {
        this("");
    }

    public GuiScrollX(String name) {
        super(name, GuiFlow.STACK_X);
    }

    @Override
    public GuiScrollX setDim(int width, int height) {
        return (GuiScrollX)super.setDim(width, height);
    }

    @Override
    public GuiScrollX setDim(GuiSizeRule dim) {
        return (GuiScrollX)super.setDim(dim);
    }

    @Override
    public GuiScrollX setExpandable() {
        return (GuiScrollX)super.setExpandable();
    }

    @Override
    public double getOffsetX() {
        return -this.scrolled.current();
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED;
    }

    public void onScrolled() {
        if (this.scrolled.aimed() < 0.0) {
            this.scrolled.set(0.0);
        }
        if (this.scrolled.aimed() > (double)this.maxScroll) {
            this.scrolled.set(this.maxScroll);
        }
    }

    @Override
    public boolean mouseScrolled(Rect rect, double x, double y, double scrolled) {
        if (super.mouseScrolled(rect, x, y, scrolled)) {
            return true;
        }
        this.scrolled.set(this.scrolled.aimed() - scrolled * 10.0);
        this.onScrolled();
        return true;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (button == 0 && rect.getHeight() - y <= (double)this.scrollbarHeight && this.needsScrollbar(rect)) {
            GuiScrollX.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
            this.dragged = true;
            return true;
        }
        return super.mouseClicked(rect, x, y, button);
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        if (this.dragged) {
            GuiStyle style = this.getStyle();
            ControlFormatting formatting = this.getControlFormatting();
            int completeWidth = (int)(rect.getWidth() - (double)(style.getBorder(formatting.border) * 2));
            int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
            if (this.cachedWidth < completeWidth) {
                scrollThingWidth = completeWidth;
            }
            double percent = x / (double)(completeWidth - scrollThingWidth);
            this.scrolled.set((int)(percent * (double)this.maxScroll));
            this.onScrolled();
        }
        super.mouseMoved(rect, x, y);
    }

    @Override
    public void mouseReleased(Rect rect, double x, double y, int button) {
        super.mouseReleased(rect, x, y, button);
        this.dragged = false;
    }

    public boolean needsScrollbar(Rect rect) {
        return (double)this.cachedWidth > rect.getWidth() - (double)(this.getContentOffset() * 2);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(class_4587 matrix, GuiChildControl control, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        matrix.method_22903();
        super.renderContent(matrix, control, formatting, borderWidth, controlRect, realRect, scale, mouseX, mouseY);
        matrix.method_22909();
        float controlInvScale = (float)this.scaleFactorInv();
        matrix.method_22905(controlInvScale, controlInvScale, controlInvScale);
        realRect.scissor();
        GuiStyle style = this.getStyle();
        this.scrolled.tick();
        int completeWidth = control.getWidth() - borderWidth * 2;
        int scrollThingWidth = Math.max(10, Math.min(completeWidth, (int)((float)completeWidth / (float)this.cachedWidth * (float)completeWidth)));
        if (scrollThingWidth < completeWidth) {
            scrollThingWidth = completeWidth;
        }
        double percent = this.scrolled.current() / (double)this.maxScroll;
        style.get(ControlFormatting.ControlStyleFace.CLICKABLE, false).render(matrix, control.getWidth() - this.scrollbarHeight - borderWidth, (int)(percent * (double)(completeWidth - scrollThingWidth)) + borderWidth, this.scrollbarHeight, scrollThingWidth);
        this.maxScroll = Math.max(0, this.cachedWidth - completeWidth + formatting.padding * 2 + 1);
        float controlScale = (float)this.scaleFactor();
        matrix.method_22905(controlScale, controlScale, controlScale);
    }

    @Override
    protected int minWidth(int availableWidth) {
        return 10;
    }

    @Override
    protected int minHeight(int width, int availableHeight) {
        return 10;
    }

    @Override
    public void flowX(int width, int preferred) {
        int x = 0;
        for (GuiChildControl child : this.controls) {
            child.setWidth(child.getPreferredWidth(width), width);
            child.setX(x);
            child.flowX();
            x += child.getWidth() + this.spacing;
        }
        this.cachedWidth = x;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height - this.scrollbarHeight, preferred);
    }
}

