/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.sound;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_4224;
import net.minecraft.class_4856;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import team.creative.ambientsounds.AmbientSound;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.reflection.ReflectionHelper;

public class AmbientSoundEngine {
    private static final class_310 mc = class_310.method_1551();
    private static Field sourceField;
    private static Field streamField;
    private static Field bufferedInputStreamField;
    private List<AmbientSound.SoundStream> sounds = new ArrayList<AmbientSound.SoundStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playingCount() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            return this.sounds.size();
        }
    }

    public AmbientSoundEngine() {
        CreativeCore.loader().registerListener(this::play);
    }

    public class_1144 getManager() {
        return mc.method_1483();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            Double mute = null;
            try {
                for (AmbientSound.SoundStream sound : this.sounds) {
                    double soundMute = sound.mute();
                    if (!(soundMute > 0.0) || mute != null && !(mute < soundMute)) continue;
                    mute = soundMute;
                }
                Iterator<AmbientSound.SoundStream> iterator = this.sounds.iterator();
                while (iterator.hasNext()) {
                    boolean playing;
                    AmbientSound.SoundStream sound;
                    sound = iterator.next();
                    if (!this.getManager().method_4877((class_1113)sound)) {
                        if (!sound.hasPlayedOnce()) continue;
                        playing = false;
                    } else {
                        playing = true;
                    }
                    if (sound.hasPlayedOnce() && !playing) {
                        sound.onFinished();
                        this.getManager().method_4870((class_1113)sound);
                        iterator.remove();
                        continue;
                    }
                    if (!sound.hasPlayedOnce() && playing) {
                        sound.setPlayedOnce();
                    }
                    if (mute == null || sound.mute() >= mute) {
                        sound.generatedVoume = (float)sound.volume;
                        continue;
                    }
                    sound.generatedVoume = (float)(sound.volume * (1.0 - mute));
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AmbientSound.SoundStream sound) {
        this.getManager().method_4870((class_1113)sound);
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.remove(sound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(AmbientSound.SoundStream stream) {
        this.getManager().method_4873((class_1113)stream);
        stream.onStart();
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            for (AmbientSound.SoundStream sound : this.sounds) {
                this.stop(sound);
                sound.onFinished();
            }
        }
    }

    public void play(PlayStreamingSourceEvent event) {
        AmbientSound.SoundStream stream;
        class_1113 class_11132;
        if (sourceField == null) {
            sourceField = ReflectionHelper.findField(class_4224.class, (String)"f_83642_", (String)"source");
            streamField = ReflectionHelper.findField(class_4224.class, (String)"f_83645_", (String)"stream");
            bufferedInputStreamField = ReflectionHelper.findField(class_4856.class, (String)"f_120161_", (String)"bufferedInputStream");
        }
        if ((class_11132 = event.getSound()) instanceof AmbientSound.SoundStream && (stream = (AmbientSound.SoundStream)class_11132).loop() && stream.duration != -1) {
            try {
                int source = sourceField.getInt(event.getChannel());
                class_4856 looping = (class_4856)streamField.get(event.getChannel());
                BufferedInputStream in = (BufferedInputStream)bufferedInputStreamField.get(looping);
                int length = in.available() + AL11.alGetSourcei((int)source, (int)4134);
                int offset = (int)(Math.random() * (double)length);
                AL10.alSourcef((int)source, (int)4134, (float)offset);
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }
}

