/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env.pocket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.env.feature.AmbientBlockGroup;
import team.creative.ambientsounds.env.pocket.AirPocket;
import team.creative.ambientsounds.env.pocket.BlockDistribution;
import team.creative.creativecore.common.util.type.map.HashMapDouble;
import team.creative.creativecore.common.util.type.set.QuadBitSet;

public class AirPocketScanner
extends Thread {
    public final AmbientEngine engine;
    public final class_1937 level;
    public final class_2338 origin;
    private List<HashMap<BlockPosInspection, BlockPosInspection>> toScan = new ArrayList<HashMap<BlockPosInspection, BlockPosInspection>>();
    private final HashMapDouble<class_2680> foundCount = new HashMapDouble();
    private QuadBitSet sky = new QuadBitSet();
    private double distributionCounter;
    private int totalSize = 0;
    private int currentDistance = 0;
    private int lightValueCounter = 0;
    private int skyLightValueCounter = 0;
    private int faceCounter = 0;
    private int air;
    private Consumer<AirPocket> consumer;

    public AirPocketScanner(AmbientEngine engine, class_1937 level, class_2338 origin, Consumer<AirPocket> consumer) {
        this.origin = origin;
        this.engine = engine;
        this.level = level;
        this.consumer = consumer;
        this.start();
    }

    @Override
    public void run() {
        HashMap<BlockPosInspection, BlockPosInspection> first = new HashMap<BlockPosInspection, BlockPosInspection>();
        BlockPosInspection ins = new BlockPosInspection(this.origin);
        first.put(ins, ins);
        this.toScan.add(first);
        int steps = 0;
        while (this.currentDistance < this.toScan.size()) {
            for (BlockPosInspection pos : this.toScan.get(this.currentDistance).keySet()) {
                this.scan(this.level, this.currentDistance, pos);
                if (++steps <= AmbientSounds.CONFIG.scanStepAmount) continue;
                steps = 0;
                try {
                    AirPocketScanner.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.currentDistance;
        }
        HashMap<String, BlockDistribution> distribution = new HashMap<String, BlockDistribution>();
        for (Map.Entry<String, AmbientBlockGroup> entry : this.engine.groups.entrySet()) {
            BlockDistribution dist = new BlockDistribution();
            for (Map.Entry state : this.foundCount.entrySet()) {
                if (!entry.getValue().is((class_2680)state.getKey())) continue;
                dist.add((Double)state.getValue());
            }
            dist.calculatePercentage(this.distributionCounter);
            distribution.put(entry.getKey(), dist);
        }
        this.consumer.accept(new AirPocket(this.engine, distribution, (double)this.lightValueCounter / (double)this.faceCounter, (double)this.skyLightValueCounter / (double)this.faceCounter, (double)this.air / (double)this.engine.maxAirPocketCount));
    }

    protected HashMap<BlockPosInspection, BlockPosInspection> getOrCreate(int distance) {
        if (distance >= this.toScan.size()) {
            HashMap<BlockPosInspection, BlockPosInspection> set = new HashMap<BlockPosInspection, BlockPosInspection>();
            this.toScan.add(set);
            return set;
        }
        return this.toScan.get(distance);
    }

    protected void findState(class_2680 state, int distance) {
        double factor = this.engine.airWeightFactor(distance);
        this.distributionCounter += factor;
        this.foundCount.put((Object)state, Double.valueOf(factor));
    }

    protected void scan(class_1937 level, int distance, BlockPosInspection pos) {
        class_2680 state = level.method_8320((class_2338)pos);
        if (state.method_26215() || !state.method_26234((class_1922)level, (class_2338)pos) && !this.engine.considerSolid.is(state)) {
            if (!state.method_26215()) {
                this.findState(state, distance);
            }
            if (distance < this.engine.airPocketDistance && this.air < this.engine.maxAirPocketCount) {
                ++this.air;
            }
            ++distance;
            if (this.sky.get(pos.method_10263(), pos.method_10260()) && this.sky.get(pos.method_10263() - 1, pos.method_10260()) && this.sky.get(pos.method_10263(), pos.method_10260() - 1) && this.sky.get(pos.method_10263() + 1, pos.method_10260()) && this.sky.get(pos.method_10263(), pos.method_10260() + 1)) {
                return;
            }
            for (int i = 0; i < class_2350.values().length; ++i) {
                class_2338 newPos;
                if (this.totalSize > this.engine.airPocketCount) {
                    return;
                }
                class_2350 direction = class_2350.values()[i];
                class_2350.class_2351 axis = direction.method_10166();
                if (direction.method_10171() != class_2350.class_2352.field_11056 ? pos.method_30558(axis) - 1 >= this.origin.method_30558(axis) : pos.method_30558(axis) + 1 <= this.origin.method_30558(axis)) continue;
                HashMap<BlockPosInspection, BlockPosInspection> map = this.getOrCreate(distance);
                BlockPosInspection ins = map.get(newPos = pos.method_10093(direction));
                if (ins != null) {
                    ins.add(direction.method_10153());
                } else {
                    ins = new BlockPosInspection(newPos, direction.method_10153());
                    map.put(ins, ins);
                }
                ++this.totalSize;
            }
        } else {
            if (!this.sky.get(pos.method_10263(), pos.method_10260()) && pos.isUp() && level.method_8311(pos.method_10084())) {
                this.sky.set(pos.method_10263(), pos.method_10260());
                if (distance < this.engine.airPocketDistance) {
                    this.air = this.engine.maxAirPocketCount;
                }
            }
            for (class_2350 direction : pos) {
                class_2338 other = pos.method_10093(direction);
                this.lightValueCounter += level.method_8317(other);
                this.skyLightValueCounter += level.method_8314(class_1944.field_9284, other);
                ++this.faceCounter;
            }
            this.findState(state, distance);
        }
    }

    public static class BlockPosInspection
    extends class_2338
    implements Iterable<class_2350> {
        protected boolean east;
        protected boolean west;
        protected boolean up;
        protected boolean down;
        protected boolean south;
        protected boolean north;

        public BlockPosInspection(class_2338 pos) {
            super((class_2382)pos);
            this.north = true;
            this.south = true;
            this.down = true;
            this.up = true;
            this.west = true;
            this.east = true;
        }

        public BlockPosInspection(class_2338 pos, class_2350 direction) {
            super((class_2382)pos);
            this.add(direction);
        }

        public void add(class_2350 direction) {
            switch (direction) {
                case field_11033: {
                    this.down = true;
                    break;
                }
                case field_11034: {
                    this.east = true;
                    break;
                }
                case field_11043: {
                    this.north = true;
                    break;
                }
                case field_11035: {
                    this.south = true;
                    break;
                }
                case field_11036: {
                    this.up = true;
                    break;
                }
                case field_11039: {
                    this.west = true;
                    break;
                }
            }
        }

        public boolean isUp() {
            return this.up;
        }

        public boolean is(class_2350 direction) {
            switch (direction) {
                case field_11033: {
                    return this.down;
                }
                case field_11034: {
                    return this.east;
                }
                case field_11043: {
                    return this.north;
                }
                case field_11035: {
                    return this.south;
                }
                case field_11036: {
                    return this.up;
                }
                case field_11039: {
                    return this.west;
                }
            }
            return false;
        }

        @Override
        public Iterator<class_2350> iterator() {
            return new Iterator<class_2350>(){
                int next = this.findNext(-1);

                int findNext(int next) {
                    while (next < 6) {
                        switch (++next) {
                            case 0: {
                                if (!east) break;
                                return next;
                            }
                            case 1: {
                                if (!west) break;
                                return next;
                            }
                            case 2: {
                                if (!up) break;
                                return next;
                            }
                            case 3: {
                                if (!down) break;
                                return next;
                            }
                            case 4: {
                                if (!south) break;
                                return next;
                            }
                            case 5: {
                                if (!north) break;
                                return next;
                            }
                        }
                    }
                    return next;
                }

                @Override
                public boolean hasNext() {
                    return this.next >= 0 && this.next < 6;
                }

                @Override
                public class_2350 next() {
                    class_2350 result = switch (this.next) {
                        case 0 -> class_2350.field_11034;
                        case 1 -> class_2350.field_11039;
                        case 2 -> class_2350.field_11036;
                        case 3 -> class_2350.field_11033;
                        case 4 -> class_2350.field_11035;
                        case 5 -> class_2350.field_11043;
                        default -> null;
                    };
                    this.next = this.findNext(this.next);
                    return result;
                }
            };
        }
    }
}

