/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchatlog;

import fi.dy.masa.malilib.interfaces.IInitializationHandler;
import fi.dy.masa.malilib.util.FileUtils;
import io.github.darkkronicle.advancedchatcore.ModuleHandler;
import io.github.darkkronicle.advancedchatlog.ChatLogData;
import io.github.darkkronicle.advancedchatlog.ChatLogInitHandler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.OnStartupTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class AdvancedChatLog
implements ClientModInitializer {
    public static final String MOD_ID = "advancedchatlog";
    public static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger((String)"advancedchatlog");
    private static Logger CHAT_LOGGER;
    private static final SimpleDateFormat DATE_TIME;

    public void onInitializeClient() {
        ModuleHandler.getInstance().registerInitHandler(MOD_ID, 1, (IInitializationHandler)new ChatLogInitHandler());
        AdvancedChatLog.setupLogger();
    }

    private static void setupLogger() {
        File dir = FileUtils.getMinecraftDirectory().toPath().resolve("chatlogs").toFile();
        dir.mkdirs();
        CHAT_LOGGER = LoggerFactory.getLogger((String)"chat");
        LogManager.getLogger((String)"chat");
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        RollingRandomAccessFileAppender rolling = ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName("chatlogFile")).withFileName("chatlogs/latest.log").withBufferSize(100000)).withPolicy((TriggeringPolicy)TimeBasedTriggeringPolicy.newBuilder().withInterval(1).build()).withPolicy((TriggeringPolicy)OnStartupTriggeringPolicy.createPolicy((long)1000L)).withAppend(true).withImmediateFlush(true)).withFilePattern("chatlogs/%d{yyyy-MM-dd}-%i.log.gz").build();
        org.apache.logging.log4j.core.Logger logger = loggerContext.getLogger("chat");
        rolling.start();
        logger.addAppender((Appender)rolling);
        loggerContext.updateLoggers();
    }

    public static void logChatMessage(class_2561 text) {
        if (ChatLogData.isLoading()) {
            return;
        }
        Object message = text.getString();
        message = "[" + DATE_TIME.format(new Date()) + "] " + (String)message;
        CHAT_LOGGER.info((String)message);
    }

    static {
        DATE_TIME = new SimpleDateFormat("HH:mm:ss");
    }
}

