/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class FileUtil {
    public static List<Path> getFilesWithExtension(Path directory, String extension) throws IOException {
        List<Path> paths;
        if (!directory.toFile().isDirectory()) {
            throw new IllegalArgumentException("Directory has to be directory!");
        }
        try (Stream<Path> walk = Files.walk(directory, new FileVisitOption[0]);){
            paths = walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).filter(p -> p.toString().endsWith(extension)).collect(Collectors.toList());
        }
        return paths;
    }

    public static Optional<List<Path>> getFilesWithExtensionCaught(Path directory, String extension) {
        try {
            return Optional.of(FileUtil.getFilesWithExtension(directory, extension));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

