/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.tabs;

import com.google.gson.JsonArray;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.util.FileUtils;
import io.github.darkkronicle.Konstruct.NodeException;
import io.github.darkkronicle.Konstruct.functions.Function;
import io.github.darkkronicle.Konstruct.nodes.Node;
import io.github.darkkronicle.Konstruct.parser.IntRange;
import io.github.darkkronicle.Konstruct.parser.NodeProcessor;
import io.github.darkkronicle.Konstruct.parser.ParseContext;
import io.github.darkkronicle.Konstruct.parser.Result;
import io.github.darkkronicle.Konstruct.type.KonstructObject;
import io.github.darkkronicle.Konstruct.type.NullObject;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.konstruct.AdvancedChatKonstruct;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.HudChatMessage;
import io.github.darkkronicle.advancedchathud.HudChatMessageHolder;
import io.github.darkkronicle.advancedchathud.config.ChatTab;
import io.github.darkkronicle.advancedchathud.config.HudConfigStorage;
import io.github.darkkronicle.advancedchathud.gui.WindowManager;
import io.github.darkkronicle.advancedchathud.tabs.AbstractChatTab;
import io.github.darkkronicle.advancedchathud.tabs.ChatTabObject;
import io.github.darkkronicle.advancedchathud.tabs.CustomChatTab;
import io.github.darkkronicle.advancedchathud.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2561;
import org.apache.logging.log4j.Level;

public class MainChatTab
extends AbstractChatTab {
    private ArrayList<AbstractChatTab> allChatTabs = new ArrayList();
    private ArrayList<CustomChatTab> customChatTabs = new ArrayList();
    public static boolean LOAD_ALL_JSON = false;
    private NodeProcessor processor = null;

    public MainChatTab() {
        super("Main", ((ConfigString)HudConfigStorage.MAIN_TAB.getAbbreviation().config).getStringValue(), ((ConfigColor)HudConfigStorage.MAIN_TAB.getMainColor().config).get(), ((ConfigColor)HudConfigStorage.MAIN_TAB.getBorderColor().config).get(), ((ConfigColor)HudConfigStorage.MAIN_TAB.getInnerColor().config).get(), ((ConfigBoolean)HudConfigStorage.MAIN_TAB.getShowUnread().config).getBooleanValue(), HudConfigStorage.MAIN_TAB.getUuid());
        this.setUpTabs();
    }

    public void refreshOptions() {
        this.abbreviation = ((ConfigString)HudConfigStorage.MAIN_TAB.getAbbreviation().config).getStringValue();
        this.mainColor = ((ConfigColor)HudConfigStorage.MAIN_TAB.getMainColor().config).get();
        this.innerColor = ((ConfigColor)HudConfigStorage.MAIN_TAB.getInnerColor().config).get();
        this.borderColor = ((ConfigColor)HudConfigStorage.MAIN_TAB.getBorderColor().config).get();
        this.showUnread = ((ConfigBoolean)HudConfigStorage.MAIN_TAB.getShowUnread().config).getBooleanValue();
        this.uuid = HudConfigStorage.MAIN_TAB.getUuid();
    }

    public CustomChatTab getCustom(String name) {
        for (CustomChatTab tab : this.customChatTabs) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    @Override
    public boolean shouldAdd(class_2561 text) {
        return true;
    }

    public void setUpTabs() {
        JsonArray windows = null;
        if (LOAD_ALL_JSON) {
            windows = WindowManager.getInstance().saveJson();
        }
        this.customChatTabs = new ArrayList();
        this.allChatTabs = new ArrayList();
        this.allChatTabs.add(this);
        for (ChatTab tab : HudConfigStorage.TABS) {
            CustomChatTab customTab = new CustomChatTab(tab);
            this.customChatTabs.add(customTab);
        }
        this.customChatTabs.sort((customTab1, customTab2) -> {
            Comparator<CustomChatTab> comparator = Comparator.comparingInt(tab -> ((ConfigInteger)tab.getTab().getOrder().config).getIntegerValue());
            int num = comparator.compare((CustomChatTab)customTab1, (CustomChatTab)customTab2);
            if (num != 0) {
                return num;
            }
            return ((ConfigString)customTab1.getTab().getName().config).getStringValue().compareTo(((ConfigString)customTab2.getTab().getName().config).getStringValue());
        });
        this.allChatTabs.addAll(this.customChatTabs);
        Path konstructDir = FileUtils.getConfigDirectory().toPath().resolve("advancedchat").resolve("konstructTabs");
        konstructDir.toFile().mkdirs();
        this.processor = AdvancedChatKonstruct.getInstance().copy();
        this.processor.addFunction("getTab", new Function(){

            public Result parse(ParseContext context, List<Node> input) {
                CustomChatTab tab = MainChatTab.this.getCustom(Function.parseArgument((ParseContext)context, input, (int)0).getContent().getString());
                if (tab == null) {
                    return Result.success((KonstructObject)new NullObject());
                }
                return Result.success((KonstructObject)new ChatTabObject(tab));
            }

            public IntRange getArgumentCount() {
                return IntRange.of((int)1);
            }
        });
        Optional<List<Path>> files = FileUtil.getFilesWithExtensionCaught(konstructDir, ".knst");
        if (files.isPresent() && files.get().size() != 0) {
            this.loadKonstruct(files.get());
        }
        for (HudChatMessage message : HudChatMessageHolder.getInstance().getMessages()) {
            ArrayList<AbstractChatTab> tabs = new ArrayList<AbstractChatTab>();
            for (AbstractChatTab t : this.allChatTabs) {
                if (!t.shouldAdd(message.getMessage().getOriginalText())) continue;
                tabs.add(t);
            }
            message.setTabs(tabs);
        }
        this.refreshOptions();
        if (windows != null) {
            WindowManager.getInstance().loadFromJson(windows);
        }
    }

    public void loadKonstruct(List<Path> paths) {
        for (Path path : paths) {
            try {
                this.loadKonstruct(path);
            }
            catch (IOException e) {
                AdvancedChatHud.LOGGER.log(Level.ERROR, "Error reading " + path + ".", (Throwable)e);
            }
            catch (NodeException e) {
                AdvancedChatHud.LOGGER.log(Level.ERROR, "Error setting up konstruct script " + path, (Throwable)e);
            }
        }
    }

    private void loadKonstruct(Path path) throws IOException, NodeException {
        String contents = String.join((CharSequence)"\n", Files.readAllLines(path)).replaceAll("\r", "");
        Node node = AdvancedChatKonstruct.getInstance().getNode(contents);
        this.processor.parse(node);
    }

    public AbstractChatTab fromUUID(UUID uuid) {
        for (AbstractChatTab tab : this.allChatTabs) {
            if (!tab.getUuid().equals(uuid)) continue;
            return tab;
        }
        return null;
    }

    public ArrayList<AbstractChatTab> getAllChatTabs() {
        return this.allChatTabs;
    }

    public ArrayList<CustomChatTab> getCustomChatTabs() {
        return this.customChatTabs;
    }

    public NodeProcessor getProcessor() {
        return this.processor;
    }
}

