/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.tabs;

import io.github.darkkronicle.Konstruct.NodeException;
import io.github.darkkronicle.Konstruct.functions.Function;
import io.github.darkkronicle.Konstruct.functions.ObjectFunction;
import io.github.darkkronicle.Konstruct.nodes.Node;
import io.github.darkkronicle.Konstruct.parser.IntRange;
import io.github.darkkronicle.Konstruct.parser.ParseContext;
import io.github.darkkronicle.Konstruct.parser.Result;
import io.github.darkkronicle.Konstruct.type.IntegerObject;
import io.github.darkkronicle.Konstruct.type.KonstructObject;
import io.github.darkkronicle.Konstruct.type.NullObject;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchathud.tabs.CustomChatTab;
import java.util.List;
import java.util.Optional;

public class ChatTabObject
extends KonstructObject<ChatTabObject> {
    private static final List<ObjectFunction<ChatTabObject>> FUNCTIONS = List.of(new ColorFunction(){

        @Override
        public void setColor(ChatTabObject tabObj, Color color) {
            tabObj.tab.setMainColor(color);
        }

        public String getName() {
            return "setMainColor";
        }
    }, new ColorFunction(){

        @Override
        public void setColor(ChatTabObject tabObj, Color color) {
            tabObj.tab.setBorderColor(color);
        }

        public String getName() {
            return "setBorderColor";
        }
    }, new ColorFunction(){

        @Override
        public void setColor(ChatTabObject tabObj, Color color) {
            tabObj.tab.setInnerColor(color);
        }

        public String getName() {
            return "setInnerColor";
        }
    }, new ObjectFunction<ChatTabObject>(){

        public Result parse(ParseContext context, ChatTabObject self, List<Node> input) {
            Result s1 = Function.parseArgument((ParseContext)context, input, (int)0);
            self.tab.setAbbreviation(s1.getContent().getString());
            return Result.success((KonstructObject)null);
        }

        public String getName() {
            return "setAbbreviation";
        }

        public IntRange getArgumentCount() {
            return IntRange.of((int)1);
        }
    }, new ObjectFunction<ChatTabObject>(){

        public Result parse(ParseContext context, ChatTabObject self, List<Node> input) {
            Result s1 = Function.parseArgument((ParseContext)context, input, (int)0);
            self.tab.setForward(s1.getContent().getBoolean());
            return Result.success((KonstructObject)null);
        }

        public String getName() {
            return "setForward";
        }

        public IntRange getArgumentCount() {
            return IntRange.of((int)1);
        }
    }, new ObjectFunction<ChatTabObject>(){

        public Result parse(ParseContext context, ChatTabObject self, List<Node> input) {
            Result s1 = Function.parseArgument((ParseContext)context, input, (int)0);
            Optional function = context.getFunction(s1.getContent().getString());
            if (function.isEmpty()) {
                throw new NodeException("Function " + s1.getContent().getString() + " does not exist!");
            }
            if (!((Function)function.get()).getArgumentCount().equals((Object)IntRange.of((int)2))) {
                throw new NodeException("Function " + function.get() + " has to have 2 arguments!");
            }
            self.tab.setFunction((Function)function.get());
            return Result.success((KonstructObject)new NullObject());
        }

        public String getName() {
            return "setShouldAdd";
        }

        public IntRange getArgumentCount() {
            return IntRange.of((int)1);
        }
    });
    private final CustomChatTab tab;

    public ChatTabObject(CustomChatTab tab) {
        super(FUNCTIONS);
        this.tab = tab;
    }

    public String getString() {
        return "chattab-" + this.tab.toString();
    }

    public String getTypeName() {
        return "chattab";
    }

    public CustomChatTab getTab() {
        return this.tab;
    }

    private static abstract class ColorFunction
    implements ObjectFunction<ChatTabObject> {
        private ColorFunction() {
        }

        public Result parse(ParseContext context, ChatTabObject self, List<Node> input) {
            Result r1 = Function.parseArgument((ParseContext)context, input, (int)0);
            IntegerObject c1 = new IntegerObject(IntegerObject.fromObject((KonstructObject)r1.getContent()).orElse(0).intValue());
            Result r2 = Function.parseArgument((ParseContext)context, input, (int)1);
            IntegerObject c2 = new IntegerObject(IntegerObject.fromObject((KonstructObject)r2.getContent()).orElse(0).intValue());
            Result r3 = Function.parseArgument((ParseContext)context, input, (int)2);
            IntegerObject c3 = new IntegerObject(IntegerObject.fromObject((KonstructObject)r3.getContent()).orElse(0).intValue());
            Result r4 = Function.parseArgument((ParseContext)context, input, (int)3);
            IntegerObject c4 = new IntegerObject(IntegerObject.fromObject((KonstructObject)r4.getContent()).orElse(0).intValue());
            this.setColor(self, new Color(c1.getValue(), c2.getValue(), c3.getValue(), c4.getValue()));
            return Result.success((KonstructObject)new NullObject());
        }

        public IntRange getArgumentCount() {
            return IntRange.of((int)4);
        }

        public abstract void setColor(ChatTabObject var1, Color var2);
    }
}

