/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import io.github.darkkronicle.advancedchatcore.chat.AdvancedChatScreen;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.util.SyncTaskQueue;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.HudChatMessage;
import io.github.darkkronicle.advancedchathud.ResolutionEventHandler;
import io.github.darkkronicle.advancedchathud.config.HudConfigStorage;
import io.github.darkkronicle.advancedchathud.config.gui.ChatWindowEditor;
import io.github.darkkronicle.advancedchathud.gui.ChatWindow;
import io.github.darkkronicle.advancedchathud.itf.IChatHud;
import io.github.darkkronicle.advancedchathud.tabs.AbstractChatTab;
import io.github.darkkronicle.advancedchathud.tabs.CustomChatTab;
import io.github.darkkronicle.advancedchathud.tabs.MainChatTab;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class WindowManager
implements IRenderer,
ResolutionEventHandler {
    private static final WindowManager INSTANCE = new WindowManager();
    private final class_310 client;
    private final List<ChatWindow> windows = new ArrayList<ChatWindow>(8);
    private int dragX = 0;
    private int dragY = 0;
    private ChatWindow drag = null;
    private boolean resize = false;

    public static WindowManager getInstance() {
        return INSTANCE;
    }

    private WindowManager() {
        this.client = class_310.method_1551();
    }

    public void reset() {
        this.windows.clear();
    }

    private void addWindow(ChatWindow window) {
        this.windows.removeIf(w -> w == window);
        this.windows.add(window);
    }

    public void loadFromJson(JsonArray array) {
        this.reset();
        if (!((ConfigBoolean)HudConfigStorage.General.VANILLA_HUD.config).getBooleanValue()) {
            if (array == null || array.size() == 0) {
                ChatWindow base = new ChatWindow(AdvancedChatHud.MAIN_CHAT_TAB);
                base.setSelected(true);
                this.addWindow(base);
                return;
            }
        } else if (array == null || array.size() == 0) {
            return;
        }
        ChatWindow.ChatWindowSerializer serializer = new ChatWindow.ChatWindowSerializer();
        for (JsonElement e : array) {
            ChatWindow w;
            block8: {
                if (!e.isJsonObject()) continue;
                try {
                    w = serializer.load(e.getAsJsonObject());
                    if (w == null) {
                    }
                    break block8;
                }
                catch (Exception err) {
                    AdvancedChatHud.LOGGER.error("Error while loading in ChatWindow ", (Throwable)err);
                }
                continue;
            }
            this.addWindow(w);
        }
    }

    public JsonArray saveJson() {
        JsonArray array = new JsonArray();
        ChatWindow.ChatWindowSerializer serializer = new ChatWindow.ChatWindowSerializer();
        for (ChatWindow w : this.windows) {
            array.add((JsonElement)serializer.save(w));
        }
        return array;
    }

    public void onRenderGameOverlayPost(class_4587 matrixStack) {
        boolean isFocused = this.isChatFocused();
        int ticks = this.client.field_1705.method_1738();
        if (!((ConfigBoolean)HudConfigStorage.General.RENDER_IN_OTHER_GUI.config).getBooleanValue() && !isFocused && this.client.field_1755 != null) {
            return;
        }
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            this.windows.get(i).render(matrixStack, ticks, isFocused);
        }
    }

    public void resetScroll() {
        for (ChatWindow w : this.windows) {
            w.resetScroll();
        }
    }

    public boolean scroll(double amount, double mouseX, double mouseY) {
        for (ChatWindow w : this.windows) {
            if (!w.isMouseOver(mouseX, mouseY)) continue;
            w.scroll(amount);
            return true;
        }
        for (ChatWindow w : this.windows) {
            if (!w.isSelected()) continue;
            w.scroll(amount);
            return true;
        }
        return false;
    }

    public class_2583 getText(double mouseX, double mouseY) {
        for (ChatWindow w : this.windows) {
            if (!w.isMouseOver(mouseX, mouseY)) continue;
            return w.getText(mouseX, mouseY);
        }
        return null;
    }

    public ChatMessage getMessage(double mouseX, double mouseY) {
        for (ChatWindow w : this.windows) {
            if (!w.isMouseOver(mouseX, mouseY)) continue;
            return w.getMessage(mouseX, mouseY);
        }
        return null;
    }

    public boolean isChatFocused() {
        return this.client.field_1755 instanceof AdvancedChatScreen;
    }

    public ChatWindow getSelected() {
        for (ChatWindow w : this.windows) {
            if (!w.isSelected()) continue;
            return w;
        }
        return null;
    }

    public void unSelect() {
        for (ChatWindow w : this.windows) {
            w.setSelected(false);
        }
    }

    public void setSelected(ChatWindow window) {
        ChatWindow w22;
        for (ChatWindow w22 : this.windows) {
            w22.setSelected(window.equals(w22));
        }
        this.windows.removeIf(w -> w == window);
        this.windows.add(0, window);
        if (!((ConfigBoolean)HudConfigStorage.General.CHANGE_START_MESSAGE.config).getBooleanValue() || !((w22 = this.client.field_1755) instanceof AdvancedChatScreen)) {
            return;
        }
        AdvancedChatScreen screen = (AdvancedChatScreen)w22;
        if (window.getTab() instanceof MainChatTab) {
            for (ChatWindow w3 : this.windows) {
                AbstractChatTab abstractChatTab = w3.getTab();
                if (!(abstractChatTab instanceof CustomChatTab)) continue;
                CustomChatTab tab2 = (CustomChatTab)abstractChatTab;
                if (!screen.getChatField().method_1882().startsWith(tab2.getStartingMessage()) || tab2.getStartingMessage().length() <= 0) continue;
                screen.getChatField().method_1852(screen.getChatField().method_1882().substring(tab2.getStartingMessage().length()));
                break;
            }
        } else {
            AbstractChatTab abstractChatTab = window.getTab();
            if (abstractChatTab instanceof CustomChatTab) {
                CustomChatTab tab = (CustomChatTab)abstractChatTab;
                boolean replaced = false;
                for (ChatWindow w4 : this.windows) {
                    AbstractChatTab abstractChatTab2 = w4.getTab();
                    if (!(abstractChatTab2 instanceof CustomChatTab)) continue;
                    CustomChatTab tab2 = (CustomChatTab)abstractChatTab2;
                    if (!screen.getChatField().method_1882().startsWith(tab2.getStartingMessage()) || tab2.getStartingMessage().length() <= 0) continue;
                    screen.getChatField().method_1852(tab.getStartingMessage() + screen.getChatField().method_1882().substring(tab2.getStartingMessage().length()));
                    replaced = true;
                    break;
                }
                if (!replaced) {
                    screen.getChatField().method_1852(tab.getStartingMessage() + screen.getChatField().method_1882());
                }
            }
        }
    }

    public boolean mouseClicked(class_437 screen, double mouseX, double mouseY, int button) {
        ChatWindow over = null;
        for (ChatWindow w : this.windows) {
            if (!w.isMouseOver(mouseX, mouseY)) continue;
            over = w;
            break;
        }
        if (over == null) {
            if (((ConfigBoolean)HudConfigStorage.General.VANILLA_HUD.config).getBooleanValue() && this.overVanillaHud(mouseX, mouseY)) {
                this.unSelect();
            }
            return false;
        }
        if (button == 0) {
            this.setSelected(over);
            if (over.isMouseOverDragBar(mouseX, mouseY)) {
                this.drag = over;
                this.dragX = (int)mouseX - over.getConvertedX();
                this.dragY = (int)mouseY - over.getConvertedY();
                this.resize = false;
            } else if (over.isMouseOverResize(mouseX, mouseY)) {
                this.drag = over;
                this.dragX = (int)mouseX - over.getConvertedWidth();
                this.dragY = (int)mouseY + over.getConvertedHeight();
                this.resize = true;
            }
            class_2583 style = over.getText(mouseX, mouseY);
            if (style != null && screen.method_25430(style)) {
                return true;
            }
            if (over.onMouseClicked(mouseX, mouseY, button)) {
                return true;
            }
        }
        return true;
    }

    private boolean overVanillaHud(double mouseX, double mouseY) {
        return IChatHud.getInstance().isOver(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.drag != null && !this.resize) {
            int x = Math.max((int)mouseX - this.dragX, 0);
            int y = Math.max((int)mouseY - this.dragY, this.drag.getActualHeight());
            x = Math.min(x, this.client.method_22683().method_4486() - this.drag.getConvertedWidth());
            y = Math.min(y, this.client.method_22683().method_4502());
            this.drag.setPosition(x, y);
            return true;
        }
        if (this.drag != null) {
            int width = Math.max((int)mouseX - this.dragX, 80);
            int height = Math.max(this.dragY - (int)mouseY, 40);
            this.drag.setDimensions(width, height);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.drag != null) {
            this.drag = null;
            return true;
        }
        return false;
    }

    public void onTabButton(AbstractChatTab tab) {
        for (ChatWindow w : this.windows) {
            if (!w.isSelected()) continue;
            w.setTab(tab);
            return;
        }
        IChatHud.getInstance().setTab(tab);
    }

    public void onTabAddButton(AbstractChatTab tab) {
        ChatWindow window = new ChatWindow(tab);
        ChatWindow sel = this.getSelected();
        if (sel == null) {
            sel = window;
        }
        window.setPosition(sel.getConvertedX() + 15, sel.getConvertedY() + 15);
        this.setSelected(window);
    }

    public void deleteWindow(ChatWindow chatWindow) {
        this.windows.remove(chatWindow);
        if (!this.windows.isEmpty()) {
            for (ChatWindow w : this.windows) {
                w.setSelected(false);
            }
            this.windows.get(0).setSelected(true);
        }
    }

    public void onStackedMessage(HudChatMessage message) {
        for (ChatWindow w : this.windows) {
            w.stackMessage(message);
        }
    }

    public void onNewMessage(HudChatMessage message) {
        IChatHud.getInstance().addMessage(message);
        for (ChatWindow w : this.windows) {
            w.addMessage(message);
        }
    }

    public void clear() {
        IChatHud.getInstance().method_1808(false);
        for (ChatWindow w : this.windows) {
            w.clearLines();
        }
    }

    @Override
    public void onResolutionChange() {
        SyncTaskQueue.getInstance().add(2, () -> {
            for (ChatWindow w : this.windows) {
                w.onResolutionChange();
            }
        });
    }

    public void onRemoveMessage(ChatMessage remove) {
        IChatHud.getInstance().removeMessage(remove);
        for (ChatWindow w : this.windows) {
            w.removeMessage(remove);
        }
    }

    public void duplicateTab(ChatWindow hovered, int x, int y) {
        ChatWindow window = new ChatWindow(IChatHud.getInstance().getTab());
        window.setRelativeDimensions(hovered.getWidthPercent(), hovered.getHeightPercent());
        window.setVisibility(hovered.getVisibility());
        window.setPosition(x, y);
        this.setSelected(window);
    }

    public ChatWindow getHovered(int x, int y) {
        int windowHeight = this.client.method_22683().method_4502();
        for (ChatWindow w : this.windows) {
            int wX = w.getConvertedX();
            int wY = w.getConvertedY();
            if (x < wX || x > wX + w.getConvertedWidth() || y > wY || y < wY - w.getConvertedHeight()) continue;
            return w;
        }
        return null;
    }

    public void configureTab(AdvancedChatScreen screen, ChatWindow window) {
        GuiBase.openGui((class_437)new ChatWindowEditor((class_437)screen, window));
    }
}

