/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.gui;

import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.gui.CleanButton;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchatcore.util.TextUtil;
import io.github.darkkronicle.advancedchathud.config.HudConfigStorage;
import io.github.darkkronicle.advancedchathud.gui.ChatWindow;
import io.github.darkkronicle.advancedchathud.gui.WindowManager;
import io.github.darkkronicle.advancedchathud.itf.IChatHud;
import io.github.darkkronicle.advancedchathud.tabs.AbstractChatTab;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_6880;

public class TabButton
extends CleanButton {
    private final AbstractChatTab tab;
    private static final int PADDING = 3;
    private static final int UNREAD_WIDTH = 9;
    private static final int WHITE = -1;
    private static final int GRAY = -5592406;
    private static final int RED = -43691;

    private TabButton(AbstractChatTab tab, int x, int y, int width, int height) {
        super(x, y, width, height, tab.getMainColor(), tab.getAbbreviation());
        this.tab = tab;
    }

    public void render(int mouseX, int mouseY, boolean unused, class_4587 matrixStack) {
        int relMX = mouseX - this.x;
        int relMY = mouseY - this.y;
        this.hovered = relMX >= 0 && relMX <= this.width && relMY >= 0 && relMY <= this.height;
        Color color = this.baseColor;
        if (this.hovered) {
            color = Colors.getInstance().getColorOrWhite("hover").withAlpha(color.alpha());
        }
        boolean selected = false;
        if (((ConfigBoolean)HudConfigStorage.General.VANILLA_HUD.config).getBooleanValue()) {
            selected = IChatHud.getInstance().getTab().equals(this.tab);
        } else {
            ChatWindow window = WindowManager.getInstance().getSelected();
            if (window != null) {
                selected = window.getTab().equals(this.tab);
            }
        }
        if (!selected) {
            color = new Color(color.red() / 2, color.green() / 2, color.blue() / 2, 100);
        }
        RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)color.color());
        this.drawStringWithShadow(this.x + 3, this.y + 3, selected ? -1 : -5592406, this.displayString, matrixStack);
        if (this.tab.isShowUnread() && this.tab.getUnread() > 0) {
            String unread = TextUtil.toSuperscript((int)Math.min(this.tab.getUnread(), 99));
            this.drawCenteredString(this.x + this.width - 6 - 1, this.y + 3, -43691, unread, matrixStack);
        }
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        this.mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        WindowManager.getInstance().onTabButton(this.tab);
        return true;
    }

    public static TabButton fromTab(AbstractChatTab tab, int x, int y) {
        int width = StringUtils.getStringWidth((String)tab.getAbbreviation()) + 6;
        if (tab.isShowUnread()) {
            width += 9;
        }
        return new TabButton(tab, x, y, width, 14);
    }
}

