/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.gui;

import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.chat.AdvancedChatScreen;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.gui.ContextMenu;
import io.github.darkkronicle.advancedchatcore.gui.IconButton;
import io.github.darkkronicle.advancedchatcore.interfaces.AdvancedChatScreenSection;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.RowList;
import io.github.darkkronicle.advancedchatcore.util.TextBuilder;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.HudChatMessageHolder;
import io.github.darkkronicle.advancedchathud.config.HudConfigStorage;
import io.github.darkkronicle.advancedchathud.gui.ChatWindow;
import io.github.darkkronicle.advancedchathud.gui.TabButton;
import io.github.darkkronicle.advancedchathud.gui.WindowManager;
import io.github.darkkronicle.advancedchathud.itf.IChatHud;
import io.github.darkkronicle.advancedchathud.tabs.AbstractChatTab;
import io.github.darkkronicle.advancedchathud.tabs.CustomChatTab;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Level;

@Environment(value=EnvType.CLIENT)
public class HudSection
extends AdvancedChatScreenSection {
    private static final class_2960 ADD_ICON = new class_2960("advancedchathud", "textures/gui/chatwindow/add_window.png");
    private static final class_2960 RESET_ICON = new class_2960("advancedchathud", "textures/gui/chatwindow/reset_windows.png");
    private ContextMenu menu = null;
    private ChatMessage message = null;

    public HudSection(AdvancedChatScreen screen) {
        super(screen);
    }

    private Color getColor() {
        ChatWindow sel = WindowManager.getInstance().getSelected();
        Color baseColor = sel == null ? ((ConfigColor)HudConfigStorage.MAIN_TAB.getInnerColor().config).get() : sel.getTab().getInnerColor();
        return baseColor;
    }

    public void initGui() {
        boolean left = !((ConfigBoolean)HudConfigStorage.General.TAB_BUTTONS_ON_RIGHT.config).getBooleanValue();
        ArrayList<AbstractChatTab> tabs = new ArrayList<AbstractChatTab>(AdvancedChatHud.MAIN_CHAT_TAB.getAllChatTabs());
        if (!left) {
            Collections.reverse(tabs);
        }
        RowList rows = left ? this.getScreen().getLeftSideButtons() : this.getScreen().getRightSideButtons();
        rows.createSection("tabs", 0);
        for (AbstractChatTab tab : tabs) {
            rows.add("tabs", (Object)TabButton.fromTab(tab, 0, 0));
        }
        IconButton window = new IconButton(0, 0, 14, 32, ADD_ICON, button -> WindowManager.getInstance().onTabAddButton(IChatHud.getInstance().getTab()));
        IconButton reset = new IconButton(0, 0, 14, 32, RESET_ICON, button -> WindowManager.getInstance().reset());
        if (left) {
            rows.add("tabs", (Object)window);
            rows.add("tabs", (Object)reset);
        } else {
            rows.add("tabs", (Object)window, 0);
            rows.add("tabs", (Object)reset, 0);
        }
        if (this.getScreen().getChatField().method_1882().isEmpty()) {
            ChatWindow chatWindow = WindowManager.getInstance().getSelected();
            if (chatWindow == null) {
                return;
            }
            AbstractChatTab tab = chatWindow.getTab();
            if (tab instanceof CustomChatTab) {
                CustomChatTab custom = (CustomChatTab)tab;
                this.getScreen().getChatField().method_1852(custom.getStartingMessage());
                this.getScreen().getChatField().method_1883(custom.getStartingMessage().length());
            }
        }
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.menu != null) {
            this.menu.render(mouseX, mouseY, true, matrixStack);
        }
    }

    public void createContextMenu(int mouseX, int mouseY) {
        LinkedHashMap<class_5250, ContextMenu.ContextConsumer> actions = new LinkedHashMap<class_5250, ContextMenu.ContextConsumer>();
        this.message = WindowManager.getInstance().getMessage(mouseX, mouseY);
        if (this.message != null) {
            TextBuilder data = new TextBuilder();
            try {
                data.append(this.message.getTime().format(DateTimeFormatter.ofPattern(((ConfigString)ConfigStorage.General.TIME_FORMAT.config).getStringValue())), class_2583.field_24360.method_27706(class_124.field_1075));
            }
            catch (IllegalArgumentException e) {
                AdvancedChatHud.LOGGER.log(Level.WARN, "Can't format time for context menu!", (Throwable)e);
            }
            if (this.message.getOwner() != null) {
                data.append(" - ", class_2583.field_24360.method_27706(class_124.field_1080));
                if (this.message.getOwner().getEntry().method_2971() != null) {
                    data.append(this.message.getOwner().getEntry().method_2971());
                } else {
                    data.append(this.message.getOwner().getEntry().method_2966().getName());
                }
            }
            if (!data.build().getString().isBlank()) {
                actions.put(data.build(), (x, y) -> InfoUtils.printActionbarMessage((String)"advancedchathud.context.nothing", (Object[])new Object[0]));
            }
            actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.copy", (Object[])new Object[0])), (x, y) -> {
                class_310.method_1551().field_1774.method_1455(this.message.getOriginalText().getString());
                InfoUtils.printActionbarMessage((String)"advancedchathud.context.copied", (Object[])new Object[0]);
            });
            actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.delete", (Object[])new Object[0])), (x, y) -> HudChatMessageHolder.getInstance().removeChatMessage(this.message));
            if (this.message.getOwner() != null) {
                actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.messageowner", (Object[])new Object[0])), (x, y) -> this.getScreen().getChatField().method_1852("/msg " + this.message.getOwner().getEntry().method_2966().getName() + " "));
            }
        }
        ChatWindow hovered = WindowManager.getInstance().getHovered(mouseX, mouseY);
        actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.removeallwindows", (Object[])new Object[0])), (x, y) -> WindowManager.getInstance().reset());
        actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.clearallmessages", (Object[])new Object[0])), (x, y) -> WindowManager.getInstance().clear());
        if (hovered != null) {
            actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.duplicatewindow", (Object[])new Object[0])), (x, y) -> WindowManager.getInstance().duplicateTab(hovered, x, y));
            actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.configurewindow", (Object[])new Object[0])), (x, y) -> WindowManager.getInstance().configureTab(this.getScreen(), hovered));
            actions.put(class_2561.method_43470((String)StringUtils.translate((String)"advancedchathud.context.minimalist", (Object[])new Object[0])), (x, y) -> hovered.toggleMinimalist());
        }
        this.menu = new ContextMenu(mouseX, mouseY, actions, () -> {
            this.menu = null;
        });
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.createContextMenu((int)mouseX, (int)mouseY);
            return true;
        }
        if (this.menu != null && this.menu.onMouseClicked((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return WindowManager.getInstance().mouseClicked((class_437)this.getScreen(), mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        return WindowManager.getInstance().mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return WindowManager.getInstance().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (amount > 1.0) {
            amount = 1.0;
        }
        if (amount < -1.0) {
            amount = -1.0;
        }
        if (!class_437.method_25442()) {
            amount *= 7.0;
        }
        return WindowManager.getInstance().scroll(amount, mouseX, mouseY);
    }
}

