/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.gui;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.interfaces.IJsonSave;
import io.github.darkkronicle.advancedchatcore.util.Color;
import io.github.darkkronicle.advancedchatcore.util.ColorUtil;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchatcore.util.EasingMethod;
import io.github.darkkronicle.advancedchatcore.util.LimitedInteger;
import io.github.darkkronicle.advancedchatcore.util.RawText;
import io.github.darkkronicle.advancedchatcore.util.TextBuilder;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.HudChatMessage;
import io.github.darkkronicle.advancedchathud.HudChatMessageHolder;
import io.github.darkkronicle.advancedchathud.config.HudConfigStorage;
import io.github.darkkronicle.advancedchathud.gui.WindowManager;
import io.github.darkkronicle.advancedchathud.tabs.AbstractChatTab;
import io.github.darkkronicle.advancedchathud.util.ScissorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class ChatWindow {
    private double scrolledHeight = 0.0;
    private double scrollStart = 0.0;
    private double scrollEnd = 0.0;
    private long lastScroll = 0L;
    private int scrollDuration = 200;
    private double yPercent;
    private double xPercent;
    private double widthPercent;
    private double heightPercent;
    private boolean renderRight = false;
    private boolean minimalist = false;
    private boolean renderTopFirst = false;
    private final class_310 client;
    private HudConfigStorage.Visibility visibility;
    private List<ChatMessage> lines;
    private boolean selected;
    private AbstractChatTab tab;
    private static final class_2960 X_ICON = new class_2960("advancedchathud", "textures/gui/chatwindow/x_icon.png");
    private static final class_2960 RESIZE_ICON = new class_2960("advancedchathud", "textures/gui/chatwindow/resize_icon.png");

    public ChatWindow(AbstractChatTab tab) {
        this.visibility = (HudConfigStorage.Visibility)((ConfigOptionList)HudConfigStorage.General.VISIBILITY.config).getOptionListValue();
        this.client = class_310.method_1551();
        int scaledHeight = this.client.method_22683().method_4502();
        int scaledWidth = this.client.method_22683().method_4486();
        this.yPercent = (double)(scaledHeight - ((ConfigInteger)HudConfigStorage.General.Y.config).getIntegerValue()) / (double)scaledHeight;
        this.xPercent = (double)((ConfigInteger)HudConfigStorage.General.X.config).getIntegerValue() / (double)scaledWidth;
        this.widthPercent = (double)((ConfigInteger)HudConfigStorage.General.WIDTH.config).getIntegerValue() / (double)scaledWidth;
        this.heightPercent = (double)((ConfigInteger)HudConfigStorage.General.HEIGHT.config).getIntegerValue() / (double)scaledHeight;
        this.setTab(tab);
    }

    public void setRelativePosition(double x, double y) {
        if (x > 2.0) {
            x = 0.0;
        }
        if (y > 2.0) {
            y = 0.0;
        }
        this.xPercent = x;
        this.yPercent = y;
    }

    public void setPosition(int x, int y) {
        int scaledHeight = this.client.method_22683().method_4502();
        this.xPercent = (double)x / (double)this.client.method_22683().method_4486();
        this.yPercent = (double)y / (double)scaledHeight;
    }

    public void setRelativeDimensions(double width, double height) {
        this.widthPercent = width;
        this.heightPercent = height;
    }

    public void setTab(AbstractChatTab tab) {
        this.tab = tab;
        this.lines = new ArrayList<ChatMessage>();
        List<HudChatMessage> messages = HudChatMessageHolder.getInstance().getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            this.addMessage(messages.get(i), false, false);
        }
        WindowManager.getInstance().setSelected(this);
    }

    public void addMessage(HudChatMessage message) {
        this.addMessage(message, false, true);
    }

    public void addMessage(HudChatMessage message, boolean force, boolean setTicks) {
        if (force || message.getTabs().contains(this.tab)) {
            ChatMessage newMessage = message.getMessage().shallowClone(this.getPaddedWidth());
            if (setTicks) {
                newMessage.setCreationTick(class_310.method_1551().field_1705.method_1738());
            }
            this.lines.add(0, newMessage);
            if (this.scrolledHeight > 0.0) {
                this.scrolledHeight += (double)(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() * newMessage.getLineCount() + ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue());
            }
            int visibleMessagesMaxSize = ((ConfigInteger)HudConfigStorage.General.STORED_LINES.config).getIntegerValue();
            while (this.lines.size() > visibleMessagesMaxSize) {
                this.lines.remove(this.lines.size() - 1);
            }
        }
    }

    public int getConvertedX() {
        return (int)((double)this.client.method_22683().method_4486() * this.xPercent);
    }

    public int getConvertedY() {
        return (int)((double)this.client.method_22683().method_4502() * this.yPercent);
    }

    public int getConvertedWidth() {
        return (int)((double)this.client.method_22683().method_4486() * this.widthPercent);
    }

    public int getConvertedHeight() {
        return (int)((double)this.client.method_22683().method_4502() * this.heightPercent);
    }

    public int getTotalLines() {
        int count = 0;
        for (ChatMessage line : this.lines) {
            count += line.getLineCount();
        }
        return count;
    }

    public void scroll(double amount) {
        this.scrollEnd = this.scrolledHeight + amount * 15.0;
        this.scrollStart = this.scrolledHeight;
        this.lastScroll = class_156.method_658();
    }

    public void updateScroll() {
        long time = class_156.method_658();
        this.scrollDuration = 300;
        this.scrolledHeight = this.scrollStart + (this.scrollEnd - this.scrollStart) * (1.0 - ((ConfigStorage.Easing)((ConfigOptionList)HudConfigStorage.General.SCROLL_TYPE.config).getOptionListValue()).apply((double)(1.0f - (float)(time - this.lastScroll) / (float)((ConfigInteger)HudConfigStorage.General.SCROLL_TIME.config).getIntegerValue())));
        int totalHeight = this.getTotalHeight();
        if (this.scrolledHeight > (double)totalHeight) {
            this.scrollStart = totalHeight;
            this.scrollEnd = totalHeight;
            this.lastScroll = 0L;
            this.scrolledHeight = totalHeight;
        }
        if (this.scrolledHeight <= 0.0) {
            this.scrollStart = 0.0;
            this.scrollEnd = 0.0;
            this.lastScroll = 0L;
            this.scrolledHeight = 0.0;
        }
    }

    public static void drawRect(class_4587 stack, int x, int y, int width, int height, int color) {
        class_332.method_25294((class_4587)stack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
    }

    public static void fill(class_4587 stack, int x, int y, int x2, int y2, int color) {
        class_332.method_25294((class_4587)stack, (int)x, (int)y, (int)x2, (int)y2, (int)color);
    }

    private static void drawOutline(class_4587 stack, int x, int y, int width, int height, int color) {
        ChatWindow.drawRect(stack, x, y, 1, height, color);
        ChatWindow.drawRect(stack, x + width - 1, y, 1, height, color);
        ChatWindow.drawRect(stack, x + 1, y, width - 2, 1, color);
        ChatWindow.drawRect(stack, x + 1, y + height - 1, width - 2, 1, color);
    }

    public void resetScroll() {
        this.lastScroll = 0L;
        this.scrollStart = 0.0;
        this.scrollEnd = 0.0;
        this.scrolledHeight = 0.0;
    }

    public int getPaddedWidth() {
        return this.getScaledWidth() - ((ConfigInteger)HudConfigStorage.General.LEFT_PAD.config).getIntegerValue() - ((ConfigInteger)HudConfigStorage.General.RIGHT_PAD.config).getIntegerValue() - this.headOffset();
    }

    private int headOffset() {
        return ((ConfigBoolean)HudConfigStorage.General.CHAT_HEADS.config).getBooleanValue() ? 10 : 0;
    }

    private int getActualY(int y) {
        return (int)Math.ceil((double)this.getConvertedY() / this.getScale()) - y;
    }

    private int getLeftX() {
        return (int)Math.ceil((double)this.getConvertedX() / this.getScale());
    }

    private int getPaddedLeftX() {
        return this.getLeftX() + (int)Math.ceil(((ConfigInteger)HudConfigStorage.General.LEFT_PAD.config).getIntegerValue() + (this.renderRight ? 0 : this.headOffset()));
    }

    private double getScale() {
        return ((ConfigDouble)HudConfigStorage.General.CHAT_SCALE.config).getDoubleValue();
    }

    private int getRightX() {
        return this.getLeftX() + this.getScaledWidth();
    }

    private int getPaddedRightX() {
        return this.getRightX() - ((ConfigInteger)HudConfigStorage.General.RIGHT_PAD.config).getIntegerValue() - (this.renderRight ? this.headOffset() : 0);
    }

    public int getActualHeight() {
        return this.getConvertedHeight() + this.getBarHeight();
    }

    private int getScaledHeight() {
        return (int)Math.ceil((double)this.getConvertedHeight() / this.getScale());
    }

    private int getScaledWidth() {
        return (int)Math.ceil((double)this.getConvertedWidth() / this.getScale());
    }

    private int getBarHeight() {
        return 14;
    }

    private int getScaledBarHeight() {
        return (int)Math.ceil(14.0 * this.getScale());
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        int x = this.getConvertedX();
        int y = this.getConvertedY();
        return (double)x <= mouseX && (double)(x + this.getConvertedWidth()) >= mouseX && (double)y >= mouseY && (double)(y - this.getActualHeight()) <= mouseY;
    }

    public int getTotalHeight() {
        return this.getTotalLines() * ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() + (this.lines.size() - 1) * ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue();
    }

    public void render(class_4587 matrixStack, int ticks, boolean focused) {
        if (!focused) {
            this.resetScroll();
        }
        this.updateScroll();
        if (this.visibility == HudConfigStorage.Visibility.FOCUSONLY && !focused) {
            return;
        }
        int totalLines = this.getTotalLines();
        boolean chatFocused = this.visibility == HudConfigStorage.Visibility.ALWAYS || focused;
        int totalHeight = this.getTotalHeight();
        if (this.scrolledHeight > (double)totalHeight) {
            this.scrolledHeight = totalHeight;
        }
        matrixStack.method_22903();
        matrixStack.method_22905((float)this.getScale(), (float)this.getScale(), 1.0f);
        int lines = 0;
        int currentHeight = 0;
        int renderedLines = 0;
        int scaledWidth = this.getScaledWidth();
        int scaledHeight = this.getScaledHeight();
        int leftX = this.getLeftX();
        int padLX = this.getPaddedLeftX();
        int rightX = this.getRightX();
        int padRX = this.getPaddedRightX();
        int limit = this.getScaledHeight() - ((ConfigInteger)HudConfigStorage.General.TOP_PAD.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue();
        int lastY = 0;
        LimitedInteger y = new LimitedInteger(this.getScaledHeight() - ((ConfigInteger)HudConfigStorage.General.TOP_PAD.config).getIntegerValue() + (((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() * (this.renderTopFirst ? 2 : 1)), this.renderTopFirst ? ((ConfigInteger)HudConfigStorage.General.TOP_PAD.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() : ((ConfigInteger)HudConfigStorage.General.BOTTOM_PAD.config).getIntegerValue());
        double scale = this.client.method_22683().method_4495();
        ScissorUtil.applyScissorBox((int)((double)this.getConvertedX() * scale), (int)((double)(this.client.method_22683().method_4502() - this.getConvertedY()) * scale), (int)((double)this.getConvertedWidth() * scale), (int)((double)this.getConvertedHeight() * scale));
        boolean foundScroll = false;
        for (int j = 0; j < this.lines.size(); ++j) {
            ChatMessage message = this.lines.get(j);
            for (int i = message.getLineCount() - 1; i >= 0; --i) {
                int n;
                int lineIndex = this.renderTopFirst ? i : message.getLineCount() - i - 1;
                ++lines;
                if ((double)currentHeight < this.scrolledHeight - (double)((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue()) {
                    currentHeight += ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue();
                    continue;
                }
                boolean renderBelow = false;
                if (!foundScroll) {
                    foundScroll = true;
                    int n2 = currentHeight - (int)this.scrolledHeight - ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue();
                    Objects.requireNonNull(this.client.field_1772);
                    y.incrementIfPossible(n2 + 9);
                    renderBelow = true;
                }
                currentHeight += ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue();
                if (!y.incrementIfPossible(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue())) break;
                ChatMessage.AdvancedChatLine line = (ChatMessage.AdvancedChatLine)message.getLines().get(this.renderTopFirst ? message.getLineCount() - i - 1 : i);
                if (this.renderTopFirst) {
                    int n3 = limit - y.getValue();
                    Objects.requireNonNull(this.client.field_1772);
                    n = n3 + 9;
                } else {
                    n = y.getValue();
                }
                this.drawLine(matrixStack, line, leftX, n, padLX, padRX, lineIndex, j, renderedLines, chatFocused, ticks, renderBelow ? y.getValue() - lastY - ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() - 1 : 0);
                lastY = y.getValue();
                ++renderedLines;
            }
            if ((double)currentHeight >= this.scrolledHeight && (lines == totalLines || !y.isPossible(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue()) || !y.incrementIfPossible(((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue()))) break;
            currentHeight += ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue();
        }
        ScissorUtil.resetScissor();
        if (renderedLines == 0) {
            y.setValue(0);
        }
        if (focused && this.isSelected()) {
            this.tab.resetUnread();
        }
        if (focused && !this.isMinimalist()) {
            ChatWindow.drawOutline(matrixStack, leftX, this.getActualY(0) - scaledHeight - 1, scaledWidth, scaledHeight + 1, this.tab.getBorderColor().color());
            int scaledBar = this.getBarHeight();
            int newY = this.getScaledHeight() + scaledBar;
            String label = this.tab.getAbbreviation();
            int labelWidth = StringUtils.getStringWidth((String)label) + 8;
            ChatWindow.drawRect(matrixStack, leftX, this.getActualY(newY), labelWidth, scaledBar, this.tab.getMainColor().color());
            ChatWindow.drawOutline(matrixStack, leftX, this.getActualY(newY), labelWidth, scaledBar, this.tab.getBorderColor().color());
            class_332.method_25300((class_4587)matrixStack, (class_327)class_310.method_1551().field_1772, (String)this.tab.getAbbreviation(), (int)(leftX + labelWidth / 2), (int)this.getActualY(newY - 3), (int)Colors.getInstance().getColorOrWhite("white").color());
            ChatWindow.drawRect(matrixStack, leftX + labelWidth, this.getActualY(newY), this.getScaledWidth() - labelWidth, scaledBar, this.selected ? this.tab.getMainColor().color() : this.tab.getInnerColor().color());
            ChatWindow.drawOutline(matrixStack, leftX + labelWidth, this.getActualY(newY), this.getScaledWidth() - labelWidth, scaledBar, this.tab.getBorderColor().color());
            ChatWindow.drawOutline(matrixStack, rightX - scaledBar, this.getActualY(newY), scaledBar, scaledBar, this.tab.getBorderColor().color());
            ChatWindow.drawOutline(matrixStack, rightX - scaledBar * 2 + 1, this.getActualY(newY), scaledBar, scaledBar, this.tab.getBorderColor().color());
            ChatWindow.drawOutline(matrixStack, rightX - scaledBar * 3 + 2, this.getActualY(newY), scaledBar, scaledBar, this.tab.getBorderColor().color());
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.bindTexture((class_2960)X_ICON);
            class_332.method_25293((class_4587)matrixStack, (int)(rightX - scaledBar + 1), (int)this.getActualY(newY - 1), (int)(scaledBar - 2), (int)(scaledBar - 2), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.bindTexture((class_2960)RESIZE_ICON);
            class_332.method_25293((class_4587)matrixStack, (int)(rightX - scaledBar * 2 + 2), (int)this.getActualY(newY - 1), (int)(scaledBar - 2), (int)(scaledBar - 2), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderUtils.bindTexture((class_2960)this.visibility.getTexture());
            class_332.method_25293((class_4587)matrixStack, (int)(rightX - scaledBar * 3 + 3), (int)this.getActualY(newY - 1), (int)(scaledBar - 2), (int)(scaledBar - 2), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            double mouseX = this.client.field_1729.method_1603() / 2.0;
            double mouseY = this.client.field_1729.method_1604() / 2.0;
            if (this.isMouseOverVisibility(mouseX, mouseY)) {
                class_332.method_25303((class_4587)matrixStack, (class_327)this.client.field_1772, (String)this.visibility.getDisplayName(), (int)((int)(mouseX / this.getScale() + 4.0)), (int)((int)(mouseY / this.getScale() - 16.0)), (int)Colors.getInstance().getColorOrWhite("white").color());
            }
        }
        if (chatFocused) {
            if (y.getValue() < this.getScaledHeight()) {
                ChatWindow.fill(matrixStack, leftX, this.getActualY(this.renderTopFirst ? limit - y.getValue() : y.getValue()), rightX, this.getActualY(this.renderTopFirst ? 0 : this.getScaledHeight()), this.tab.getInnerColor().color());
            }
            float add = (float)this.scrolledHeight / (float)this.getTotalHeight();
            int scrollHeight = (int)(add * (float)(this.getScaledHeight() - 10));
            ChatWindow.drawRect(matrixStack, this.getScaledWidth() + leftX - 1, this.getActualY(scrollHeight + 10), 1, 10, Colors.getInstance().getColorOrWhite("white").color());
        }
        matrixStack.method_22909();
    }

    private void drawLine(class_4587 matrixStack, ChatMessage.AdvancedChatLine line, int x, int y, int pLX, int pRX, int lineIndex, int messageIndex, int renderedLines, boolean focused, int ticks, int renderBelow) {
        int height = ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue();
        if (renderedLines == 0) {
            if (focused) {
                height += this.renderTopFirst ? ((ConfigInteger)HudConfigStorage.General.TOP_PAD.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue() + 1 : ((ConfigInteger)HudConfigStorage.General.BOTTOM_PAD.config).getIntegerValue();
                height += renderBelow;
            }
        } else if (lineIndex == 0) {
            height += ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue();
        }
        Color background = line.getParent().getBackgroundColor();
        Color text = ((ConfigColor)HudConfigStorage.General.EMPTY_TEXT_COLOR.config).get();
        if (background == null) {
            background = this.tab.getInnerColor();
        }
        if (messageIndex % 2 == 0 && ((ConfigBoolean)HudConfigStorage.General.ALTERNATE_LINES.config).getBooleanValue()) {
            background = background.alpha() <= 215 ? background.withAlpha(background.alpha() + 40) : background.withAlpha(background.alpha() - 40);
        }
        float applied = 1.0f;
        if (!focused) {
            int fadeStart = ((ConfigInteger)HudConfigStorage.General.FADE_START.config).getIntegerValue();
            int fadeStop = fadeStart + ((ConfigInteger)HudConfigStorage.General.FADE_TIME.config).getIntegerValue();
            int timeAlive = ticks - line.getParent().getCreationTick();
            float percent = (float)Math.min(1.0, (double)(timeAlive - fadeStart) / (double)(fadeStop - fadeStart));
            applied = 1.0f - (float)((EasingMethod)((ConfigOptionList)HudConfigStorage.General.FADE_TYPE.config).getOptionListValue()).apply((double)percent);
            if ((applied = Math.max(0.0f, applied)) <= 0.0f) {
                return;
            }
            if (applied < 1.0f) {
                background = ColorUtil.fade((Color)background, (float)applied);
                text = ColorUtil.fade((Color)text, (float)applied);
            }
        }
        class_2561 render = line.getText();
        if (line.getParent().getStacks() > 0 && lineIndex == 0) {
            TextBuilder toPrint = new TextBuilder().append(render);
            class_2583 style = class_2583.field_24360;
            class_5251 color = class_5251.method_27717((int)Colors.getInstance().getColorOrWhite("gray").color());
            style = style.method_27703(color);
            toPrint.append((class_2561)new RawText(" (" + (line.getParent().getStacks() + 1) + ")", style));
            render = toPrint.build();
        }
        int scaledWidth = this.getScaledWidth();
        int lineWidth = this.client.field_1772.method_27525((class_5348)render) + 2;
        int backgroundWidth = !focused && ((ConfigOptionList)HudConfigStorage.General.HUD_LINE_TYPE.config).getOptionListValue() == HudConfigStorage.HudLineType.COMPACT ? lineWidth + this.headOffset() : scaledWidth;
        int backgroundY = this.getActualY(y);
        if (this.renderTopFirst && renderedLines == 0) {
            backgroundY -= 1 + ((ConfigInteger)HudConfigStorage.General.TOP_PAD.config).getIntegerValue();
        }
        if (this.renderRight) {
            ChatWindow.drawRect(matrixStack, x + (scaledWidth - backgroundWidth), backgroundY, backgroundWidth, height, background.color());
        } else {
            ChatWindow.drawRect(matrixStack, x, backgroundY, backgroundWidth, height, background.color());
        }
        if (lineIndex == line.getParent().getLineCount() - 1 && line.getParent().getOwner() != null && ((ConfigBoolean)HudConfigStorage.General.CHAT_HEADS.config).getBooleanValue()) {
            RenderUtils.setupBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)applied);
            RenderSystem.setShaderTexture((int)0, (class_2960)line.getParent().getOwner().getTexture());
            int headX = this.renderRight ? pRX + 2 : pLX - 10;
            int headY = this.getActualY(y);
            class_332.method_25293((class_4587)matrixStack, (int)headX, (int)headY, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_332.method_25293((class_4587)matrixStack, (int)headX, (int)headY, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.client.field_1772.method_27517(matrixStack, render.method_30937(), this.renderRight ? (float)(pRX - lineWidth) : (float)pLX, (float)(this.getActualY(y) + 1), text.color());
    }

    public class_2583 getText(double mouseX, double mouseY) {
        if (!WindowManager.getInstance().isChatFocused()) {
            return null;
        }
        double relX = mouseX;
        double relY = (double)this.getConvertedY() - mouseY;
        double trueX = relX / this.getScale() - (double)this.getPaddedLeftX();
        double trueY = relY / this.getScale();
        if (trueX < 0.0 || trueY < 0.0) {
            return null;
        }
        if (trueY > (double)this.getScaledHeight() || trueX > (double)this.getScaledWidth()) {
            return null;
        }
        int lineHeight = 0;
        boolean foundScroll = false;
        LimitedInteger y = new LimitedInteger(this.getScaledHeight() + ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue(), ((ConfigInteger)HudConfigStorage.General.BOTTOM_PAD.config).getIntegerValue());
        for (ChatMessage message : this.lines) {
            for (int i = message.getLineCount() - 1; i >= 0; --i) {
                if ((double)(lineHeight += ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue()) < this.scrolledHeight) continue;
                if (!foundScroll) {
                    foundScroll = true;
                    trueY -= (double)(lineHeight - (int)this.scrolledHeight - ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue());
                }
                if (!y.incrementIfPossible(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue())) break;
                if (!(trueY <= (double)y.getValue().intValue()) || !(trueY >= (double)(y.getValue() - ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue()))) continue;
                ChatMessage.AdvancedChatLine line = (ChatMessage.AdvancedChatLine)message.getLines().get(i);
                double truestX = trueX;
                if (this.renderRight) {
                    truestX = trueX - (double)(this.getScaledWidth() - line.getWidth()) + (double)this.headOffset() + (double)((ConfigInteger)HudConfigStorage.General.RIGHT_PAD.config).getIntegerValue() + (double)((ConfigInteger)HudConfigStorage.General.LEFT_PAD.config).getIntegerValue();
                }
                return this.client.field_1772.method_27527().method_27489((class_5348)line.getText(), (int)truestX);
            }
            if ((double)lineHeight >= this.scrolledHeight && (lineHeight == this.getTotalHeight() || !y.isPossible(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue()) || !y.incrementIfPossible(((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue()))) break;
            lineHeight += ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue();
        }
        return null;
    }

    public ChatMessage getMessage(double mouseX, double mouseY) {
        if (!WindowManager.getInstance().isChatFocused()) {
            return null;
        }
        double relX = mouseX;
        double relY = (double)this.getConvertedY() - mouseY;
        if (this.renderTopFirst) {
            relY = (double)this.getConvertedHeight() - relY;
        }
        double trueX = relX / this.getScale() - (double)this.getPaddedLeftX();
        double trueY = relY / this.getScale();
        if (trueX < 0.0 || trueY < 0.0) {
            return null;
        }
        if (trueY > (double)this.getScaledHeight() || trueX > (double)this.getScaledWidth()) {
            return null;
        }
        int lineHeight = 0;
        boolean foundScroll = false;
        LimitedInteger y = new LimitedInteger(this.getScaledHeight() + ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue(), ((ConfigInteger)HudConfigStorage.General.BOTTOM_PAD.config).getIntegerValue());
        for (ChatMessage message : this.lines) {
            for (int i = message.getLineCount() - 1; i >= 0; --i) {
                if ((double)(lineHeight += ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue()) < this.scrolledHeight) continue;
                if (!foundScroll) {
                    foundScroll = true;
                    trueY -= (double)(lineHeight - (int)this.scrolledHeight - ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue());
                }
                if (!y.incrementIfPossible(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue())) break;
                if (!(trueY <= (double)y.getValue().intValue()) || !(trueY >= (double)(y.getValue() - ((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue()))) continue;
                return message;
            }
            if ((double)lineHeight >= this.scrolledHeight && (lineHeight == this.getTotalHeight() || !y.isPossible(((ConfigInteger)HudConfigStorage.General.LINE_SPACE.config).getIntegerValue() + ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue()) || !y.incrementIfPossible(((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue()))) break;
            lineHeight += ((ConfigInteger)HudConfigStorage.General.MESSAGE_SPACE.config).getIntegerValue();
        }
        return null;
    }

    public boolean isMouseOverDragBar(double mouseX, double mouseY) {
        int x = this.getConvertedX();
        int y = this.getConvertedY();
        int width = this.getConvertedWidth();
        int height = this.getConvertedHeight();
        return this.isMouseOver(mouseX, mouseY) && mouseX <= (double)(x + width - this.getScaledBarHeight() * 3) && mouseY <= (double)(y - height);
    }

    public boolean onMouseClicked(double mouseX, double mouseY, int button) {
        boolean onButtons;
        int convX = this.getConvertedX();
        int width = this.getConvertedWidth();
        boolean bl = onButtons = this.isMouseOverDragBar(mouseX - (double)(this.getScaledBarHeight() * 3), mouseY) && mouseX >= (double)(convX + width - this.getScaledBarHeight() * 3);
        if (!onButtons) {
            return false;
        }
        int x = width - (int)(mouseX - (double)convX);
        if (x <= this.getScaledBarHeight()) {
            WindowManager.getInstance().deleteWindow(this);
        } else if (x >= this.getScaledBarHeight() * 2) {
            this.visibility = this.visibility.cycle(true);
        }
        this.client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        return true;
    }

    public boolean isMouseOverResize(double mouseX, double mouseY) {
        int x = this.getConvertedX();
        int y = this.getConvertedY();
        int width = this.getConvertedWidth();
        int height = this.getConvertedHeight();
        return this.isMouseOver(mouseX, mouseY) && mouseX >= (double)(x + width - this.getScaledBarHeight() * 2) && mouseX <= (double)(x + width - this.getScaledBarHeight()) && mouseY <= (double)(y - height);
    }

    public boolean isMouseOverVisibility(double mouseX, double mouseY) {
        int x = this.getConvertedX();
        int y = this.getConvertedY();
        int width = this.getConvertedWidth();
        int height = this.getConvertedHeight();
        return this.isMouseOver(mouseX, mouseY) && mouseX >= (double)(x + width - this.getScaledBarHeight() * 3) && mouseX <= (double)(x + width - this.getScaledBarHeight() * 2) && mouseY <= (double)(y - height);
    }

    public void setDimensions(int width, int height) {
        this.widthPercent = (double)width / (double)this.client.method_22683().method_4486();
        this.heightPercent = (double)height / (double)this.client.method_22683().method_4502();
        for (ChatMessage m : this.lines) {
            m.formatChildren(this.getPaddedWidth());
        }
    }

    public void stackMessage(HudChatMessage message) {
        ChatMessage toRemove = null;
        for (ChatMessage line : this.lines) {
            if (!message.getMessage().isSimilar(line)) continue;
            if (!((ConfigBoolean)ConfigStorage.General.CHAT_STACK_UPDATE.config).getBooleanValue()) {
                line.setStacks(message.getMessage().getStacks());
                return;
            }
            toRemove = line;
            break;
        }
        if (toRemove != null) {
            this.lines.remove(toRemove);
            this.addMessage(message, true, true);
        }
    }

    public void clearLines() {
        this.lines.clear();
    }

    public void removeMessage(ChatMessage remove) {
        ChatMessage toRemove = null;
        for (ChatMessage line : this.lines) {
            if (!remove.isSimilar(line) || !remove.getTime().equals(line.getTime())) continue;
            toRemove = line;
            break;
        }
        if (toRemove != null) {
            this.lines.remove(toRemove);
        }
    }

    public void toggleMinimalist() {
        this.minimalist = !this.minimalist;
    }

    public void onResolutionChange() {
        for (ChatMessage m : this.lines) {
            m.formatChildren(this.getConvertedWidth());
        }
    }

    public double getYPercent() {
        return this.yPercent;
    }

    public void setYPercent(double yPercent) {
        this.yPercent = yPercent;
    }

    public double getXPercent() {
        return this.xPercent;
    }

    public void setXPercent(double xPercent) {
        this.xPercent = xPercent;
    }

    public double getWidthPercent() {
        return this.widthPercent;
    }

    public void setWidthPercent(double widthPercent) {
        this.widthPercent = widthPercent;
    }

    public double getHeightPercent() {
        return this.heightPercent;
    }

    public void setHeightPercent(double heightPercent) {
        this.heightPercent = heightPercent;
    }

    public boolean isRenderRight() {
        return this.renderRight;
    }

    public void setRenderRight(boolean renderRight) {
        this.renderRight = renderRight;
    }

    public boolean isMinimalist() {
        return this.minimalist;
    }

    public void setMinimalist(boolean minimalist) {
        this.minimalist = minimalist;
    }

    public boolean isRenderTopFirst() {
        return this.renderTopFirst;
    }

    public void setRenderTopFirst(boolean renderTopFirst) {
        this.renderTopFirst = renderTopFirst;
    }

    public void setVisibility(HudConfigStorage.Visibility visibility) {
        this.visibility = visibility;
    }

    public HudConfigStorage.Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public AbstractChatTab getTab() {
        return this.tab;
    }

    public static class ChatWindowSerializer
    implements IJsonSave<ChatWindow> {
        public ChatWindow load(JsonObject obj) {
            if (!obj.has("tabuuid")) {
                return null;
            }
            String uuidEl = obj.get("tabuuid").getAsString();
            UUID uuid = UUID.fromString(uuidEl);
            AbstractChatTab tab = AdvancedChatHud.MAIN_CHAT_TAB.fromUUID(uuid);
            if (tab == null) {
                AdvancedChatHud.LOGGER.warn("Tab with UUID " + uuidEl + " could not be found!");
                return null;
            }
            ChatWindow window = new ChatWindow(tab);
            window.setSelected(obj.get("selected").getAsBoolean());
            if (obj.has("renderRight")) {
                window.setRenderRight(obj.get("renderRight").getAsBoolean());
            }
            if (obj.has("renderTopFirst")) {
                window.setRenderTopFirst(obj.get("renderTopFirst").getAsBoolean());
            }
            if (obj.has("minimalist")) {
                window.setMinimalist(obj.get("minimalist").getAsBoolean());
            }
            window.setRelativePosition(obj.get("x").getAsDouble(), obj.get("y").getAsDouble());
            window.setVisibility(HudConfigStorage.Visibility.fromVisibilityString(obj.get("visibility").getAsString()));
            window.setRelativeDimensions(obj.get("width").getAsDouble(), obj.get("height").getAsDouble());
            return window;
        }

        public JsonObject save(ChatWindow chatWindow) {
            JsonObject obj = new JsonObject();
            obj.addProperty("x", (Number)chatWindow.getXPercent());
            obj.addProperty("y", (Number)chatWindow.getYPercent());
            obj.addProperty("width", (Number)chatWindow.getWidthPercent());
            obj.addProperty("height", (Number)chatWindow.getHeightPercent());
            obj.addProperty("visibility", chatWindow.getVisibility().getStringValue());
            obj.addProperty("tabuuid", chatWindow.getTab().getUuid().toString());
            obj.addProperty("selected", Boolean.valueOf(chatWindow.isSelected()));
            obj.addProperty("renderRight", Boolean.valueOf(chatWindow.isRenderRight()));
            obj.addProperty("renderTopFirst", Boolean.valueOf(chatWindow.isRenderTopFirst()));
            obj.addProperty("minimalist", Boolean.valueOf(chatWindow.isMinimalist()));
            return obj;
        }
    }
}

