/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.config.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.config.SaveableConfig;
import io.github.darkkronicle.advancedchatcore.gui.buttons.BackButtonListener;
import io.github.darkkronicle.advancedchatcore.gui.buttons.Buttons;
import io.github.darkkronicle.advancedchatcore.gui.buttons.NamedSimpleButton;
import io.github.darkkronicle.advancedchatcore.interfaces.IClosable;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.config.ChatTab;
import io.github.darkkronicle.advancedchathud.config.gui.MatchesEditor;
import io.github.darkkronicle.advancedchathud.config.gui.SharingScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_437;

public class GuiTabEditor
extends GuiConfigsBase
implements IClosable {
    private final ChatTab tab;
    private final boolean main;

    public GuiTabEditor(class_437 parent, ChatTab tab) {
        this(parent, tab, false);
    }

    public GuiTabEditor(class_437 parent, ChatTab tab, boolean main) {
        super(10, 50, "advancedchathud", parent, ((ConfigString)tab.getName().config).getStringValue(), new Object[0]);
        this.tab = tab;
        this.main = main;
        this.setParent(parent);
    }

    public void initGui() {
        super.initGui();
        this.createButtons(10, 26);
    }

    private void createButtons(int x, int y) {
        NamedSimpleButton back = Buttons.BACK.createButton(x, y);
        x += ((ButtonGeneric)this.addButton((ButtonBase)back, (IButtonActionListener)new BackButtonListener((IClosable)this))).getWidth() + 2;
        x += this.addButton(x, y, "advancedchathud.gui.button.export", (button, mouseButton) -> {
            this.save();
            GuiBase.openGui((class_437)SharingScreen.fromTab(this.tab, (class_437)this));
        }) + 2;
        if (!this.main) {
            x += this.addButton(x, y, "advancedchathud.gui.button.matches", (button, mouseButton) -> {
                this.save();
                GuiBase.openGui((class_437)new MatchesEditor((class_437)this, this.tab));
            }) + 2;
        }
    }

    private int addButton(int x, int y, String translation, IButtonActionListener listener) {
        return ((NamedSimpleButton)this.addButton((ButtonBase)new NamedSimpleButton(x, y, StringUtils.translate((String)translation, (Object[])new Object[0])), listener)).getWidth();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ArrayList<IConfigBase> config = new ArrayList<IConfigBase>();
        ImmutableList<SaveableConfig<?>> options = this.main ? this.tab.getMainEditableOptions() : this.tab.getOptions();
        for (SaveableConfig s : options) {
            config.add(s.config);
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(config);
    }

    public void method_25419() {
        this.save();
        super.method_25419();
    }

    protected void closeGui(boolean showParent) {
        this.save();
        super.closeGui(showParent);
    }

    public void save() {
        AdvancedChatHud.MAIN_CHAT_TAB.setUpTabs();
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onKeyPressed(keyCode);
            return true;
        }
        if (((WidgetListConfigOptions)this.getListWidget()).onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.parentScreen != GuiUtils.getCurrentScreen()) {
            this.closeGui(true);
            return true;
        }
        return false;
    }

    public void close(ButtonBase button) {
        this.closeGui(true);
    }
}

