/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.darkkronicle.advancedchatcore.interfaces.IJsonSave;
import io.github.darkkronicle.advancedchatcore.util.FindType;

public class Match {
    private String pattern;
    private FindType findType;

    public String getPattern() {
        return this.pattern;
    }

    public FindType getFindType() {
        return this.findType;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setFindType(FindType findType) {
        this.findType = findType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Match)) {
            return false;
        }
        Match other = (Match)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        FindType this$findType = this.getFindType();
        FindType other$findType = other.getFindType();
        return !(this$findType == null ? other$findType != null : !this$findType.equals(other$findType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Match;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        FindType $findType = this.getFindType();
        result = result * 59 + ($findType == null ? 43 : $findType.hashCode());
        return result;
    }

    public String toString() {
        return "Match(pattern=" + this.getPattern() + ", findType=" + this.getFindType() + ")";
    }

    public Match(String pattern, FindType findType) {
        this.pattern = pattern;
        this.findType = findType;
    }

    public static class MatchSerializer
    implements IJsonSave<Match> {
        public Match load(JsonObject obj) {
            JsonElement pattern = obj.get("pattern");
            JsonElement findType = obj.get("findtype");
            if (pattern == null || findType == null) {
                return null;
            }
            FindType type = FindType.fromFindType((String)findType.getAsString());
            return new Match(pattern.getAsString(), type);
        }

        public JsonObject save(Match match) {
            JsonObject obj = new JsonObject();
            obj.addProperty("pattern", match.getPattern());
            obj.addProperty("findtype", match.getFindType().configString);
            return obj;
        }
    }
}

