/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.config.ConfigStorage;
import io.github.darkkronicle.advancedchatcore.config.SaveableConfig;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.config.ChatTab;
import io.github.darkkronicle.advancedchathud.gui.WindowManager;
import io.github.darkkronicle.advancedchathud.tabs.MainChatTab;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class HudConfigStorage
implements IConfigHandler {
    public static final String CONFIG_FILE_NAME = "advancedchathud.json";
    private static final int CONFIG_VERSION = 1;
    public static final List<ChatTab> TABS = new ArrayList<ChatTab>();
    public static ChatTab MAIN_TAB = ChatTab.getMainOptions();

    public static void loadFromFile() {
        JsonElement element;
        File configFile = FileUtils.getConfigDirectory().toPath().resolve("advancedchat").resolve(CONFIG_FILE_NAME).toFile();
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = ConfigStorage.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            ChatTab.ChatTabJsonSave tabJson = new ChatTab.ChatTabJsonSave();
            JsonObject root = element.getAsJsonObject();
            JsonElement tab = root.get("maintab");
            if (tab.isJsonObject()) {
                MAIN_TAB = tabJson.load(tab.getAsJsonObject());
                AdvancedChatHud.MAIN_CHAT_TAB.refreshOptions();
            }
            JsonElement tabs = root.get("tabs");
            TABS.clear();
            if (tabs.isJsonArray()) {
                for (JsonElement t : tabs.getAsJsonArray()) {
                    if (!t.isJsonObject()) continue;
                    TABS.add(tabJson.load(t.getAsJsonObject()));
                }
            }
            AdvancedChatHud.MAIN_CHAT_TAB.setUpTabs();
            JsonElement windows = root.get("windows");
            if (windows != null && windows.isJsonArray()) {
                WindowManager.getInstance().loadFromJson(windows.getAsJsonArray());
            } else {
                WindowManager.getInstance().loadFromJson(null);
            }
            ConfigStorage.readOptions((JsonObject)root, (String)"general", General.OPTIONS);
            int n = JsonUtils.getIntegerOrDefault((JsonObject)root, (String)"configVersion", (int)0);
        }
    }

    public static void saveFromFile() {
        File dir = FileUtils.getConfigDirectory().toPath().resolve("advancedchat").toFile();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            ChatTab.ChatTabJsonSave tabJson = new ChatTab.ChatTabJsonSave();
            JsonObject root = new JsonObject();
            ConfigStorage.writeOptions((JsonObject)root, (String)"general", General.OPTIONS);
            root.add("maintab", (JsonElement)tabJson.save(MAIN_TAB));
            JsonArray tabs = new JsonArray();
            for (ChatTab tab : TABS) {
                tabs.add((JsonElement)tabJson.save(tab));
            }
            root.add("tabs", (JsonElement)tabs);
            root.add("windows", (JsonElement)WindowManager.getInstance().saveJson());
            root.add("config_version", (JsonElement)new JsonPrimitive((Number)1));
            ConfigStorage.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        MainChatTab.LOAD_ALL_JSON = true;
        HudConfigStorage.loadFromFile();
        MainChatTab.LOAD_ALL_JSON = false;
    }

    public void save() {
        HudConfigStorage.saveFromFile();
    }

    public static class General {
        public static final String NAME = "general";
        public static final SaveableConfig<ConfigBoolean> VANILLA_HUD = SaveableConfig.fromConfig((String)"vanillHud", (IConfigBase)new ConfigBoolean(General.translate("vanillahud"), false, General.translate("info.vanillahud")));
        public static final SaveableConfig<ConfigBoolean> CHAT_HEADS = SaveableConfig.fromConfig((String)"chatHeads", (IConfigBase)new ConfigBoolean(General.translate("chatheads"), false, General.translate("info.chatheads")));
        public static final SaveableConfig<ConfigBoolean> TAB_BUTTONS_ON_RIGHT = SaveableConfig.fromConfig((String)"tabButtonsOnRight", (IConfigBase)new ConfigBoolean(General.translate("righttabbuttons"), false, General.translate("info.righttabbuttons")));
        public static final SaveableConfig<ConfigInteger> WIDTH = SaveableConfig.fromConfig((String)"width", (IConfigBase)new ConfigInteger(General.translate("width"), 280, 100, 600, General.translate("info.width")));
        public static final SaveableConfig<ConfigInteger> HEIGHT = SaveableConfig.fromConfig((String)"height", (IConfigBase)new ConfigInteger(General.translate("height"), 117, 20, 400, General.translate("info.height")));
        public static final SaveableConfig<ConfigInteger> X = SaveableConfig.fromConfig((String)"x", (IConfigBase)new ConfigInteger(General.translate("x"), 0, 0, 4000, General.translate("info.x")));
        public static final SaveableConfig<ConfigInteger> Y = SaveableConfig.fromConfig((String)"y", (IConfigBase)new ConfigInteger(General.translate("y"), 30, 0, 4000, General.translate("info.y")));
        public static final SaveableConfig<ConfigInteger> MESSAGE_SPACE = SaveableConfig.fromConfig((String)"messageSpace", (IConfigBase)new ConfigInteger(General.translate("messagespace"), 0, 0, 10, General.translate("info.messagespace")));
        public static final SaveableConfig<ConfigInteger> LINE_SPACE = SaveableConfig.fromConfig((String)"lineSpace", (IConfigBase)new ConfigInteger(General.translate("linespace"), 9, 8, 20, General.translate("info.linespace")));
        public static final SaveableConfig<ConfigInteger> LEFT_PAD = SaveableConfig.fromConfig((String)"leftPad", (IConfigBase)new ConfigInteger(General.translate("leftpad"), 2, 0, 20, General.translate("info.leftpad")));
        public static final SaveableConfig<ConfigInteger> RIGHT_PAD = SaveableConfig.fromConfig((String)"rightPad", (IConfigBase)new ConfigInteger(General.translate("rightpad"), 2, 0, 20, General.translate("info.rightpad")));
        public static final SaveableConfig<ConfigInteger> BOTTOM_PAD = SaveableConfig.fromConfig((String)"bottomPad", (IConfigBase)new ConfigInteger(General.translate("bottompad"), 1, 0, 20, General.translate("info.bottompad")));
        public static final SaveableConfig<ConfigInteger> TOP_PAD = SaveableConfig.fromConfig((String)"topPad", (IConfigBase)new ConfigInteger(General.translate("toppad"), 0, 0, 20, General.translate("info.toppad")));
        public static final SaveableConfig<ConfigOptionList> VISIBILITY = SaveableConfig.fromConfig((String)"visibility", (IConfigBase)new ConfigOptionList(General.translate("visibility"), (IConfigOptionListEntry)Visibility.VANILLA, General.translate("info.visibility")));
        public static final SaveableConfig<ConfigDouble> CHAT_SCALE = SaveableConfig.fromConfig((String)General.translate("chatScale"), (IConfigBase)new ConfigDouble(General.translate("chatscale"), 1.0, 0.0, 1.0, General.translate("info.chatscale")));
        public static final SaveableConfig<ConfigInteger> FADE_TIME = SaveableConfig.fromConfig((String)"fadeTime", (IConfigBase)new ConfigInteger(General.translate("fadetime"), 40, 0, 200, General.translate("info.fadetime")));
        public static final SaveableConfig<ConfigInteger> FADE_START = SaveableConfig.fromConfig((String)"fadeStart", (IConfigBase)new ConfigInteger(General.translate("fadestart"), 100, 20, 1000, General.translate("info.fadestart")));
        public static final SaveableConfig<ConfigOptionList> FADE_TYPE = SaveableConfig.fromConfig((String)"fadeType", (IConfigBase)new ConfigOptionList(General.translate("fadetype"), (IConfigOptionListEntry)ConfigStorage.Easing.LINEAR, General.translate("info.fadetype")));
        public static final SaveableConfig<ConfigColor> EMPTY_TEXT_COLOR = SaveableConfig.fromConfig((String)"emptyTextColor", (IConfigBase)new ConfigColor(General.translate("emptytextcolor"), Colors.getInstance().getColorOrWhite("white"), General.translate("info.emptytextcolor")));
        public static final SaveableConfig<ConfigOptionList> HUD_LINE_TYPE = SaveableConfig.fromConfig((String)"hudLineType", (IConfigBase)new ConfigOptionList(General.translate("hudlinetype"), (IConfigOptionListEntry)HudLineType.FULL, General.translate("info.hudlinetype")));
        public static final SaveableConfig<ConfigBoolean> ALTERNATE_LINES = SaveableConfig.fromConfig((String)"alternateLines", (IConfigBase)new ConfigBoolean(General.translate("alternatelines"), false, General.translate("info.alternatelines")));
        public static final SaveableConfig<ConfigInteger> STORED_LINES = SaveableConfig.fromConfig((String)"storedLines", (IConfigBase)new ConfigInteger(General.translate("storedlines"), 200, 20, 1000, General.translate("info.storedlines")));
        public static final SaveableConfig<ConfigBoolean> RENDER_IN_OTHER_GUI = SaveableConfig.fromConfig((String)"renderInOther", (IConfigBase)new ConfigBoolean(General.translate("renderinother"), true, General.translate("info.renderinother")));
        public static final SaveableConfig<ConfigInteger> SCROLL_TIME = SaveableConfig.fromConfig((String)"scrollTime", (IConfigBase)new ConfigInteger(General.translate("scrolltime"), 200, 1, 2000, General.translate("info.scrolltime")));
        public static final SaveableConfig<ConfigOptionList> SCROLL_TYPE = SaveableConfig.fromConfig((String)"scrollType", (IConfigBase)new ConfigOptionList(General.translate("scrolltype"), (IConfigOptionListEntry)ConfigStorage.Easing.QUART, General.translate("info.scrolltype")));
        public static final SaveableConfig<ConfigBoolean> CHANGE_START_MESSAGE = SaveableConfig.fromConfig((String)"changeStartMessage", (IConfigBase)new ConfigBoolean(General.translate("changeStartMessage"), true, General.translate("info.changeStartMessage")));
        public static final ImmutableList<SaveableConfig<? extends IConfigBase>> OPTIONS = ImmutableList.of(VANILLA_HUD, CHAT_HEADS, TAB_BUTTONS_ON_RIGHT, WIDTH, HEIGHT, X, Y, MESSAGE_SPACE, LINE_SPACE, LEFT_PAD, RIGHT_PAD, BOTTOM_PAD, (Object[])new SaveableConfig[]{TOP_PAD, VISIBILITY, CHAT_SCALE, FADE_TIME, FADE_START, FADE_TYPE, EMPTY_TEXT_COLOR, HUD_LINE_TYPE, ALTERNATE_LINES, STORED_LINES, RENDER_IN_OTHER_GUI, SCROLL_TIME, SCROLL_TYPE, CHANGE_START_MESSAGE});

        public static String translate(String key) {
            return StringUtils.translate((String)("advancedchathud.config.general." + key), (Object[])new Object[0]);
        }
    }

    public static enum Visibility implements IConfigOptionListEntry
    {
        VANILLA("vanilla"),
        ALWAYS("always"),
        FOCUSONLY("focus_only");

        private final String configString;
        private final class_2960 texture;

        private static String translate(String key) {
            return StringUtils.translate((String)("advancedchathud.config.visibility." + key), (Object[])new Object[0]);
        }

        private Visibility(String configString) {
            this.texture = new class_2960("advancedchathud", "textures/gui/chatwindow/" + configString + ".png");
            this.configString = configString;
        }

        public String getStringValue() {
            return this.configString;
        }

        public String getDisplayName() {
            return Visibility.translate(this.configString);
        }

        public Visibility cycle(boolean forward) {
            int id = this.ordinal();
            id = forward ? ++id : --id;
            if (id >= Visibility.values().length) {
                id = 0;
            } else if (id < 0) {
                id = Visibility.values().length - 1;
            }
            return Visibility.values()[id % Visibility.values().length];
        }

        public Visibility fromString(String value) {
            return Visibility.fromVisibilityString(value);
        }

        public static Visibility fromVisibilityString(String visibility) {
            for (Visibility v : Visibility.values()) {
                if (!v.configString.equals(visibility)) continue;
                return v;
            }
            return VANILLA;
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static enum HudLineType implements IConfigOptionListEntry
    {
        FULL("full"),
        COMPACT("compact");

        public final String configString;

        private static String translate(String key) {
            return StringUtils.translate((String)("advancedchathud.config.hudlinetype." + key), (Object[])new Object[0]);
        }

        private HudLineType(String configString) {
            this.configString = configString;
        }

        public String getStringValue() {
            return this.configString;
        }

        public String getDisplayName() {
            return HudLineType.translate(this.configString);
        }

        public IConfigOptionListEntry cycle(boolean forward) {
            int id = this.ordinal();
            id = forward ? ++id : --id;
            if (id >= HudLineType.values().length) {
                id = 0;
            } else if (id < 0) {
                id = HudLineType.values().length - 1;
            }
            return HudLineType.values()[id % HudLineType.values().length];
        }

        public IConfigOptionListEntry fromString(String value) {
            return HudLineType.fromHudLineTypeString(value);
        }

        public static HudLineType fromHudLineTypeString(String hudlinetype) {
            for (HudLineType h : HudLineType.values()) {
                if (!h.configString.equals(hudlinetype)) continue;
                return h;
            }
            return FULL;
        }
    }
}

