/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.darkkronicle.advancedchatcore.config.SaveableConfig;
import io.github.darkkronicle.advancedchatcore.config.options.ConfigColor;
import io.github.darkkronicle.advancedchatcore.interfaces.IJsonSave;
import io.github.darkkronicle.advancedchatcore.util.Colors;
import io.github.darkkronicle.advancedchatcore.util.FindType;
import io.github.darkkronicle.advancedchathud.AdvancedChatHud;
import io.github.darkkronicle.advancedchathud.config.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ChatTab {
    private UUID uuid = UUID.randomUUID();
    private SaveableConfig<ConfigString> name = SaveableConfig.fromConfig((String)"name", (IConfigBase)new ConfigString(ChatTab.translate("name"), "Boring Chat Tab", ChatTab.translate("info.name")));
    private SaveableConfig<ConfigInteger> order = SaveableConfig.fromConfig((String)"order", (IConfigBase)new ConfigInteger(ChatTab.translate("order"), 0, ChatTab.translate("info.order")));
    private List<Match> matches = new ArrayList<Match>(Collections.singleton(new Match("I will match to text!", FindType.LITERAL)));
    private SaveableConfig<ConfigString> startingMessage = SaveableConfig.fromConfig((String)"startingMessage", (IConfigBase)new ConfigString(ChatTab.translate("startingmessage"), "", ChatTab.translate("info.startingmessage")));
    private SaveableConfig<ConfigBoolean> forward = SaveableConfig.fromConfig((String)"forward", (IConfigBase)new ConfigBoolean(ChatTab.translate("forward"), true, ChatTab.translate("info.forward")));
    private SaveableConfig<ConfigString> abbreviation = SaveableConfig.fromConfig((String)"abbreviation", (IConfigBase)new ConfigString(ChatTab.translate("abbreviation"), "BCT", ChatTab.translate("info.abbreviation")));
    private SaveableConfig<ConfigColor> mainColor = SaveableConfig.fromConfig((String)"mainColor", (IConfigBase)new ConfigColor(ChatTab.translate("maincolor"), Colors.getInstance().getColorOrWhite("gray").withAlpha(100), ChatTab.translate("info.maincolor")));
    private SaveableConfig<ConfigColor> borderColor = SaveableConfig.fromConfig((String)"borderColor", (IConfigBase)new ConfigColor(ChatTab.translate("bordercolor"), Colors.getInstance().getColorOrWhite("black").withAlpha(180), ChatTab.translate("info.bordercolor")));
    private SaveableConfig<ConfigColor> innerColor = SaveableConfig.fromConfig((String)"innerColor", (IConfigBase)new ConfigColor(ChatTab.translate("innercolor"), Colors.getInstance().getColorOrWhite("black").withAlpha(100), ChatTab.translate("info.innercolor")));
    private SaveableConfig<ConfigBoolean> showUnread = SaveableConfig.fromConfig((String)"showUnread", (IConfigBase)new ConfigBoolean(ChatTab.translate("showunread"), false, ChatTab.translate("info.showunread")));
    private final ImmutableList<SaveableConfig<?>> options = ImmutableList.of(this.name, this.order, this.startingMessage, this.forward, this.abbreviation, this.mainColor, this.borderColor, this.innerColor, this.showUnread);
    private final ImmutableList<SaveableConfig<?>> mainEditableOptions = ImmutableList.of(this.name, this.order, this.startingMessage, this.abbreviation, this.mainColor, this.borderColor, this.innerColor, this.showUnread);

    private static String translate(String key) {
        return StringUtils.translate((String)("advancedchathud.config.tab." + key), (Object[])new Object[0]);
    }

    public FindType getFind() {
        return this.matches.get(0).getFindType();
    }

    public List<String> getWidgetHoverLines() {
        String translated = StringUtils.translate((String)"advancedchathud.config.tabdescription", (Object[])new Object[0]);
        ArrayList<String> hover = new ArrayList<String>();
        for (String s : translated.split("\n")) {
            hover.add(s.replaceAll(Pattern.quote("<name>"), Matcher.quoteReplacement(((ConfigString)this.name.config).getStringValue())).replaceAll(Pattern.quote("<starting>"), Matcher.quoteReplacement(((ConfigString)this.startingMessage.config).getStringValue())).replaceAll(Pattern.quote("<forward>"), Matcher.quoteReplacement(((ConfigBoolean)this.forward.config).getStringValue())).replaceAll(Pattern.quote("<find>"), Matcher.quoteReplacement(this.matches.get(0).getPattern())).replaceAll(Pattern.quote("<findtype>"), Matcher.quoteReplacement(this.getFind().getDisplayName())).replaceAll(Pattern.quote("<order>"), Matcher.quoteReplacement(((ConfigInteger)this.order.config).getStringValue())));
        }
        return hover;
    }

    public static ChatTab getMainOptions() {
        ChatTab tab = new ChatTab();
        ((ConfigString)tab.getName().config).setValueFromString("Main");
        ((ConfigString)tab.getAbbreviation().config).setValueFromString("Main");
        return tab;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SaveableConfig<ConfigString> getName() {
        return this.name;
    }

    public SaveableConfig<ConfigInteger> getOrder() {
        return this.order;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public SaveableConfig<ConfigString> getStartingMessage() {
        return this.startingMessage;
    }

    public SaveableConfig<ConfigBoolean> getForward() {
        return this.forward;
    }

    public SaveableConfig<ConfigString> getAbbreviation() {
        return this.abbreviation;
    }

    public SaveableConfig<ConfigColor> getMainColor() {
        return this.mainColor;
    }

    public SaveableConfig<ConfigColor> getBorderColor() {
        return this.borderColor;
    }

    public SaveableConfig<ConfigColor> getInnerColor() {
        return this.innerColor;
    }

    public SaveableConfig<ConfigBoolean> getShowUnread() {
        return this.showUnread;
    }

    public ImmutableList<SaveableConfig<?>> getOptions() {
        return this.options;
    }

    public ImmutableList<SaveableConfig<?>> getMainEditableOptions() {
        return this.mainEditableOptions;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setName(SaveableConfig<ConfigString> name) {
        this.name = name;
    }

    public void setOrder(SaveableConfig<ConfigInteger> order) {
        this.order = order;
    }

    public void setMatches(List<Match> matches) {
        this.matches = matches;
    }

    public void setStartingMessage(SaveableConfig<ConfigString> startingMessage) {
        this.startingMessage = startingMessage;
    }

    public void setForward(SaveableConfig<ConfigBoolean> forward) {
        this.forward = forward;
    }

    public void setAbbreviation(SaveableConfig<ConfigString> abbreviation) {
        this.abbreviation = abbreviation;
    }

    public void setMainColor(SaveableConfig<ConfigColor> mainColor) {
        this.mainColor = mainColor;
    }

    public void setBorderColor(SaveableConfig<ConfigColor> borderColor) {
        this.borderColor = borderColor;
    }

    public void setInnerColor(SaveableConfig<ConfigColor> innerColor) {
        this.innerColor = innerColor;
    }

    public void setShowUnread(SaveableConfig<ConfigBoolean> showUnread) {
        this.showUnread = showUnread;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatTab)) {
            return false;
        }
        ChatTab other = (ChatTab)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        SaveableConfig<ConfigString> this$name = this.getName();
        SaveableConfig<ConfigString> other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        SaveableConfig<ConfigInteger> this$order = this.getOrder();
        SaveableConfig<ConfigInteger> other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        List<Match> this$matches = this.getMatches();
        List<Match> other$matches = other.getMatches();
        if (this$matches == null ? other$matches != null : !((Object)this$matches).equals(other$matches)) {
            return false;
        }
        SaveableConfig<ConfigString> this$startingMessage = this.getStartingMessage();
        SaveableConfig<ConfigString> other$startingMessage = other.getStartingMessage();
        if (this$startingMessage == null ? other$startingMessage != null : !this$startingMessage.equals(other$startingMessage)) {
            return false;
        }
        SaveableConfig<ConfigBoolean> this$forward = this.getForward();
        SaveableConfig<ConfigBoolean> other$forward = other.getForward();
        if (this$forward == null ? other$forward != null : !this$forward.equals(other$forward)) {
            return false;
        }
        SaveableConfig<ConfigString> this$abbreviation = this.getAbbreviation();
        SaveableConfig<ConfigString> other$abbreviation = other.getAbbreviation();
        if (this$abbreviation == null ? other$abbreviation != null : !this$abbreviation.equals(other$abbreviation)) {
            return false;
        }
        SaveableConfig<ConfigColor> this$mainColor = this.getMainColor();
        SaveableConfig<ConfigColor> other$mainColor = other.getMainColor();
        if (this$mainColor == null ? other$mainColor != null : !this$mainColor.equals(other$mainColor)) {
            return false;
        }
        SaveableConfig<ConfigColor> this$borderColor = this.getBorderColor();
        SaveableConfig<ConfigColor> other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !this$borderColor.equals(other$borderColor)) {
            return false;
        }
        SaveableConfig<ConfigColor> this$innerColor = this.getInnerColor();
        SaveableConfig<ConfigColor> other$innerColor = other.getInnerColor();
        if (this$innerColor == null ? other$innerColor != null : !this$innerColor.equals(other$innerColor)) {
            return false;
        }
        SaveableConfig<ConfigBoolean> this$showUnread = this.getShowUnread();
        SaveableConfig<ConfigBoolean> other$showUnread = other.getShowUnread();
        if (this$showUnread == null ? other$showUnread != null : !this$showUnread.equals(other$showUnread)) {
            return false;
        }
        ImmutableList<SaveableConfig<?>> this$options = this.getOptions();
        ImmutableList<SaveableConfig<?>> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        ImmutableList<SaveableConfig<?>> this$mainEditableOptions = this.getMainEditableOptions();
        ImmutableList<SaveableConfig<?>> other$mainEditableOptions = other.getMainEditableOptions();
        return !(this$mainEditableOptions == null ? other$mainEditableOptions != null : !this$mainEditableOptions.equals(other$mainEditableOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatTab;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        SaveableConfig<ConfigString> $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        SaveableConfig<ConfigInteger> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        List<Match> $matches = this.getMatches();
        result = result * 59 + ($matches == null ? 43 : ((Object)$matches).hashCode());
        SaveableConfig<ConfigString> $startingMessage = this.getStartingMessage();
        result = result * 59 + ($startingMessage == null ? 43 : $startingMessage.hashCode());
        SaveableConfig<ConfigBoolean> $forward = this.getForward();
        result = result * 59 + ($forward == null ? 43 : $forward.hashCode());
        SaveableConfig<ConfigString> $abbreviation = this.getAbbreviation();
        result = result * 59 + ($abbreviation == null ? 43 : $abbreviation.hashCode());
        SaveableConfig<ConfigColor> $mainColor = this.getMainColor();
        result = result * 59 + ($mainColor == null ? 43 : $mainColor.hashCode());
        SaveableConfig<ConfigColor> $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : $borderColor.hashCode());
        SaveableConfig<ConfigColor> $innerColor = this.getInnerColor();
        result = result * 59 + ($innerColor == null ? 43 : $innerColor.hashCode());
        SaveableConfig<ConfigBoolean> $showUnread = this.getShowUnread();
        result = result * 59 + ($showUnread == null ? 43 : $showUnread.hashCode());
        ImmutableList<SaveableConfig<?>> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        ImmutableList<SaveableConfig<?>> $mainEditableOptions = this.getMainEditableOptions();
        result = result * 59 + ($mainEditableOptions == null ? 43 : $mainEditableOptions.hashCode());
        return result;
    }

    public String toString() {
        return "ChatTab(uuid=" + this.getUuid() + ", name=" + this.getName() + ", order=" + this.getOrder() + ", matches=" + this.getMatches() + ", startingMessage=" + this.getStartingMessage() + ", forward=" + this.getForward() + ", abbreviation=" + this.getAbbreviation() + ", mainColor=" + this.getMainColor() + ", borderColor=" + this.getBorderColor() + ", innerColor=" + this.getInnerColor() + ", showUnread=" + this.getShowUnread() + ", options=" + this.getOptions() + ", mainEditableOptions=" + this.getMainEditableOptions() + ")";
    }

    public static class ChatTabJsonSave
    implements IJsonSave<ChatTab> {
        public ChatTab load(JsonObject obj) {
            ChatTab t = new ChatTab();
            for (SaveableConfig conf : t.getOptions()) {
                IConfigBase option = conf.config;
                if (!obj.has(conf.key)) continue;
                option.setValueFromJsonElement(obj.get(conf.key));
            }
            Match.MatchSerializer serializer = new Match.MatchSerializer();
            JsonElement findArr = obj.get("match");
            if (findArr != null && findArr.isJsonArray()) {
                t.getMatches().clear();
                for (JsonElement o : findArr.getAsJsonArray()) {
                    Match match;
                    if (!o.isJsonObject() || (match = serializer.load(o.getAsJsonObject())) == null) continue;
                    t.getMatches().add(match);
                }
            }
            if (obj.has("uuid")) {
                try {
                    t.setUuid(UUID.fromString(obj.get("uuid").getAsString()));
                }
                catch (Exception e) {
                    AdvancedChatHud.LOGGER.warn("Tab " + ((ConfigString)t.getName().config).getStringValue() + " did not have a UUID. New one will be generated.");
                }
            }
            return t;
        }

        public JsonObject save(ChatTab tab) {
            Match.MatchSerializer serializer = new Match.MatchSerializer();
            JsonObject obj = new JsonObject();
            for (SaveableConfig option : tab.getOptions()) {
                obj.add(option.key, option.config.getAsJsonElement());
            }
            JsonArray find = new JsonArray();
            if (tab.getMatches().size() == 0) {
                tab.getMatches().add(new Match("I will match to text!", FindType.LITERAL));
            }
            for (Match m : tab.getMatches()) {
                find.add((JsonElement)serializer.save(m));
            }
            obj.add("match", (JsonElement)find);
            obj.addProperty("uuid", tab.getUuid().toString());
            return obj;
        }
    }
}

