/*
 * Decompiled with CFR 0.152.
 */
package io.github.darkkronicle.advancedchathud;

import fi.dy.masa.malilib.config.options.ConfigInteger;
import io.github.darkkronicle.advancedchatcore.chat.ChatMessage;
import io.github.darkkronicle.advancedchatcore.interfaces.IChatMessageProcessor;
import io.github.darkkronicle.advancedchathud.HudChatMessage;
import io.github.darkkronicle.advancedchathud.config.HudConfigStorage;
import io.github.darkkronicle.advancedchathud.gui.WindowManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class HudChatMessageHolder
implements IChatMessageProcessor {
    private final List<HudChatMessage> messages = new ArrayList<HudChatMessage>();
    private static final HudChatMessageHolder INSTANCE = new HudChatMessageHolder();

    private HudChatMessageHolder() {
    }

    public static HudChatMessageHolder getInstance() {
        return INSTANCE;
    }

    public void onMessageUpdate(ChatMessage message, IChatMessageProcessor.UpdateType type) {
        HudChatMessage m;
        if (type == IChatMessageProcessor.UpdateType.ADDED) {
            this.addMessage(new HudChatMessage(message));
        } else if (type == IChatMessageProcessor.UpdateType.REMOVE) {
            this.remove(message);
        } else if (type == IChatMessageProcessor.UpdateType.STACK && (m = this.getMessage(message)) != null) {
            WindowManager.getInstance().onStackedMessage(m);
        }
    }

    public void addMessage(HudChatMessage message) {
        this.messages.add(0, message);
        WindowManager.getInstance().onNewMessage(message);
        while (this.messages.size() > ((ConfigInteger)HudConfigStorage.General.STORED_LINES.config).getIntegerValue()) {
            this.messages.remove(this.messages.size() - 1);
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public void remove(ChatMessage message) {
        HudChatMessage remove = this.getMessage(message);
        if (remove != null) {
            this.messages.remove(remove);
            WindowManager.getInstance().onRemoveMessage(remove.getMessage());
        }
    }

    public void removeChatMessage(ChatMessage message) {
        HudChatMessage m = this.getMessageFromContent(message);
        if (m != null) {
            this.messages.remove(m);
            WindowManager.getInstance().onRemoveMessage(message);
        }
    }

    public HudChatMessage getMessage(ChatMessage message) {
        for (HudChatMessage m : this.messages) {
            if (!m.getMessage().getUuid().equals(message.getUuid())) continue;
            return m;
        }
        return null;
    }

    public HudChatMessage getMessageFromContent(ChatMessage message) {
        for (HudChatMessage m : this.messages) {
            if (!m.getMessage().isSimilar(message) || !m.getMessage().getTime().equals(message.getTime())) continue;
            return m;
        }
        return null;
    }

    public List<HudChatMessage> getMessages() {
        return this.messages;
    }
}

